/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.data.http.RefDataMng;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.StdBondForward;
import cms.tmx.entity.data.StdBondForwardDeliver;
import cms.tmx.entity.trade.XSwapStrategy;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class StdBondForwarDeliverModel {
    @Inject
    protected IRefDataMng refMng;
    public Map<String, List<StdBondForwardDeliver>> map = new HashMap<String, List<StdBondForwardDeliver>>();
    public Map<String, StdBondForward> mapStdBond = new HashMap<String, StdBondForward>();

    @PostConstruct
    public void init() {
        this.refMng.changedProperty().addListener(ob -> this.initSbfwdDeliver());
        this.initSbfwdDeliver();
    }

    private void initSbfwdDeliver() {
        this.map.clear();
        Collection delivers = this.refMng.getItems(new String[]{"SBFWDDELIVER"});
        for (RefItem item : delivers) {
            if (!(item instanceof StdBondForwardDeliver)) continue;
            StdBondForwardDeliver deliver = (StdBondForwardDeliver)item;
            List<StdBondForwardDeliver> list = this.map.get(deliver.getSecurityClass());
            if (list == null) {
                list = new ArrayList<StdBondForwardDeliver>();
                this.map.put(deliver.getSecurityClass(), list);
            }
            list.add(deliver);
        }
    }

    public List<StdBondForwardDeliver> getDeliver(XSwapStrategy strategy) {
        RefItem refItem;
        if (RefDataMng.NEW_SECURITY && (refItem = this.refMng.getItem("FORWARD", strategy.getMarket(), strategy.getSecurityId())) != null && refItem instanceof StdBondForward) {
            return ((StdBondForward)StdBondForward.class.cast(refItem)).getDelivers();
        }
        return this.map.get(strategy.getSecurityId());
    }

    public List<StdBondForwardDeliver> getDeliver(RefItem refItem) {
        if (RefDataMng.NEW_SECURITY && refItem != null && refItem instanceof StdBondForward) {
            return ((StdBondForward)StdBondForward.class.cast(refItem)).getDelivers();
        }
        return this.map.get(refItem.getCode());
    }
}

