/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.control.utils.ConsumerModel;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RepoRefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.trade.models.CcsAccountDistributionModel;
import cms.tmx.utils.MathUtils;
import java.util.Iterator;
import java.util.LinkedList;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class RepoAccountDistributionModel
extends CcsAccountDistributionModel {
    @Inject
    private CcsPositionModel ccsPosModel;
    private long maxNum;
    @Inject
    private ConsumerModel consumer;

    protected void filterSecAcc() {
        this.mapSecDisMxList.keySet().forEach(each -> this.repoShow((MxTreeList<CcsAccountDistribution>)((MxTreeList)this.mapSecDisMxList.get(each))));
    }

    private void repoShow(MxTreeList<CcsAccountDistribution> distList) {
        for (CcsAccountDistribution dist2 : distList.getOrList()) {
            boolean sameMarket = dist2.getSecAcc().getExchange().getRaw().equals(this.refItem.getMarket());
            if (sameMarket && this.isBuy() && dist2.getCanBuy() != 0L) {
                dist2.setShow(true);
                continue;
            }
            if (sameMarket && !this.isBuy()) {
                dist2.setShow(true);
                continue;
            }
            dist2.setShow(false);
        }
        distList.filter(dist -> dist.isShow());
    }

    public void calAccountCanBuy() {
    }

    public void onFundChange() {
        this.accMxList.getOrList().forEach(acc -> this.accMxList.getOrList().forEach(each -> {
            if (each.getAcc().getExtAccntId().equals(acc.getAcc().getExtAccntId())) {
                FundAccount fundAcc = this.fundAccMng.getFundAccount(acc.getAcc().getExtAccntId(), "CCS");
                if (fundAcc == null) {
                    return;
                }
                each.getAcc().update(CcsFundAccount.class.cast(fundAcc));
            }
        }));
    }

    public void calAccountCanStandard() {
        for (String strEach : this.mapSecDisMxList.keySet()) {
            long standerSum = 0L;
            for (CcsAccountDistribution accItem : ((MxTreeList)this.mapSecDisMxList.get(strEach)).getOrList()) {
                int standerNum = this.getStandard(accItem.getSecAcc().getExtSecAccntId());
                accItem.setCanBuy((long)standerNum);
                standerSum += (long)standerNum;
            }
            for (CcsAccountDistribution accItem : this.accMxList.getOrList()) {
                if (!accItem.getAcc().getExtAccntId().equals(strEach)) continue;
                accItem.setCanBuy(standerSum);
            }
        }
    }

    private int getStandard(String secAccntId) {
        int count = 0;
        if (this.refItem == null) {
            return count;
        }
        ObservableList list = this.ccsPosModel.getList();
        RepoRefItem item = (RepoRefItem)RepoRefItem.class.cast(this.refItem);
        for (Position pos : list) {
            if (!pos.getExtSecAccId().equals(secAccntId) || !pos.getSecId().equals(item.getStdSecId()) || !pos.getMarket().getRaw().equals(item.getMarket()) || !(pos instanceof CcsPosition)) continue;
            CcsPosition ccsPos = (CcsPosition)CcsPosition.class.cast(pos);
            count = (int)((long)count + ccsPos.getCanVol());
        }
        return count;
    }

    protected long doAllocateByMin(TreeItem<CcsAccountDistribution> parent, long totalCount) {
        long assigned = 0L;
        LinkedList list = new LinkedList();
        parent.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem)ad) != false).forEach(each -> each.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected()).forEach(subEach -> list.add(subEach)));
        list.sort((o1, o2) -> (int)(((CcsAccountDistribution)o1.getValue()).getCanBuy() - ((CcsAccountDistribution)o2.getValue()).getCanBuy()));
        Iterator it = list.iterator();
        while (it.hasNext()) {
            TreeItem ad2 = (TreeItem)it.next();
            if (!it.hasNext()) {
                long count = MathUtils.calCount((long)(totalCount - assigned), (int)1);
                ((CcsAccountDistribution)ad2.getValue()).setCount(count);
                assigned += count;
                long prCount = ((CcsAccountDistribution)ad2.getParent().getValue()).getCount() + ((CcsAccountDistribution)ad2.getValue()).getCount();
                ((CcsAccountDistribution)ad2.getParent().getValue()).setCount(prCount);
                break;
            }
            if (totalCount - assigned >= ((CcsAccountDistribution)ad2.getValue()).getCanBuy()) {
                ((CcsAccountDistribution)ad2.getValue()).setCount(((CcsAccountDistribution)ad2.getValue()).getCanBuy());
            } else {
                ((CcsAccountDistribution)ad2.getValue()).setCount(totalCount - assigned);
            }
            long prCount = ((CcsAccountDistribution)ad2.getParent().getValue()).getCount() + ((CcsAccountDistribution)ad2.getValue()).getCount();
            ((CcsAccountDistribution)ad2.getParent().getValue()).setCount(prCount);
            if ((assigned += ((CcsAccountDistribution)ad2.getValue()).getCount()) == totalCount) break;
        }
        return assigned;
    }

    protected long calByCanBuy(long totalCount) {
        if (this.getPrice() <= 0.0) {
            return 0L;
        }
        FilteredList list = this.getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem)ad) != false);
        for (TreeItem each : list) {
            totalCount = this.calByCanBuyRatio((TreeItem<CcsAccountDistribution>)each);
            ((CcsAccountDistribution)each.getValue()).setCount(totalCount);
        }
        return totalCount;
    }

    private long calByCanBuyRatio(TreeItem<CcsAccountDistribution> parent) {
        this.clearCount(parent);
        long sum = 0L;
        FilteredList list = parent.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem)ad) != false);
        for (TreeItem ad2 : list) {
            long count = (long)((double)((CcsAccountDistribution)ad2.getValue()).getCanBuy() * this.getPercent());
            count = MathUtils.calCount((long)count, (int)this.getUnit());
            ((CcsAccountDistribution)ad2.getValue()).setCount(count);
            sum += count;
        }
        return sum;
    }

    protected long calByCanSell(long totalCount) {
        FilteredList list = this.getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem)ad) != false);
        for (TreeItem each : list) {
            double availble = ((CcsAccountDistribution)each.getValue()).getAcc().getAvailable();
            int base = this.refItem.getMarket().equals("XSHG") ? 1000 : 100;
            long sum = (long)(availble * this.getPercent() / (double)base);
            sum = MathUtils.calCount((long)sum, (int)this.getUnit());
            this.calByCanSellRatio((TreeItem<CcsAccountDistribution>)each, sum);
            ((CcsAccountDistribution)each.getValue()).setCount(sum);
            totalCount = sum;
        }
        return totalCount;
    }

    protected long calByCanSellMax(long totalCount) {
        FilteredList list = this.getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem)ad) != false);
        long total = totalCount;
        for (TreeItem each : list) {
            double availble = ((CcsAccountDistribution)each.getValue()).getAcc().getAvailable();
            int base = this.refItem.getMarket().equals("XSHG") ? 1000 : 100;
            long sum = (long)(availble / (double)base);
            if (total > (sum = MathUtils.calCount((long)sum, (int)this.getUnit()))) {
                ((CcsAccountDistribution)each.getValue()).setCount(sum);
                totalCount = sum;
                total -= sum;
                this.calByCanSellRatio((TreeItem<CcsAccountDistribution>)each, sum);
                continue;
            }
            ((CcsAccountDistribution)each.getValue()).setCount(total);
            this.calByCanSellRatio((TreeItem<CcsAccountDistribution>)each, total);
            total = 0L;
        }
        return totalCount;
    }

    private void calByCanSellRatio(TreeItem<CcsAccountDistribution> parent, long totalCount) {
        this.clearCount(parent);
        FilteredList list = parent.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem)ad) != false);
        int unit = this.getUnit();
        long assigned = 0L;
        long avg = totalCount / (long)list.size();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            long count;
            TreeItem ad2 = (TreeItem)it.next();
            if (it.hasNext()) {
                count = MathUtils.calCount((long)avg, (int)unit);
                ((CcsAccountDistribution)ad2.getValue()).setCount(count);
                assigned += count;
                continue;
            }
            count = totalCount - assigned;
            count = MathUtils.calCount((long)count, (int)1);
            ((CcsAccountDistribution)ad2.getValue()).setCount(count);
        }
    }

    public void refresh() {
        this.consumer.consume(() -> {
            this.fundAccMng.queryFundAccountList();
            this.getPosModel().query();
            this.calAccountCanStandard();
        }, 5);
    }

    public void calAccountCanSell() {
        this.calAccountCanStandard();
        this.calMaxNum();
    }

    public void calMaxNum() {
        for (CcsAccountDistribution accItem : this.accMxList.getOrList()) {
            if (this.getPrice() > 0.0 && this.getUnit() > 0) {
                int base = this.refItem.getMarket().equals("XSHG") ? 1000 : 100;
                long canBuy = (long)(this.getAvailable(accItem) / (double)base);
                canBuy = this.refItem.getMarket().equals("XSHG") ? canBuy / 100L * 100L : canBuy / 10L * 10L;
                this.setMaxNum(canBuy);
                accItem.setMaxNumber((double)canBuy);
                continue;
            }
            accItem.setMaxNumber(0.0);
            this.setMaxNum(0L);
            accItem.setCanBuy(0L);
        }
    }

    protected int calSelectedFundAcc() {
        int num = this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected()).size();
        if (num != 1) {
            this.setShowCanBuy(false);
        } else if (this.isRepo() && !this.isBuy() || !this.isRepo() && this.isBuy()) {
            this.setShowCanBuy(true);
        } else if (this.isRepo() && this.isBuy() || !this.isRepo() && !this.isBuy()) {
            int secNum = ((TreeItem)this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected()).get(0)).getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected()).size();
            this.setShowCanBuy(secNum == 1);
        } else {
            this.setShowCanBuy(false);
        }
        if (!this.isBuy() && "6".equals(this.getDistStg())) {
            this.setShowCanBuy(true);
        }
        return num;
    }

    protected void calCanBuyRepoByAvailable(TreeItem<CcsAccountDistribution> item) {
        FilteredList subItemList = item.getParent().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected());
        if (this.getDistStg().equals("6")) {
            long canBuy = 0L;
            for (TreeItem tree : subItemList) {
                canBuy = (long)((double)canBuy + ((CcsAccountDistribution)tree.getValue()).getMaxNumber());
            }
            this.setCanBuy(canBuy);
        } else {
            super.calCanBuyRepoByAvailable(item);
        }
    }

    public long getMaxNum() {
        return this.maxNum;
    }

    public void setMaxNum(long maxNum) {
        this.maxNum = maxNum;
    }
}

