/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.bond.models.RepoAccountDistributionModel;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.models.CcsTradeModel;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PledgeRepoModel
extends CcsTradeModel {
    @Inject
    private RepoAccountDistributionModel repoAccTreeModel;
    private DoubleProperty maxNum = new SimpleDoubleProperty(0.0);

    @PostConstruct
    public void init() {
        this.setTradeType("REPO");
        super.init();
        MxNode node = MxNodeFactory.create((String)"repo_count_stg", (String)"1");
        this.countStgBuy(node);
        this.setCountStg(node);
        node = MxNodeFactory.createNew((String)"acc_dist_mode_repo", (String)"1");
        this.distStgBuy(node);
        this.setDistStg(node);
        ((CcsAccountDistribution)this.getAccDisModel().getRoot().getValue()).maxNumberProperty().bind((ObservableValue)this.maxNum);
    }

    protected void countStgBuy(MxNode node) {
        this.removeOthers(node, "1");
        node.addNode("3");
    }

    protected void countStgSell(MxNode node) {
        this.removeOthers(node, "1");
        node.addNode("4");
    }

    protected void distStgBuy(MxNode node) {
        if (this.distStgIsDisable()) {
            return;
        }
        this.removeOthers(node, "1");
        node.addNode("2");
        node.addNode("3");
        node.setRaw("1");
        this.setDistStg(node);
    }

    protected void distStgSell(MxNode node) {
        if (this.distStgIsDisable()) {
            return;
        }
        node.removeOthersAndAddThis("6");
        node.addNode("1");
        node.addNode("2");
        node.setRaw("6");
        this.setDistStg(node);
    }

    protected void changeMarketPriceType() {
    }

    protected void filterAcc() {
        if (!this.isValidRef()) {
            this.getAccDisModel().setRefItem(null);
            this.getAccDisModel().clearCanBuySell(this.getAccDisModel().getRoot());
            this.getAccDisModel().filterAcc();
            return;
        }
        this.getAccDisModel().setRefItem(this.getValidRef());
        this.getAccDisModel().calAccountCanStandard();
        this.getAccDisModel().filterAcc();
    }

    public RepoAccountDistributionModel getAccDisModel() {
        return this.repoAccTreeModel;
    }

    public boolean distStgIsDisable() {
        if (this.getCountStg() == null) {
            return true;
        }
        if ("3".equals(this.getCountStg().getRaw())) {
            return true;
        }
        return "4".equals(this.getCountStg().getRaw());
    }

    public void onSecChange() {
        this.getAccDisModel().setRepo(this.isReverseRepo());
        super.onSecChange();
    }

    public void onBsChange() {
        this.getAccDisModel().setRepo(this.isReverseRepo());
        super.onBsChange();
    }

    public boolean isReverseRepo() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("REPO");
    }

    public List<CcsSingleEntrust> getEntrustList() {
        LinkedList<CcsSingleEntrust> list = new LinkedList<CcsSingleEntrust>();
        for (TreeItem fundItem : this.getSelectedItems(this.getAccDisModel().getRoot())) {
            for (TreeItem secItem : this.getNoZeroItems(fundItem)) {
                String fundAcc = ((CcsAccountDistribution)fundItem.getValue()).getAcc().getExtAccntId();
                String secAcc = ((CcsAccountDistribution)secItem.getValue()).getSecAcc().getExtSecAccntId();
                CcsSingleEntrust en = this.createEntrust(fundAcc, secAcc);
                en.setFundAccount((FundAccount)((CcsAccountDistribution)fundItem.getValue()).getAcc());
                en.setSecAccount(((CcsAccountDistribution)secItem.getValue()).getSecAcc());
                en.setInvestorId(((CcsAccountDistribution)fundItem.getValue()).getAcc().getInvestId());
                en.setInvestorSecId(((CcsAccountDistribution)secItem.getValue()).getSecAcc().getInverstorSecId());
                en.setSec(this.mktItem.getRefItem().getCode());
                en.setSecName(this.mktItem.getRefItem().getName());
                en.setCanBuy(((CcsAccountDistribution)secItem.getValue()).getCanBuy());
                en.setSide(this.isBuy() ? 71 : 70);
                en.setQuantity(((CcsAccountDistribution)secItem.getValue()).getCount());
                en.setMarket(this.mktItem.getRefItem().getMarket());
                en.setSecType(this.mktItem.getRefItem().getType());
                en.setOrderType(50);
                en.setPrice(this.getPrice());
                en.setSec(this.mktItem.getRefItem().getCode());
                en.setAppID("110");
                list.add(en);
            }
        }
        return list;
    }

    public synchronized String submit() throws MException {
        Result result = new Result();
        for (CcsSingleEntrust en : this.getEntrustList()) {
            try {
                en.submit();
                result.operate(true);
            }
            catch (MException mException) {
                result.operate(false);
            }
        }
        return result.getDesc();
    }

    public String getDirection() {
        return this.isBuy() ? "\u6b63\u56de\u8d2d" : "\u9006\u56de\u8d2d";
    }

    protected void calCountDistribution() {
        super.calCountDistribution();
        this.getAccDisModel().calMaxNum();
        long total = this.getAccDisModel().getMaxNum();
        if (this.getCountStg().getRaw().equals("6")) {
            this.setMaxNum(total);
        }
    }

    public final DoubleProperty maxNumProperty() {
        return this.maxNum;
    }

    public final double getMaxNum() {
        return this.maxNumProperty().get();
    }

    public final void setMaxNum(double maxNum) {
        this.maxNumProperty().set(maxNum);
    }
}

