/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.bond.models.PledgeAcctDistModel;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.PledgeAcctDist;
import cms.tmx.entity.trade.PledgeInfo;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PledgeOutInTradeModel {
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private BooleanProperty out = new SimpleBooleanProperty(false);
    private BooleanProperty auto = new SimpleBooleanProperty(false);
    private LongProperty count = new SimpleLongProperty();
    private LongProperty singleCount = new SimpleLongProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> accFilterStg = new SimpleObjectProperty();
    private DoubleProperty countPer = new SimpleDoubleProperty();
    private StringProperty tradeType = new SimpleStringProperty();
    private static final Logger logger = LogManager.getLogger(PledgeOutInTradeModel.class);
    @Inject
    protected PledgeAcctDistModel accTreeModel;
    @Inject
    protected CcsEntrustFactory ef;
    private PledgeInfo pledge;

    public void setPledge(RefItem item) {
        this.pledge = (PledgeInfo)item;
    }

    public PledgeInfo getPledge() {
        return this.pledge;
    }

    @PostConstruct
    public void init() {
        this.setTradeType("PLEDGE");
        try {
            this.getAccDisModel().create();
        }
        catch (MException e) {
            logger.error(e.getMessage());
        }
        this.getAccDisModel().outProperty().bind((ObservableValue)this.out);
        this.out.addListener(ob -> this.onBsChange());
        MxNode node = MxNodeFactory.create((String)"pledge_count_stg", (String)"1");
        this.countStgSell(node);
        this.countStg.addListener(ob -> this.onCountStgChange());
        this.setCountStg(node);
        node = MxNodeFactory.create((String)"acc_dist_mode_repo", (String)"1");
        this.setDistStg(node);
        this.accTreeModel.setDistStg(this.getDistStg().getRaw());
        this.distStg.addListener(ob -> this.onDistStgChange());
        node = MxNodeFactory.create((String)"acc_count_filter", (String)"1");
        this.accFilterStg.addListener(ob -> this.onAccFilterStgChange());
        this.setAccFilterStg(node);
        this.count.addListener(ob -> this.onCountChange());
        ((PledgeAcctDist)this.accTreeModel.getRoot().getValue()).countProperty().bind((ObservableValue)this.count);
        this.accTreeModel.percentProperty().bind((ObservableValue)Bindings.multiply((double)0.01, (ObservableNumberValue)this.countPer));
        this.countPer.addListener(ob -> this.onCountPerChange());
        this.accTreeModel.changedProperty().addListener(ob -> this.calCountDistribution());
    }

    public void onSecChange() {
        this.pledge = (PledgeInfo)this.getValidRef();
        if (this.pledge != null) {
            this.accTreeModel.setSecurity(this.pledge.getSecCode());
            this.accTreeModel.setCode(this.pledge.getCode());
            this.setName(this.pledge.getName());
        }
        this.setCount(0L);
        this.accTreeModel.setRefItem(this.getValidRef());
        this.calAccountCanInOut();
        this.accTreeModel.filterAcc();
    }

    private void onBsChange() {
        MxNode nodeCountStg = this.getCountStg();
        if (this.isOut()) {
            this.countStgBuy(nodeCountStg);
        } else {
            this.countStgSell(nodeCountStg);
        }
        this.accTreeModel.filterAcc();
    }

    private void onDistStgChange() {
        this.accTreeModel.setDistStg(this.getDistStg().getRaw());
        this.calCountDistribution();
    }

    private void onCountStgChange() {
        this.accTreeModel.setCountStg(this.getCountStg().getRaw());
        this.calCountDistribution();
    }

    private void onCountChange() {
        if (this.getCount() == 0L) {
            this.accTreeModel.clearCount(this.accTreeModel.getRoot());
            return;
        }
        this.calCountDistribution();
    }

    private void onCountPerChange() {
        this.calCountDistribution();
    }

    private void onAccFilterStgChange() {
        this.accTreeModel.setAccFilterStg(this.getAccFilterStg().getRaw());
        this.accTreeModel.setCustomSecAccCount(this.accTreeModel.getEffectiveSecAccCount());
    }

    private void calCountDistribution() {
        if (!this.isValidRef()) {
            this.accTreeModel.clearCount(this.accTreeModel.getRoot());
            return;
        }
        long total = this.accTreeModel.allocateCount();
        if (this.setCaledCount()) {
            this.setCount(total);
        }
    }

    protected void calAccountCanInOut() {
        if (!this.isValidRef()) {
            this.accTreeModel.clearCanBuySell(this.accTreeModel.getRoot());
            return;
        }
        this.accTreeModel.calAccountCanIn();
        this.accTreeModel.calAccountCanOut();
        this.accTreeModel.calAccountTotal();
    }

    public BooleanProperty outProperty() {
        return this.out;
    }

    public boolean isOut() {
        return this.outProperty().get();
    }

    public void setOut(boolean out) {
        this.outProperty().set(out);
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public synchronized String submit() {
        Result result = new Result();
        for (CcsSingleEntrust en : this.getEntrustList()) {
            try {
                en.submit();
                result.operate(true);
            }
            catch (MException mException) {
                result.operate(false);
            }
        }
        return result.getDesc();
    }

    public List<CcsSingleEntrust> getEntrustList() {
        PledgeInfo pledge = (PledgeInfo)this.getValidRef();
        LinkedList<CcsSingleEntrust> list = new LinkedList<CcsSingleEntrust>();
        for (TreeItem<PledgeAcctDist> fundItem : this.getSelectedItems(this.getAccDisModel().getRoot())) {
            for (TreeItem<PledgeAcctDist> secItem : this.getNoZeroItems(fundItem)) {
                long quantity = ((PledgeAcctDist)secItem.getValue()).getCount();
                while (quantity > 0L) {
                    CcsFundAccount fundAcc = ((PledgeAcctDist)fundItem.getValue()).getAcc();
                    SecAccount secAcc = ((PledgeAcctDist)secItem.getValue()).getSecAcc();
                    CcsSingleEntrust en = this.createEntrust(fundAcc.getExtAccntId(), secAcc.getExtSecAccntId());
                    en.setFundAccount((FundAccount)fundAcc);
                    en.setSecAccount(secAcc);
                    en.setInvestorId(fundAcc.getInvestId());
                    en.setInvestorSecId(secAcc.getInverstorSecId());
                    en.setSec(this.getSecurity());
                    en.setSecName(this.getName());
                    en.setCanBuy(((PledgeAcctDist)secItem.getValue()).getCanIn());
                    en.setCanSell(((PledgeAcctDist)secItem.getValue()).getCanOut());
                    en.setSide(this.out.get() ? 83 : 82);
                    if (quantity > 1000000L) {
                        en.setQuantity(1000000L);
                        quantity -= 1000000L;
                    } else {
                        en.setQuantity(quantity);
                        quantity = 0L;
                    }
                    en.setMarket(pledge.getMarket());
                    en.setSecType(pledge.getType());
                    en.setOrderType(50);
                    en.setSec(pledge.getCode());
                    en.setUnderlyingId(pledge.getSecCode());
                    en.setUnderlyingName(pledge.getSecName());
                    en.setUnderlyingMkt(pledge.getMarket());
                    en.setAppID(this.out.get() ? "191" : "190");
                    list.add(en);
                }
            }
        }
        return list;
    }

    public final ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public final MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public final void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public String getDirection() {
        return this.isOut() ? "\u51fa\u5e93" : "\u5165\u5e93";
    }

    public final StringProperty tradeTypeProperty() {
        return this.tradeType;
    }

    public final String getTradeType() {
        return (String)this.tradeTypeProperty().get();
    }

    public final void setTradeType(String tradeType) {
        this.tradeTypeProperty().set((Object)tradeType);
    }

    private void countStgBuy(MxNode node) {
        this.removeOthers(node, "1");
        node.addNode("3");
    }

    private void countStgSell(MxNode node) {
        this.removeOthers(node, "1");
        node.addNode("2");
    }

    public DoubleProperty countPerProperty() {
        return this.countPer;
    }

    public double getCountPer() {
        return this.countPerProperty().get();
    }

    public void setCountPer(double countPer) {
        this.countPerProperty().set(countPer);
    }

    public boolean isValidRef() {
        if (this.pledge == null) {
            return false;
        }
        return this.pledge.getType().equals(this.getTradeType());
    }

    public RefItem getValidRef() {
        if (this.pledge != null) {
            return this.pledge;
        }
        return null;
    }

    private boolean setCaledCount() {
        return this.getCountStg().getRaw().equals("2") || this.getCountStg().getRaw().equals("3");
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public CcsSingleEntrust createEntrust(String acc, String secAcc) {
        return this.ef.createCcsSingle(acc, secAcc);
    }

    public PledgeAcctDistModel getAccDisModel() {
        return this.accTreeModel;
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public LongProperty countProperty() {
        return this.count;
    }

    public long getCount() {
        return this.countProperty().get();
    }

    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public final ObjectProperty<MxNode> accFilterStgProperty() {
        return this.accFilterStg;
    }

    public final MxNode getAccFilterStg() {
        return (MxNode)this.accFilterStgProperty().get();
    }

    public final void setAccFilterStg(MxNode accFilterStg) {
        this.accFilterStgProperty().set((Object)accFilterStg);
    }

    public void setPstAcct(String secAcc, String mkt) {
        this.accTreeModel.clearSelect();
        this.accTreeModel.selectSecAcc(secAcc, mkt);
    }

    public final BooleanProperty autoProperty() {
        return this.auto;
    }

    public final boolean isAuto() {
        return this.autoProperty().get();
    }

    public final void setAuto(boolean auto) {
        this.autoProperty().set(auto);
    }

    public final LongProperty singleCountProperty() {
        return this.singleCount;
    }

    public final long getSingleCount() {
        return this.singleCountProperty().get();
    }

    public final void setSingleCount(long singleCount) {
        this.singleCountProperty().set(singleCount);
    }

    public List<TreeItem<PledgeAcctDist>> getSelectedItems(TreeItem<PledgeAcctDist> tree) {
        return tree.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected());
    }

    public List<TreeItem<PledgeAcctDist>> getNoZeroItems(TreeItem<PledgeAcctDist> tree) {
        return tree.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected() && ((PledgeAcctDist)ad.getValue()).getCount() != 0L);
    }
}

