/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.bond.models.PledgeAccountDistTreeList;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.PledgeAcctDist;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IPostService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.PledgePositionModel;
import cms.tmx.utils.MathUtils;
import cms.tmx.utils.StringUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PledgeAcctDistModel
extends MxModel {
    @Inject
    private CcsAccountMap accMng;
    @Inject
    protected IFundAccountService fundAccMng;
    @Inject
    private PledgePositionModel posModel;
    @Inject
    private MObjFactory of;
    @Inject
    protected IPostService postMng;
    protected MxTreeList<PledgeAcctDist> accMxList;
    protected Map<String, MxTreeList<PledgeAcctDist>> mapSecDisMxList;
    private TreeItem<PledgeAcctDist> root = new TreeItem((Object)new PledgeAcctDist());
    private final int INIT_UNIT = 1;
    private BooleanProperty showCanBuy = new SimpleBooleanProperty(true);
    private LongProperty canBuy = new SimpleLongProperty();
    private BooleanProperty out = new SimpleBooleanProperty(true);
    private StringProperty countStg = new SimpleStringProperty("");
    private StringProperty distStg = new SimpleStringProperty("");
    private StringProperty accFilterStg = new SimpleStringProperty("");
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty security = new SimpleStringProperty("");
    private DoubleProperty percent = new SimpleDoubleProperty();
    private IntegerProperty unit = new SimpleIntegerProperty(1);
    private IntegerProperty unitConvert = new SimpleIntegerProperty(1);
    private boolean countValid = true;
    private Map<CcsFundAccount, List<SecAccount>> mapAccount;
    private final int MAP_CAP = 100;
    private IntegerProperty effectiveSecAccCount = new SimpleIntegerProperty();
    private IntegerProperty customSecAccCount = new SimpleIntegerProperty();
    private StringProperty searchSec = new SimpleStringProperty("");
    private BooleanProperty single = new SimpleBooleanProperty(false);
    protected RefItem refItem;
    private ListChangeListener<FundAccount> fundListLst = new ListChangeListener<FundAccount>(){

        public void onChanged(ListChangeListener.Change<? extends FundAccount> change) {
            while (change.next()) {
                if (!change.wasReplaced()) continue;
                for (FundAccount acc : change.getList()) {
                    if (!(acc instanceof CcsFundAccount)) continue;
                    PledgeAcctDistModel.this.onFundChange((CcsFundAccount)CcsFundAccount.class.cast(acc));
                }
            }
        }
    };
    protected InvalidationListener lstPosition = ob -> {
        this.calAccountCanIn();
        this.calAccountCanOut();
        this.calAccountTotal();
        this.filterAcc();
    };
    private Predicate<PledgeAcctDist> pdShow = dist -> dist.isShow();

    @PostConstruct
    public void init() {
        if (this.posModel.getList().size() == 0) {
            this.posModel.query();
        }
    }

    @PreDestroy
    private void close() {
        this.fundAccMng.getFundAccountList().removeListener(this.fundListLst);
    }

    public void setRefItem(RefItem item) {
        this.refItem = item;
    }

    public TreeItem<PledgeAcctDist> getRoot() {
        return this.root;
    }

    public synchronized TreeItem<PledgeAcctDist> create() throws MException {
        this.posModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstPosition));
        this.mapAccount = this.accMng.getAccountMap();
        this.createTree();
        this.fundAccMng.getFundAccountList().addListener(this.fundListLst);
        this.out.addListener(ob -> this.calCanBuy());
        this.customSecAccCount.addListener(ob -> this.onCtmSecAccCountChange());
        this.effectiveSecAccCount.addListener(ob -> this.onEfSecAccCountChange());
        this.searchSec.addListener(ob -> this.onCtmSecAccCountChange());
        return this.root;
    }

    protected void createTree() throws MException {
        ((PledgeAcctDist)this.root.getValue()).setSelected(true);
        LinkedList<PledgeAcctDist> accList = new LinkedList<PledgeAcctDist>();
        this.mapSecDisMxList = new HashMap<String, MxTreeList<PledgeAcctDist>>(100);
        this.accMxList = new PledgeAccountDistTreeList(this.root, (ObservableList<TreeItem<PledgeAcctDist>>)this.root.getChildren(), accList);
        for (FundAccount fundAccount : this.mapAccount.keySet()) {
            CcsFundAccount fundAcc = (CcsFundAccount)CcsFundAccount.class.cast(fundAccount);
            PledgeAcctDist accDst = (PledgeAcctDist)this.of.create(PledgeAcctDist.class);
            accDst.setAcc(fundAcc);
            accDst.selectedProperty().addListener(ob -> this.onAccSelectChange());
            accList.add(accDst);
            this.accMxList.update(accList);
            LinkedList<PledgeAcctDist> secAccList = new LinkedList<PledgeAcctDist>();
            for (SecAccount secAcc : this.mapAccount.get(fundAccount)) {
                PledgeAcctDist secDst = (PledgeAcctDist)this.of.create(PledgeAcctDist.class);
                secAccList.add(secDst);
                secDst.setIsSecAcc(true);
                secDst.setSecAcc(secAcc);
                secDst.weightProperty().addListener(ob -> this.calCount());
                secDst.setWeight(1);
                secDst.selectedProperty().addListener(ob -> this.calCount());
            }
            PledgeAccountDistTreeList secMxList = new PledgeAccountDistTreeList((TreeItem<PledgeAcctDist>)((TreeItem)this.root.getChildren().get(accList.size() - 1)), (ObservableList<TreeItem<PledgeAcctDist>>)((TreeItem)this.root.getChildren().get(accList.size() - 1)).getChildren(), secAccList);
            this.mapSecDisMxList.put(fundAcc.getExtAccntId(), secMxList);
        }
        this.filterFundAcc();
        this.calEffectiveSecAccCount();
        this.checkSingle();
    }

    private void checkSingle() {
        this.setSingle(this.accMxList.getObList().size() == 1);
        if (!this.isSingle()) {
            return;
        }
        for (MxTreeList<PledgeAcctDist> secMxList : this.mapSecDisMxList.values()) {
            int sh = secMxList.getOrList().filtered(pd -> pd.getSecAcc().getExchange().getRaw().equals("XSHG")).size();
            int sz = secMxList.getOrList().filtered(pd -> pd.getSecAcc().getExchange().getRaw().equals("XSHE")).size();
            this.setSingle(sh < 2);
            if (!this.isSingle()) {
                return;
            }
            this.setSingle(sz < 2);
            if (this.isSingle()) continue;
            return;
        }
        this.mapSecDisMxList.values().forEach(each -> each.getOrList().forEach(sec -> sec.setSelected(true)));
        this.accMxList.getObList().forEach(each -> ((PledgeAcctDist)each.getValue()).setSelected(true));
    }

    public void filterAcc() {
        if (this.refItem == null) {
            this.mapSecDisMxList.keySet().forEach(each -> this.showAll(this.mapSecDisMxList.get(each)));
            this.showAll(this.accMxList);
        } else {
            this.filterSecAcc();
        }
        this.filterFundAcc();
        this.calEffectiveSecAccCount();
        this.filterCtmSec();
        this.filterSearchSec();
        this.calCount();
    }

    protected void filterSecAcc() {
        String exchange = this.refItem.getMarket();
        if (exchange.equals("XSHE")) {
            this.mapSecDisMxList.keySet().forEach(each -> this.showSZ(this.mapSecDisMxList.get(each)));
        } else if (exchange.equals("XSHG")) {
            this.mapSecDisMxList.keySet().forEach(each -> this.showSH(this.mapSecDisMxList.get(each)));
        } else {
            this.mapSecDisMxList.keySet().forEach(each -> this.showAll(this.mapSecDisMxList.get(each)));
        }
    }

    private void filterFundAcc() {
        this.showAll(this.accMxList);
        this.mapSecDisMxList.keySet().forEach(each -> {
            if (this.mapSecDisMxList.get(each).getObList().size() == 0) {
                this.accMxList.getOrList().forEach(accEach -> {
                    if (accEach.getAcc().getExtAccntId().equals(each)) {
                        accEach.setShow(false);
                    }
                });
            }
        });
        this.accMxList.filter(this.pdShow);
    }

    private void calEffectiveSecAccCount() {
        int count = 0;
        for (TreeItem item : this.root.getChildren()) {
            count += item.getChildren().size();
        }
        this.setEffectiveSecAccCount(count);
    }

    private void onCtmSecAccCountChange() {
        this.filterAcc();
        this.filterCtmSec();
        this.filterSearchSec();
        this.filterFundAcc();
        this.calCount();
    }

    private void filterCtmSec() {
        int count = this.getCustomSecAccCount();
        for (String strEach : this.mapSecDisMxList.keySet()) {
            boolean accShow = false;
            for (PledgeAcctDist dist : this.accMxList.getOrList()) {
                if (!dist.isShow() || !dist.getAcc().getExtAccntId().equals(strEach)) continue;
                accShow = true;
            }
            if (accShow) {
                int size = this.mapSecDisMxList.get(strEach).getOrList().filtered(pd -> pd.isShow()).size();
                FilteredList showList = this.mapSecDisMxList.get(strEach).getOrList().filtered(pd -> pd.isShow());
                if (count <= 0) {
                    showList.forEach(each -> each.setShow(false));
                } else if (count - size < 0) {
                    int i = count;
                    while (i < size) {
                        ((PledgeAcctDist)showList.get(i)).setShow(false);
                        ++i;
                    }
                }
                count -= size;
            }
            this.mapSecDisMxList.get(strEach).filter(this.pdShow);
        }
    }

    private void filterSearchSec() {
        String search = this.getSearchSec();
        if (StringUtils.isEmpty((String)search)) {
            return;
        }
        for (String strEach : this.mapSecDisMxList.keySet()) {
            boolean accShow = false;
            for (PledgeAcctDist dist : this.accMxList.getOrList()) {
                if (!dist.isShow() || !dist.getAcc().getExtAccntId().equals(strEach)) continue;
                accShow = true;
            }
            if (accShow) {
                FilteredList showList = this.mapSecDisMxList.get(strEach).getOrList().filtered(pd -> pd.isShow());
                showList.forEach(each -> {
                    if (!each.getSecAcc().getInverstorSecId().contains(search)) {
                        each.setShow(false);
                    }
                });
            }
            this.mapSecDisMxList.get(strEach).filter(this.pdShow);
        }
    }

    private void onEfSecAccCountChange() {
        if (this.getAccFilterStg().equals("1")) {
            this.setCustomSecAccCount(this.getEffectiveSecAccCount());
            return;
        }
        if (this.getEffectiveSecAccCount() < this.getCustomSecAccCount()) {
            this.setCustomSecAccCount(this.getEffectiveSecAccCount());
        }
    }

    private void showSZ(MxTreeList<PledgeAcctDist> distList) {
        for (PledgeAcctDist dist : distList.getOrList()) {
            if (!dist.getSecAcc().getExchange().getRaw().equals("XSHE")) {
                dist.setShow(false);
                continue;
            }
            if (!this.isOut() && dist.getCanIn() == 0L) {
                dist.setShow(false);
                continue;
            }
            if (this.isOut() && dist.getCanOut() == 0L) {
                dist.setShow(false);
                continue;
            }
            dist.setShow(true);
        }
        distList.filter(this.pdShow);
    }

    private void showSH(MxTreeList<PledgeAcctDist> distList) {
        for (PledgeAcctDist dist : distList.getOrList()) {
            if (!dist.getSecAcc().getExchange().getRaw().equals("XSHG")) {
                dist.setShow(false);
                continue;
            }
            if (!this.isOut() && dist.getCanIn() == 0L) {
                dist.setShow(false);
                continue;
            }
            if (this.isOut() && dist.getCanOut() == 0L) {
                dist.setShow(false);
                continue;
            }
            dist.setShow(true);
        }
        distList.filter(this.pdShow);
    }

    private void showAll(MxTreeList<PledgeAcctDist> distList) {
        distList.getOrList().forEach(each -> each.setShow(true));
        distList.filter(this.pdShow);
    }

    public void updateFund(CcsFundAccount praAcc) {
        this.accMxList.getOrList().forEach(each -> {
            if (each.getAcc().getExtAccntId().equals(praAcc.getExtAccntId())) {
                FundAccount acc = this.fundAccMng.getFundAccount(praAcc.getExtAccntId(), "CCS");
                if (acc == null) {
                    return;
                }
                each.getAcc().update(CcsFundAccount.class.cast(acc));
            }
        });
    }

    public void refresh() {
        this.fundAccMng.queryFundAccountList();
        this.posModel.query();
        this.calCanBuy();
    }

    public void onFundChange(CcsFundAccount acc) {
        this.updateFund(acc);
        Platform.runLater(() -> this.calCanBuy());
    }

    public int getSelectedNum() {
        int i = 0;
        for (TreeItem item : this.root.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected())) {
            for (TreeItem subItem : item.getChildren()) {
                if (!((PledgeAcctDist)subItem.getValue()).isSelected()) continue;
                ++i;
            }
        }
        return i;
    }

    public List<PledgeAcctDist> getValidSecAcc() {
        LinkedList<PledgeAcctDist> list = new LinkedList<PledgeAcctDist>();
        int totalcount = 0;
        this.countValid = true;
        for (TreeItem item : this.root.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected())) {
            for (TreeItem each : item.getChildren()) {
                if (!((PledgeAcctDist)each.getValue()).isSelected() || ((PledgeAcctDist)each.getValue()).getCount() == 0L) continue;
                list.add((PledgeAcctDist)each.getValue());
                totalcount = (int)((long)totalcount + ((PledgeAcctDist)each.getValue()).getCount());
            }
        }
        if (totalcount == 0) {
            this.countValid = false;
        }
        return list;
    }

    private void onAccSelectChange() {
        this.calSelectedFundAcc();
        this.calCount();
        this.calCanBuy();
    }

    private int calSelectedFundAcc() {
        int num = this.root.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected()).size();
        if (this.isOut() || num > 1) {
            this.setShowCanBuy(num == 1);
        } else if (!this.isOut() && num == 1) {
            int secNum = ((TreeItem)this.root.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected()).get(0)).getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected()).size();
            this.setShowCanBuy(secNum == 1);
        } else {
            this.setShowCanBuy(false);
        }
        return num;
    }

    public void calCanBuy() {
        if (this.calSelectedFundAcc() != 1) {
            this.setCanBuy(0L);
            return;
        }
        TreeItem item = (TreeItem)this.root.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected()).get(0);
        if (item == null) {
            return;
        }
        if (this.isOut()) {
            FilteredList subItemList = item.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected());
            if (subItemList.size() == 1) {
                long canout = new Double(this.posModel.getCcsCanOut(((PledgeAcctDist)((TreeItem)subItemList.get(0)).getValue()).getSecAcc(), this.getCode(), this.getSecurity())).longValue();
                this.setCanBuy(canout);
            } else {
                this.setCanBuy(0L);
            }
        } else {
            FilteredList subItemList = item.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected());
            if (subItemList.size() == 1) {
                long canin = new Double(this.posModel.getCcsCanIn(((PledgeAcctDist)((TreeItem)subItemList.get(0)).getValue()).getSecAcc(), this.getSecurity())).longValue();
                this.setCanBuy(canin);
            } else {
                this.setCanBuy(0L);
            }
        }
    }

    public void calAccountCanIn() {
        for (String strEach : this.mapSecDisMxList.keySet()) {
            long canSellTotal = 0L;
            for (PledgeAcctDist subItem : this.mapSecDisMxList.get(strEach).getOrList()) {
                long canSell = new Double(this.posModel.getCcsCanIn(subItem.getSecAcc(), this.getSecurity())).longValue();
                subItem.setCanIn(canSell);
                canSellTotal += canSell;
            }
            for (PledgeAcctDist accItem : this.accMxList.getOrList()) {
                if (!accItem.getAcc().getExtAccntId().equals(strEach)) continue;
                accItem.setCanIn(canSellTotal);
            }
        }
    }

    public void calAccountCanOut() {
        for (String strEach : this.mapSecDisMxList.keySet()) {
            long canOutTotal = 0L;
            for (PledgeAcctDist subItem : this.mapSecDisMxList.get(strEach).getOrList()) {
                long canOut = new Double(this.posModel.getCcsCanOut(subItem.getSecAcc(), this.getCode(), this.getSecurity())).longValue();
                subItem.setCanOut(canOut);
                canOutTotal += canOut;
            }
            for (PledgeAcctDist accItem : this.accMxList.getOrList()) {
                if (!accItem.getAcc().getExtAccntId().equals(strEach)) continue;
                accItem.setCanOut(canOutTotal);
            }
        }
    }

    public void calAccountTotal() {
        for (String strEach : this.mapSecDisMxList.keySet()) {
            long total = 0L;
            for (PledgeAcctDist subItem : this.mapSecDisMxList.get(strEach).getOrList()) {
                long canOut = new Double(this.posModel.getCcsTotal(subItem.getSecAcc(), this.getSecurity())).longValue();
                subItem.setTotal(canOut);
                total += canOut;
            }
            for (PledgeAcctDist accItem : this.accMxList.getOrList()) {
                if (!accItem.getAcc().getExtAccntId().equals(strEach)) continue;
                accItem.setTotal(total);
            }
        }
    }

    private void calCount() {
        for (TreeItem accItem : this.root.getChildren()) {
            int weight = 0;
            for (TreeItem secAccItem : accItem.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected())) {
                weight += ((PledgeAcctDist)secAccItem.getValue()).getWeight();
            }
            ((PledgeAcctDist)accItem.getValue()).setWeight(weight);
        }
        this.changed();
    }

    public long allocateCount() {
        this.clearCount(this.root);
        this.calCanBuy();
        long totalCount = 0L;
        if (this.getCountStg() == null) {
            return 0L;
        }
        switch (this.getCountStg()) {
            case "1": {
                totalCount = this.calByCount(totalCount);
                break;
            }
            case "3": {
                totalCount = this.calByCanOut(totalCount);
                break;
            }
            case "2": {
                totalCount = this.calByCanIn(totalCount);
                break;
            }
            default: {
                this.clearCount(this.root);
            }
        }
        return totalCount;
    }

    private long calByCount(long totalCount) {
        totalCount = this.doQuantityAllocate(this.root);
        if (this.getDistStg().equals("3")) {
            return totalCount;
        }
        this.root.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected()).forEach(each -> this.doQuantityAllocate((TreeItem<PledgeAcctDist>)each));
        return totalCount;
    }

    private long calByCanIn(long totalCount) {
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PledgeAcctDist>)ad) != false)) {
            long count = 0L;
            for (TreeItem eachSub : each.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected())) {
                PledgeAcctDist secAccItem = (PledgeAcctDist)eachSub.getValue();
                long canin = new Double(this.posModel.getCcsCanIn(secAccItem.getSecAcc(), this.getSecurity())).longValue();
                if (this.getPercent() == 1.0) {
                    secAccItem.setCount((long)((double)canin * this.getPercent()));
                } else {
                    secAccItem.setCount((long)((double)canin * this.getPercent()) / (long)this.getUnit() * (long)this.getUnit());
                }
                count += secAccItem.getCount();
                totalCount += secAccItem.getCount();
            }
            ((PledgeAcctDist)each.getValue()).setCount(count);
        }
        return totalCount;
    }

    private long calByCanOut(long totalCount) {
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PledgeAcctDist>)ad) != false)) {
            long count = 0L;
            for (TreeItem eachSub : each.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected())) {
                PledgeAcctDist secAccItem = (PledgeAcctDist)eachSub.getValue();
                long canout = new Double(this.posModel.getCcsCanOut(secAccItem.getSecAcc(), this.getCode(), this.getSecurity())).longValue();
                if (this.getPercent() == 1.0) {
                    secAccItem.setCount((long)((double)canout * this.getPercent()));
                } else {
                    secAccItem.setCount((long)((double)canout * this.getPercent()) / (long)this.getUnit() * (long)this.getUnit());
                }
                count += secAccItem.getCount();
                totalCount += secAccItem.getCount();
            }
            ((PledgeAcctDist)each.getValue()).setCount(count);
        }
        return totalCount;
    }

    private long doQuantityAllocate(TreeItem<PledgeAcctDist> parent, long pTotal) {
        int totalWeight = 0;
        long totalCount = pTotal;
        this.clearCount(parent);
        int countAcc = parent.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PledgeAcctDist>)ad) != false).size();
        for (TreeItem ad2 : parent.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PledgeAcctDist>)ad) != false)) {
            totalWeight += 100 * ((PledgeAcctDist)ad2.getValue()).getWeight();
        }
        long assigned = 0L;
        if (this.getDistStg().equals("3")) {
            return this.doAllocateByMin(parent, totalCount);
        }
        Iterator it = parent.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PledgeAcctDist>)ad) != false).iterator();
        while (it.hasNext()) {
            TreeItem ad3 = (TreeItem)it.next();
            if (!it.hasNext()) {
                long count = MathUtils.calCount((long)(totalCount - assigned), (int)1);
                ((PledgeAcctDist)ad3.getValue()).setCount(count);
                assigned += count;
                break;
            }
            long target = 0L;
            if (this.getDistStg().equals("1")) {
                target = totalCount / (long)countAcc;
            } else if (this.getDistStg().equals("2")) {
                target = totalCount * (long)((PledgeAcctDist)ad3.getValue()).getWeight() * 100L / (long)totalWeight;
            }
            long count = MathUtils.calCount((long)target, (int)this.getUnit());
            assigned += count;
            ((PledgeAcctDist)ad3.getValue()).setCount(count);
        }
        return assigned;
    }

    private long doQuantityAllocate(TreeItem<PledgeAcctDist> parent) {
        return this.doQuantityAllocate(parent, ((PledgeAcctDist)parent.getValue()).getCount());
    }

    private long doAllocateByMin(TreeItem<PledgeAcctDist> parent, long totalCount) {
        long assigned = 0L;
        LinkedList<TreeItem<PledgeAcctDist>> list = new LinkedList<TreeItem<PledgeAcctDist>>();
        parent.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<PledgeAcctDist>)ad) != false).forEach(each -> each.getChildren().filtered(ad -> ((PledgeAcctDist)ad.getValue()).isSelected()).forEach(subEach -> list.add((TreeItem<PledgeAcctDist>)subEach)));
        list.sort(new CanInComparator());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            TreeItem ad2 = (TreeItem)it.next();
            if (!it.hasNext()) {
                long count = MathUtils.calCount((long)(totalCount - assigned), (int)1);
                ((PledgeAcctDist)ad2.getValue()).setCount(count);
                assigned += count;
                long prCount = ((PledgeAcctDist)ad2.getParent().getValue()).getCount() + ((PledgeAcctDist)ad2.getValue()).getCount();
                ((PledgeAcctDist)ad2.getParent().getValue()).setCount(prCount);
                break;
            }
            if (totalCount - assigned >= ((PledgeAcctDist)ad2.getValue()).getCanIn()) {
                ((PledgeAcctDist)ad2.getValue()).setCount(((PledgeAcctDist)ad2.getValue()).getCanIn());
            } else {
                ((PledgeAcctDist)ad2.getValue()).setCount(totalCount - assigned);
            }
            long prCount = ((PledgeAcctDist)ad2.getParent().getValue()).getCount() + ((PledgeAcctDist)ad2.getValue()).getCount();
            ((PledgeAcctDist)ad2.getParent().getValue()).setCount(prCount);
            if ((assigned += ((PledgeAcctDist)ad2.getValue()).getCount()) == totalCount) break;
        }
        return assigned;
    }

    public void clearCount(TreeItem<PledgeAcctDist> parent) {
        parent.getChildren().forEach(each -> {
            ((PledgeAcctDist)each.getValue()).setCount(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((PledgeAcctDist)sub.getValue()).setCount(0L);
            }
        });
    }

    public void clearCanBuySell(TreeItem<PledgeAcctDist> parent) {
        parent.getChildren().forEach(each -> {
            ((PledgeAcctDist)each.getValue()).setCanOut(0L);
            ((PledgeAcctDist)each.getValue()).setTotal(0L);
            ((PledgeAcctDist)each.getValue()).setCanIn(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((PledgeAcctDist)sub.getValue()).setCanOut(0L);
                ((PledgeAcctDist)sub.getValue()).setTotal(0L);
                ((PledgeAcctDist)sub.getValue()).setCanIn(0L);
            }
        });
    }

    public void clearSelect() {
        this.accMxList.getOrList().forEach(each -> each.setSelected(false));
        this.mapSecDisMxList.keySet().forEach(each -> this.mapSecDisMxList.get(each).getOrList().forEach(subEach -> subEach.setSelected(false)));
    }

    public void selectSecAcc(String secAcc, String mkt) {
        this.mapSecDisMxList.keySet().forEach(each -> {
            for (PledgeAcctDist sub : this.mapSecDisMxList.get(each).getOrList()) {
                if (!sub.getSecAcc().getExtSecAccntId().equals(secAcc) || !sub.getSecAcc().getExchange().getRaw().equals(mkt)) continue;
                this.accMxList.getOrList().filtered(pd -> pd.isShow()).forEach(accEach -> {
                    if (accEach.getAcc().getExtAccntId().equals(each)) {
                        sub.setSelected(true);
                        accEach.setSelected(true);
                    }
                });
                break;
            }
        });
    }

    private Boolean hasSelectedChd(TreeItem<PledgeAcctDist> parent) {
        if (!((PledgeAcctDist)parent.getValue()).isIsSecAcc() && parent.isLeaf()) {
            return false;
        }
        if (!parent.isLeaf() && parent.getChildren().filtered(each -> ((PledgeAcctDist)each.getValue()).isSelected()).size() == 0) {
            return false;
        }
        return true;
    }

    public final StringProperty distStgProperty() {
        return this.distStg;
    }

    public final String getDistStg() {
        return (String)this.distStgProperty().get();
    }

    public final void setDistStg(String distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public final StringProperty countStgProperty() {
        return this.countStg;
    }

    public final String getCountStg() {
        return (String)this.countStgProperty().get();
    }

    public final void setCountStg(String countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public final IntegerProperty unitProperty() {
        return this.unit;
    }

    public final int getUnit() {
        return this.unitProperty().get();
    }

    public final void setUnit(int unit) {
        this.unitProperty().set(unit);
    }

    public final DoubleProperty percentProperty() {
        return this.percent;
    }

    public final double getPercent() {
        return this.percentProperty().get();
    }

    public final void setPercent(double percent) {
        this.percentProperty().set(percent);
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final LongProperty canBuyProperty() {
        return this.canBuy;
    }

    public final long getCanBuy() {
        return this.canBuyProperty().get();
    }

    public final void setCanBuy(long canBuy) {
        this.canBuyProperty().set(canBuy);
    }

    public final BooleanProperty outProperty() {
        return this.out;
    }

    public final boolean isOut() {
        return this.outProperty().get();
    }

    public final void setOut(boolean out) {
        this.outProperty().set(out);
    }

    public Boolean isCountValid() {
        return this.countValid;
    }

    public final BooleanProperty showCanBuyProperty() {
        return this.showCanBuy;
    }

    public final boolean isShowCanBuy() {
        return this.showCanBuyProperty().get();
    }

    public final void setShowCanBuy(boolean showCanBuy) {
        this.showCanBuyProperty().set(showCanBuy);
    }

    public final IntegerProperty unitConvertProperty() {
        return this.unitConvert;
    }

    public final int getUnitConvert() {
        return this.unitConvertProperty().get();
    }

    public final void setUnitConvert(int unitConvert) {
        this.unitConvertProperty().set(unitConvert);
    }

    public final IntegerProperty effectiveSecAccCountProperty() {
        return this.effectiveSecAccCount;
    }

    public final int getEffectiveSecAccCount() {
        return this.effectiveSecAccCountProperty().get();
    }

    public final void setEffectiveSecAccCount(int effectiveSecAccCount) {
        this.effectiveSecAccCountProperty().set(effectiveSecAccCount);
    }

    public final IntegerProperty customSecAccCountProperty() {
        return this.customSecAccCount;
    }

    public final int getCustomSecAccCount() {
        return this.customSecAccCountProperty().get();
    }

    public final void setCustomSecAccCount(int customSecAccCount) {
        this.customSecAccCountProperty().set(customSecAccCount);
    }

    public final StringProperty accFilterStgProperty() {
        return this.accFilterStg;
    }

    public final String getAccFilterStg() {
        return (String)this.accFilterStgProperty().get();
    }

    public final void setAccFilterStg(String accFilterStg) {
        this.accFilterStgProperty().set((Object)accFilterStg);
    }

    public final StringProperty codeProperty() {
        return this.code;
    }

    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public final BooleanProperty singleProperty() {
        return this.single;
    }

    public final boolean isSingle() {
        return this.singleProperty().get();
    }

    public final void setSingle(boolean single) {
        this.singleProperty().set(single);
    }

    public final StringProperty searchSecProperty() {
        return this.searchSec;
    }

    public final String getSearchSec() {
        return (String)this.searchSecProperty().get();
    }

    public final void setSearchSec(String searchSec) {
        this.searchSecProperty().set((Object)searchSec);
    }

    private class CanInComparator
    implements Comparator<TreeItem<PledgeAcctDist>> {
        private CanInComparator() {
        }

        @Override
        public int compare(TreeItem<PledgeAcctDist> o1, TreeItem<PledgeAcctDist> o2) {
            if (((PledgeAcctDist)o1.getValue()).getCanIn() == ((PledgeAcctDist)o2.getValue()).getCanIn()) {
                return 0;
            }
            return ((PledgeAcctDist)o1.getValue()).getCanIn() > ((PledgeAcctDist)o2.getValue()).getCanIn() ? 1 : -1;
        }
    }
}

