/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.trade.HedgeTask;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.strategy.api.StrategyServiceApi;
import cms.tmx.http.api.strategy.dto.EventType;
import cms.tmx.http.api.strategy.dto.GetHedgeTasksReq;
import cms.tmx.http.api.strategy.dto.GetHedgeTasksResp;
import cms.tmx.http.api.strategy.dto.HedgeStatus;
import cms.tmx.http.api.strategy.dto.HedgeTaskInfo;
import cms.tmx.http.api.strategy.dto.HedgeTaskInfoDetails;
import cms.tmx.http.api.strategy.dto.StartHedgeTasksReq;
import cms.tmx.http.api.strategy.dto.StopHedgeTasksReq;
import cms.tmx.http.api.strategy.dto.StrategyEvent;
import cms.tmx.http.api.strategy.dto.UpdateHedgeTaskReq;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.http.utils.RespResult;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.query.utils.QueryModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class HedgeTaskModel
extends MxModel {
    @Inject
    private StrategyServiceApi api;
    @Inject
    private HttpBaseApi httpBaseApi;
    @Inject
    private QueryModel queryModel;
    @Inject
    private MEventService es;
    @Inject
    protected MScheduler sdQuery;
    @Inject
    protected MScheduler sdPush;
    @Inject
    private MxAlert alert;
    private static final int QUERY_INTERVAL = 1000;
    private static final int PUSH_INTERVAL = 1000;
    private MxList<HedgeTask> mlist = new MxList();
    protected Gson gson = GsonFactory.getInstance();
    private MEventHandler handler = event -> this.onPush(event);

    @PostConstruct
    public void init() {
        this.sdQuery.setInterval(1000);
        this.sdPush.setInterval(1000);
        this.es.subscribe("uap.push.HedgeTaskEvent", this.handler);
        this.es.subscribe("requery_data", event -> this.query());
    }

    public void query() {
        this.sdQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                this.logger.error("xbond hedge task query faild", (Throwable)e);
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    private void fullQuery() throws MException {
        GetHedgeTasksReq builder = new GetHedgeTasksReq();
        builder.setOpUser(this.httpBaseApi.getHttpOpUser());
        builder.setPage(this.httpBaseApi.getHttpDefPage());
        builder.setServiceType("XBOND_MARKET_MAKING");
        GetHedgeTasksResp tasks = this.api.getHedgeTasks(builder);
        this.updateData(tasks.getTaskInfo());
    }

    protected void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        StrategyEvent strategyEvent = (StrategyEvent)this.gson.fromJson((JsonElement)obj, StrategyEvent.class);
        HedgeTaskInfo taskInfo = (HedgeTaskInfo)this.gson.fromJson(strategyEvent.getDetails(), HedgeTaskInfo.class);
        if (!taskInfo.getInstrument().getSecurityType().contains("BOND")) {
            return;
        }
        HedgeTask task = new HedgeTask();
        task.update((Object)taskInfo);
        if (strategyEvent.getType().equals((Object)EventType.ADD)) {
            this.mlist.add((MxObject)task);
        } else if (strategyEvent.getType().equals((Object)EventType.UPDATE)) {
            HedgeTask old = (HedgeTask)this.mlist.get((MxObject)task);
            old.update((Object)task);
        } else if (strategyEvent.getType().equals((Object)EventType.DELETE)) {
            this.mlist.remove((MxObject)task);
        }
        this.changed();
    }

    private void updateData(List<HedgeTaskInfo> list) {
        ArrayList<HedgeTask> listTmp = new ArrayList<HedgeTask>();
        if (list != null) {
            for (HedgeTaskInfo info : list) {
                HedgeTask strategy = new HedgeTask();
                strategy.update((Object)info);
                strategy.setExtFundAccntId(this.queryModel.getCtpInvestId(strategy.getExtFundAccntId()));
                strategy.setExtSecAccntId(this.queryModel.getCtpInverstorSecId(strategy.getExtSecAccntId()));
                listTmp.add(strategy);
            }
        }
        this.mlist.update(listTmp);
        this.changed();
    }

    public void update(HedgeTask task) throws MException {
        UpdateHedgeTaskReq builder = new UpdateHedgeTaskReq();
        builder.setOpUser(this.httpBaseApi.getHttpOpUser());
        builder.setServiceType("XBOND_MARKET_MAKING");
        HedgeTaskInfoDetails details = new HedgeTaskInfoDetails();
        details.setHedgePriceCustom(task.getHedgePriceCustom());
        details.setLeavesQty(task.getLeavesQty());
        details.setTimeoutFill(task.getTimeoutFill() * 1000);
        details.setStoplossFill(task.getStoplossFill() / 100.0);
        HedgeTaskInfo info = new HedgeTaskInfo();
        info.setDetails(details);
        info.setTaskId(task.getTaskId());
        info.setHedgeStatus(HedgeStatus.getHedgeStatus((int)Integer.valueOf(task.getHedgeStatus().getRaw())));
        builder.setTaskInfo(info);
        this.api.updateStrategy(builder);
    }

    public RespResult start(List<String> list) throws MException {
        StartHedgeTasksReq builder = new StartHedgeTasksReq();
        builder.setTaskId(list);
        builder.setOpUser(this.httpBaseApi.getHttpOpUser());
        builder.setServiceType("XBOND_MARKET_MAKING");
        RespResult result = this.api.startHedgeTasks(builder);
        return result;
    }

    public RespResult stop(List<String> list) throws MException {
        StopHedgeTasksReq builder = new StopHedgeTasksReq();
        builder.setTaskId(list);
        builder.setOpUser(this.httpBaseApi.getHttpOpUser());
        builder.setServiceType("XBOND_MARKET_MAKING");
        RespResult result = this.api.stopHedgeTasks(builder);
        return result;
    }

    public void finish(HedgeTask task) throws MException {
        UpdateHedgeTaskReq builder = new UpdateHedgeTaskReq();
        builder.setOpUser(this.httpBaseApi.getHttpOpUser());
        builder.setServiceType("XBOND_MARKET_MAKING");
        HedgeTaskInfoDetails details = new HedgeTaskInfoDetails();
        details.setHedgePriceCustom(task.getHedgePriceCustom());
        details.setLeavesQty(task.getLeavesQty());
        details.setTimeoutFill(task.getTimeoutFill() * 1000);
        details.setStoplossFill(task.getStoplossFill() / 100.0);
        HedgeTaskInfo info = new HedgeTaskInfo();
        info.setDetails(details);
        info.setTaskId(task.getTaskId());
        info.setHedgeStatus(HedgeStatus.HEDGE_STATUS_FINISHED);
        builder.setTaskInfo(info);
        this.api.updateStrategy(builder);
    }

    public void changed() {
        this.sdPush.schedule(e -> super.changed());
    }

    public List<HedgeTask> getList() {
        return this.mlist.getList();
    }
}

