/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.control.search.Match;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FormulaModel {
    private static final Map<String, List<Match>> map = new HashMap<String, List<Match>>();
    public static final String XBOND = "xbond";
    public static final String XBOND_YTM = "xbond_ytm";
    public static final String XSWAP = "xswap";
    public static final String XSWAP_XBOND = "xswap_xbond";
    private static final String BID = "BID_";
    private static final String BID_YTM = "BID_YTM_";
    private static final String BID_QTY = "BID_QTY_";
    private static final String ASK = "ASK_";
    private static final String ASK_YTM = "ASK_YTM_";
    private static final String ASK_QTY = "ASK_QTY_";
    public static Map<Integer, String> mapIndex = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(1, "\u4e00");
            this.put(2, "\u4e8c");
            this.put(3, "\u4e09");
            this.put(4, "\u56db");
            this.put(5, "\u4e94");
            this.put(6, "\u516d");
            this.put(7, "\u4e03");
            this.put(8, "\u516b");
            this.put(9, "\u4e5d");
            this.put(10, "\u5341");
        }
    };

    static {
        map.put(XBOND, new LinkedList());
        map.put(XBOND_YTM, new LinkedList());
        map.put(XSWAP_XBOND, new LinkedList());
        map.put(XSWAP, new LinkedList());
        FormulaModel.add("AVG", XBOND, "\u4e70\u4e00\u548c\u5356\u4e00\u7684\u5e73\u5747\u4ef7", XBOND);
        FormulaModel.add("AVG_YTM", XBOND, "\u4e70\u4e00\u548c\u5356\u4e00\u7684\u5e73\u5747\u6536\u76ca\u7387", XBOND);
        FormulaModel.add("PREV", XBOND, "\u6628\u6536\u4ef7", XBOND);
        FormulaModel.add("PREV_YTM", XBOND, "\u6628\u6536\u6536\u76ca\u7387", XBOND);
        FormulaModel.add("LAST", XBOND, "\u6700\u65b0\u6210\u4ea4\u4ef7", XBOND);
        FormulaModel.add("LAST_YTM", XBOND, "\u6700\u65b0\u6210\u4ea4\u6536\u76ca\u7387", XBOND);
        FormulaModel.add("LAST_QTY", XBOND, "\u6700\u65b0\u6210\u4ea4\u91cf", XBOND);
        FormulaModel.add("CB_YTM", null, "\u4e2d\u503a\u4f30\u503c\u6536\u76ca\u7387", XBOND);
        FormulaModel.add("CB_NET_PRICE", null, "\u4e2d\u503a\u51c0\u4ef7\u4f30\u503c", XBOND);
        FormulaModel.add("AGENT_BID_YTM", null, "\u4e2d\u4ecb\u4e70\u6536\u76ca\u7387", XBOND);
        FormulaModel.add("AGENT_ASK_YTM", null, "\u4e2d\u4ecb\u5356\u6536\u76ca\u7387", XBOND);
        FormulaModel.add("AGENT_LAST_YTM", null, "\u4e2d\u4ecb\u6210\u4ea4\u6536\u76ca\u7387", XBOND);
        FormulaModel.add("LAST_FILL_PRICE", XBOND, "\u672c\u7b56\u7565\u6700\u65b0\u6210\u4ea4\u4ef7", XBOND);
        FormulaModel.add("LAST_FILL_YTM", XBOND, "\u672c\u7b56\u7565\u6700\u65b0\u6210\u4ea4\u6536\u76ca\u7387", XBOND);
        FormulaModel.add("LAST_FILL_QTY", XBOND, "\u672c\u7b56\u7565\u6700\u65b0\u6210\u4ea4\u91cf", XBOND);
        FormulaModel.add("UD_  ", null, "\u81ea\u5b9a\u4e49\u884c\u60c5\u5173\u952e\u5b57", XBOND);
        FormulaModel.addBase(BID, XBOND);
        FormulaModel.addBase(ASK, XBOND);
        FormulaModel.addBase(BID_YTM, XBOND);
        FormulaModel.addBase(ASK_YTM, XBOND);
        FormulaModel.addBase(BID_QTY, XBOND);
        FormulaModel.addBase(ASK_QTY, XBOND);
        FormulaModel.add("AVG_YTM", XBOND_YTM, "\u4e70\u4e00\u548c\u5356\u4e00\u7684\u5e73\u5747\u6536\u76ca\u7387", XBOND_YTM);
        FormulaModel.add("PREV_YTM", XBOND_YTM, "\u6628\u6536\u6536\u76ca\u7387", XBOND_YTM);
        FormulaModel.add("LAST_YTM", XBOND_YTM, "\u6700\u65b0\u6210\u4ea4\u6536\u76ca\u7387", XBOND_YTM);
        FormulaModel.add("AGENT_BID_YTM", null, "\u4e2d\u4ecb\u4e70\u6536\u76ca\u7387", XBOND_YTM);
        FormulaModel.add("AGENT_ASK_YTM", null, "\u4e2d\u4ecb\u5356\u6536\u76ca\u7387", XBOND_YTM);
        FormulaModel.add("AGENT_LAST_YTM", null, "\u4e2d\u4ecb\u6210\u4ea4\u6536\u76ca\u7387", XBOND_YTM);
        FormulaModel.add("LAST_FILL_YTM", XBOND_YTM, "\u672c\u7b56\u7565\u6700\u65b0\u6210\u4ea4\u6536\u76ca\u7387", XBOND_YTM);
        FormulaModel.addBase(BID_YTM, XBOND_YTM);
        FormulaModel.addBase(ASK_YTM, XBOND_YTM);
        FormulaModel.add("PRICING_PX", XBOND, "\u5b9a\u4ef7", XSWAP_XBOND);
        map.get(XSWAP_XBOND).addAll((Collection<Match>)map.get(XBOND));
        FormulaModel.add("AVG", XSWAP, "\u4e70\u4e00\u548c\u5356\u4e00\u7684\u5e73\u5747\u4ef7", XSWAP);
        FormulaModel.add("LAST_FILL_PRICE", XSWAP, "\u672c\u7b56\u7565\u6700\u65b0\u6210\u4ea4\u4ef7", XSWAP);
        FormulaModel.add("PRICING_PX", XSWAP, "\u5b9a\u4ef7", XSWAP);
        FormulaModel.addBase(BID, XSWAP);
        FormulaModel.addBase(ASK, XSWAP);
        FormulaModel.addBase(BID_QTY, XSWAP);
        FormulaModel.addBase(ASK_QTY, XSWAP);
    }

    private static void add(String code, String preSymbol, String symbol, String type) {
        Match formula = preSymbol == null ? new Match(code, symbol) : new Match(code, String.valueOf(preSymbol) + symbol);
        List<Match> listMatch = map.get(type);
        listMatch.add(formula);
    }

    private static void addBase(String base, String type) {
        int i = 1;
        while (i <= 10) {
            String code = String.valueOf(base) + i;
            if (XBOND.equals(type)) {
                if (i <= 3) {
                    map.get(XBOND).add(new Match(code, FormulaModel.getBaseSymbol(base, i, XBOND)));
                }
            } else {
                map.get(type).add(new Match(code, FormulaModel.getBaseSymbol(base, i, type)));
            }
            ++i;
        }
    }

    private static String getBaseSymbol(String base, int i, String type) {
        switch (base) {
            case "BID_": {
                return String.valueOf(type) + "\u4e70" + mapIndex.get(i) + "\u4ef7";
            }
            case "ASK_": {
                return String.valueOf(type) + "\u5356" + mapIndex.get(i) + "\u4ef7";
            }
            case "BID_YTM_": {
                return String.valueOf(type) + "\u4e70" + mapIndex.get(i) + "\u6536\u76ca\u7387";
            }
            case "ASK_YTM_": {
                return String.valueOf(type) + "\u5356" + mapIndex.get(i) + "\u6536\u76ca\u7387";
            }
            case "BID_QTY_": {
                return String.valueOf(type) + "\u4e70" + mapIndex.get(i) + "\u91cf";
            }
            case "ASK_QTY_": {
                return String.valueOf(type) + "\u5356" + mapIndex.get(i) + "\u91cf";
            }
        }
        return "";
    }

    public List<Match> values() {
        return map.get(null);
    }

    public Collection<Match> values(String type) {
        return map.get(type);
    }
}

