/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.bond.entrust.BondEntrustFactory;
import cms.tmx.bond.entrust.BondSingleEntrust;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.models.CcsTradeModel;
import java.util.LinkedList;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ConvertibleBondTradeModel
extends CcsTradeModel {
    @Inject
    protected BondEntrustFactory ef;

    @PostConstruct
    public void init() {
        this.setTradeType("OIS");
        super.init();
    }

    public void onSecChange() {
        super.onSecChange();
        this.changeSHBondCvt();
    }

    protected void changeMarketPriceType() {
    }

    private void changeSHBondCvt() {
        this.accTreeModel.setUnitConvert(this.isSHbond() ? 10 : 1);
    }

    public boolean isSHbond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.mktItem.getRefItem().getMarket().equals("XSHG");
    }

    public synchronized ObservableList<Boolean> submit(TreeItem<CcsAccountDistribution> root) {
        ObservableList returnList = FxUtils.newList();
        LinkedList<BondSingleEntrust> enList = new LinkedList<BondSingleEntrust>();
        for (TreeItem treeItem : root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : treeItem.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                BondSingleEntrust en;
                block37: {
                    block36: {
                        en = this.createEntrust(((CcsAccountDistribution)treeItem.getValue()).getAcc().getExtAccntId(), ((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                        en.setSide(200);
                        en.setQuantity(((CcsAccountDistribution)secAcc.getValue()).getCount());
                        en.setMarket(this.mktItem.getRefItem().getMarket());
                        en.setSecType(this.mktItem.getRefItem().getType());
                        if (!this.getPriceStg().getRaw().equals("50")) break block36;
                        en.setOrderType(50);
                        en.setPrice(this.getPrice());
                        break block37;
                    }
                    en.setOrderType(49);
                    switch (this.getPriceStg().getRaw()) {
                        case "SH1": {
                            en.setMaxLevels(5);
                            en.setTif(48);
                            break;
                        }
                        case "SH2": {
                            en.setTif(51);
                            en.setMaxLevels(5);
                            break;
                        }
                        case "SH3": {
                            en.setMaxLevels(1);
                            en.setTif(48);
                            break;
                        }
                        case "SH4": {
                            en.setMaxLevels(0);
                            en.setTif(48);
                            break;
                        }
                        case "SZ1": {
                            en.setTif(48);
                            en.setMaxLevels(1);
                            break;
                        }
                        case "SZ2": {
                            en.setTif(48);
                            en.setMaxLevels(0);
                            break;
                        }
                        case "SZ3": {
                            en.setTif(51);
                            en.setMaxLevels(0);
                            break;
                        }
                        case "SZ4": {
                            en.setTif(51);
                            en.setMaxLevels(5);
                            break;
                        }
                        case "SZ5": {
                            en.setTif(52);
                            en.setMaxLevels(0);
                            break;
                        }
                    }
                }
                en.setSec(this.mktItem.getRefItem().getCode());
                en.setAppID("130");
                enList.add(en);
            }
        }
        for (CcsSingleEntrust ccsSingleEntrust : enList) {
            try {
                ccsSingleEntrust.submit();
                returnList.add((Object)true);
            }
            catch (MException mException) {
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    public BondSingleEntrust createEntrust(String acc, String secAcc) {
        return this.ef.createBondSingle(acc, secAcc);
    }
}

