/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.bond.entrust.BondEntrustFactory;
import cms.tmx.bond.entrust.BondSingleEntrust;
import cms.tmx.trade.models.CcsTradeModel;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BondTradeModel
extends CcsTradeModel {
    @Inject
    protected BondEntrustFactory ef;
    private DoubleProperty totalParValue = new SimpleDoubleProperty();
    private static double PAR_VALUE = 100.0;

    @PostConstruct
    public void init() {
        this.setTradeType("BOND");
        super.init();
        this.countProperty().addListener((ob, old, newV) -> this.totalParValueProperty().set((double)newV.longValue() * this.getParValue()));
    }

    public void onSecChange() {
        super.onSecChange();
        this.changeSHBondCvt();
    }

    protected void changeMarketPriceType() {
    }

    private void changeSHBondCvt() {
        this.accTreeModel.setUnitConvert(this.isSHbond() ? 10 : 1);
    }

    public boolean isSHbond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.mktItem.getRefItem().getMarket().equals("XSHG");
    }

    public BondSingleEntrust createEntrust(String acc, String secAcc) {
        return this.ef.createBondSingle(acc, secAcc);
    }

    private double getParValue() {
        return PAR_VALUE * (double)this.getCvt() / 10000.0;
    }

    public DoubleProperty totalParValueProperty() {
        return this.totalParValue;
    }

    public double getTotalParValue() {
        return this.totalParValueProperty().get();
    }

    public void setTotalParValue(double totalParValue) {
        this.totalParValueProperty().set(totalParValue);
    }
}

