/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.bond.BondUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.strategy.BondStrategy;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.pricingit.CreateJobReq;
import cms.tmx.http.api.pricingit.DeleteJobReq;
import cms.tmx.http.api.pricingit.FeederServiceApi;
import cms.tmx.http.api.pricingit.Job;
import cms.tmx.http.api.pricingit.JobParams;
import cms.tmx.http.api.pricingit.LegParams;
import cms.tmx.http.api.pricingit.ListJobsReq;
import cms.tmx.http.api.pricingit.ListJobsResp;
import cms.tmx.http.api.pricingit.ListQuoteSnapshotsReq;
import cms.tmx.http.api.pricingit.ListQuoteSnapshotsResp;
import cms.tmx.http.api.pricingit.PricingItServiceApi;
import cms.tmx.http.api.pricingit.Quote;
import cms.tmx.http.api.pricingit.QuoteSnapshot;
import cms.tmx.http.api.pricingit.RunJobReq;
import cms.tmx.http.api.pricingit.StopJobReq;
import cms.tmx.http.api.pricingit.UpdateJobReq;
import cms.tmx.javafx.MxModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BondForwardPricingModel
extends MxModel {
    public static boolean isEditting = false;
    private static final Logger logger = LogManager.getLogger(BondForwardPricingModel.class);
    @Inject
    private PricingItServiceApi pricingitService;
    @Inject
    private FeederServiceApi feederService;
    private CopyOnWriteArrayList<BondStrategy> list = new CopyOnWriteArrayList();
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    private MObjFactory of;

    public CopyOnWriteArrayList<BondStrategy> getList() {
        return this.list;
    }

    @PostConstruct
    private void init() {
        this.ses.scheduleAtFixedRate(() -> {
            if (!isEditting) {
                try {
                    this.queryQuotes();
                }
                catch (MException e) {
                    e.printStackTrace();
                }
                this.changed();
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    public OpStatus add(BondStrategy params) throws MException {
        CreateJobReq request = new CreateJobReq();
        request.setParams(this.getByParams(params));
        OpStatus response = this.pricingitService.createJob(request);
        return response;
    }

    public void update(BondStrategy params) throws MException {
        UpdateJobReq request = new UpdateJobReq();
        request.setJobId(params.getContextId());
        request.setParams(this.getByParams(params));
        this.pricingitService.updateJob(request);
    }

    private JobParams getByParams(BondStrategy params) {
        JobParams jobParams = new JobParams();
        Instrument instrument = new Instrument();
        instrument.setSecurityId(params.getInstSecId());
        instrument.setMarket(params.getMarket());
        jobParams.setInstrument(instrument);
        jobParams.setBidIrr(params.getIrr());
        jobParams.setOfferIrr(params.getIrr());
        LegParams leg1 = new LegParams();
        Instrument underlying1 = new Instrument();
        underlying1.setSecurityId(params.getActiveSecId());
        underlying1.setMarket(params.getActiveMarket());
        leg1.setInstrument(underlying1);
        leg1.setBidYield(params.getActiveBidYield() / 100.0);
        leg1.setBidSource(BondUtils.getSource(params.getActiveBidSource()));
        leg1.setOfferYield(params.getActiveOfferYield() / 100.0);
        leg1.setOfferSource(BondUtils.getSource(params.getActiveOfferSource()));
        LegParams leg2 = new LegParams();
        Instrument underlying2 = new Instrument();
        underlying2.setSecurityId(params.getInactiveSecId());
        underlying2.setMarket(params.getInactiveMarket());
        leg2.setInstrument(underlying2);
        leg2.setBidYield(params.getInactiveBidYield() / 100.0);
        leg2.setBidSource(BondUtils.getSource(params.getInactiveBidSource()));
        leg2.setOfferYield(params.getInactiveOfferYield() / 100.0);
        leg2.setOfferSource(BondUtils.getSource(params.getInactiveOfferSource()));
        jobParams.setLegs(new ArrayList());
        jobParams.getLegs().add(leg1);
        jobParams.getLegs().add(leg2);
        if (leg1.getBidYield() > 0.0 || leg1.getOfferYield() > 0.0 || leg2.getBidYield() > 0.0 || leg2.getOfferYield() > 0.0) {
            jobParams.setRunOnce(true);
        }
        jobParams.setBidSpread(params.getSpread());
        jobParams.setOfferSpread(params.getSpread());
        return jobParams;
    }

    public OpStatus start(String contextId) throws MException {
        RunJobReq req = new RunJobReq();
        req.setJobId(contextId);
        OpStatus response = this.pricingitService.RunJob(req);
        return response;
    }

    public OpStatus stop(BondStrategy params) throws MException {
        StopJobReq req = new StopJobReq();
        req.setJobId(params.getContextId());
        OpStatus response = this.pricingitService.StopJob(req);
        return response;
    }

    public OpStatus delete(BondStrategy params) throws MException {
        DeleteJobReq req = new DeleteJobReq();
        req.setJobId(params.getContextId());
        OpStatus response = this.pricingitService.deleteJob(req);
        return response;
    }

    public void query() throws MException {
        ListJobsReq request = new ListJobsReq();
        ListJobsResp response = this.pricingitService.listJobs(request);
        if (response == null) {
            return;
        }
        List jobs = response.getJobs();
        this.list.clear();
        for (Job job : jobs) {
            LegParams leg;
            BondStrategy strategy = (BondStrategy)this.of.create(BondStrategy.class);
            strategy.setContextId(job.getJobId());
            strategy.setName(job.getJobName());
            if (job.getParams() == null) {
                this.list.add(strategy);
                continue;
            }
            strategy.setInstSecId(job.getParams().getInstrument().getSecurityId());
            strategy.setIrr(Double.valueOf(String.format("%.2f", job.getParams().getBidIrr())).doubleValue());
            strategy.getStatus().setRaw(String.valueOf(job.getStatus().ordinal()));
            if (job.getParams().getLegs() != null && job.getParams().getLegs().size() > 0) {
                leg = (LegParams)job.getParams().getLegs().get(0);
                if (leg.getInstrument() != null) {
                    strategy.setActiveSecId(leg.getInstrument().getSecurityId());
                }
                strategy.setActiveBidYield(Double.valueOf(String.format("%.4f", leg.getBidYield() * 100.0)).doubleValue());
                strategy.setActiveOfferYield(Double.valueOf(String.format("%.4f", leg.getOfferYield() * 100.0)).doubleValue());
                strategy.setActiveBidSource(BondUtils.getSourceName(leg.getBidSource(), true));
                strategy.setActiveOfferSource(BondUtils.getSourceName(leg.getOfferSource(), false));
            }
            if (job.getParams().getLegs() != null && job.getParams().getLegs().size() > 1) {
                leg = (LegParams)job.getParams().getLegs().get(1);
                if (leg.getInstrument() != null) {
                    strategy.setInactiveSecId(leg.getInstrument().getSecurityId());
                }
                strategy.setInactiveBidYield(Double.valueOf(String.format("%.4f", leg.getBidYield() * 100.0)).doubleValue());
                strategy.setInactiveOfferYield(Double.valueOf(String.format("%.4f", leg.getOfferYield() * 100.0)).doubleValue());
                strategy.setInactiveBidSource(BondUtils.getSourceName(leg.getBidSource(), true));
                strategy.setInactiveOfferSource(BondUtils.getSourceName(leg.getOfferSource(), false));
            }
            strategy.setSpread(job.getParams().getBidSpread());
            this.list.add(strategy);
        }
        this.queryQuotes();
        this.changed();
    }

    private void queryQuotes() throws MException {
        ListQuoteSnapshotsReq request = new ListQuoteSnapshotsReq();
        ListQuoteSnapshotsResp response = null;
        response = this.feederService.listQuoteSnapshots(request);
        List quotes = response.getSnapshots();
        for (QuoteSnapshot quote : quotes) {
            this.refreshStrategy(quote);
        }
    }

    private void refreshStrategy(QuoteSnapshot snapshot) {
        Quote quote = snapshot.getQuote();
        if (quote.getInstrument() == null) {
            return;
        }
        int i = 0;
        while (i < this.list.size()) {
            BondStrategy strategy = this.list.get(i);
            if (strategy.getContextId().equals(quote.getQuoteId())) {
                List underlyings;
                strategy.setRefBidPx(Double.valueOf(String.format("%.4f", quote.getBidCleanPx())).doubleValue());
                strategy.setRefOfferPx(Double.valueOf(String.format("%.4f", quote.getOfferCleanPx())).doubleValue());
                if (quote.getQuoteType().equals("A")) {
                    strategy.setProjectBid("A");
                    strategy.setProjectOffer("B");
                }
                if (quote.getQuoteType().equals("B")) {
                    strategy.setProjectBid("B");
                    strategy.setProjectOffer("A");
                }
                if ((underlyings = snapshot.getUnderlyings()).size() > 0) {
                    strategy.setActiveBidYieldCalc(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getBidYield() * 100.0)).doubleValue());
                    strategy.setActiveOfferYieldCalc(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getOfferYield() * 100.0)).doubleValue());
                    strategy.setActiveBidCleanPx(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getBidCleanPx())).doubleValue());
                    strategy.setActiveBidDirtyPx(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getBidDirtyPx())).doubleValue());
                    strategy.setActiveOfferCleanPx(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getOfferCleanPx())).doubleValue());
                    strategy.setActiveOfferDirtyPx(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getOfferDirtyPx())).doubleValue());
                    strategy.setActiveInterest(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getAccruedAmt())).doubleValue());
                }
                if (underlyings.size() > 1) {
                    strategy.setInactiveBidYieldCalc(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getBidYield() * 100.0)).doubleValue());
                    strategy.setInactiveOfferYieldCalc(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getOfferYield() * 100.0)).doubleValue());
                    strategy.setInactiveBidCleanPxA(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getBidCleanPx())).doubleValue());
                    strategy.setInactiveBidDirtyPxA(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getBidDirtyPx())).doubleValue());
                    strategy.setInactiveOfferCleanPxA(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getOfferCleanPx())).doubleValue());
                    strategy.setInactiveOfferDirtyPxA(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getOfferDirtyPx())).doubleValue());
                    strategy.setInactiveInterest(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getAccruedAmt())).doubleValue());
                }
                if (underlyings.size() > 2) {
                    strategy.setInactiveBidCleanPxB(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(2)).getBidCleanPx())).doubleValue());
                    strategy.setInactiveBidDirtyPxB(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(2)).getBidDirtyPx())).doubleValue());
                    strategy.setInactiveOfferCleanPxB(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(2)).getOfferCleanPx())).doubleValue());
                    strategy.setInactiveOfferDirtyPxB(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(2)).getOfferDirtyPx())).doubleValue());
                }
            }
            ++i;
        }
    }
}

