/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BondUtils {
    public static String getSource(String source) {
        switch (source) {
            case "OFR_\u6700\u4f18": 
            case "BID_\u6700\u4f18": {
                return "BEST";
            }
            case "OFR_\u56fd\u9645": 
            case "BID_\u56fd\u9645": {
                return "ICAP";
            }
            case "OFR_\u56fd\u5229": 
            case "BID_\u56fd\u5229": {
                return "TP";
            }
            case "OFR_\u4fe1\u5510": 
            case "BID_\u4fe1\u5510": {
                return "TJXT";
            }
            case "OFR_\u4e2d\u8bda": 
            case "BID_\u4e2d\u8bda": {
                return "CBBJ";
            }
            case "OFR_\u5e73\u5b89": 
            case "BID_\u5e73\u5b89": {
                return "PATR";
            }
        }
        return "";
    }

    public static String getSourceName(String source, boolean isBid) {
        if (source == null) {
            return "";
        }
        String bs = "OFR_";
        if (isBid) {
            bs = "BID_";
        }
        switch (source) {
            case "BEST": {
                return String.valueOf(bs) + "\u6700\u4f18";
            }
            case "ICAP": {
                return String.valueOf(bs) + "\u56fd\u9645";
            }
            case "TP": {
                return String.valueOf(bs) + "\u56fd\u5229";
            }
            case "TJXT": {
                return String.valueOf(bs) + "\u4fe1\u5510";
            }
            case "CBBJ": {
                return String.valueOf(bs) + "\u4e2d\u8bda";
            }
            case "PATR": {
                return String.valueOf(bs) + "\u5e73\u5b89";
            }
        }
        return "";
    }

    public static boolean isMatch(String text) {
        Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,})?$");
        Matcher match = pattern.matcher(text);
        return match.matches();
    }
}

