/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.protocol;

import cms.tmx.uap.protocol.Val;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteOrder;

public class ValList {
    private Val val1;
    private Val val2;
    private Val val3;
    private Val val4;
    private int byteLength;

    public int getByteLength() {
        return this.byteLength;
    }

    public Val getVal1() {
        return this.val1;
    }

    public Val getVal2() {
        return this.val2;
    }

    public Val getVal3() {
        return this.val3;
    }

    public Val getVal4() {
        return this.val4;
    }

    private Val getVal(int type) {
        if (this.val1 != null && this.val1.getType() == type) {
            return this.val1;
        }
        if (this.val2 != null && this.val2.getType() == type) {
            return this.val2;
        }
        if (this.val3 != null && this.val3.getType() == type) {
            return this.val3;
        }
        if (this.val4 != null && this.val4.getType() == type) {
            return this.val4;
        }
        return null;
    }

    public String getValStr() {
        Val val = this.getVal(1);
        return val != null ? val.getValStr() : null;
    }

    public long getValLong() {
        Val val = this.getVal(2);
        return val != null ? (long)val.getValInt() : 0L;
    }

    public int getValInt() {
        Val val = this.getVal(2);
        return val != null ? val.getValInt() : 0;
    }

    public float getValFloat() {
        Val val = this.getVal(3);
        return val != null ? val.getValFloat() : 0.0f;
    }

    public byte[] getValBytes() {
        Val val = this.getVal(4);
        return val != null ? val.getValBytes() : null;
    }

    public String getValBytesAsStr() {
        Val val = this.getVal(4);
        return val != null ? val.getValBytesAsStr() : null;
    }

    public ValList(byte[] bytes) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
        buf.order(ByteOrder.BIG_ENDIAN);
        this.decode(buf);
        buf.release();
    }

    public ValList(ByteBuf buf) {
        buf.order(ByteOrder.BIG_ENDIAN);
        this.decode(buf);
    }

    public ValList(Val ... vals) {
        this.val1 = vals[0];
        if (vals.length > 1) {
            this.val2 = vals[1];
        }
        if (vals.length > 2) {
            this.val3 = vals[2];
        }
        if (vals.length > 3) {
            this.val4 = vals[3];
        }
    }

    private void decode(ByteBuf buf) {
        int size = buf.readInt();
        this.byteLength = 4 + size;
        this.val1 = new Val(buf);
        if ((size -= this.val1.getByteLength()) > 0) {
            this.val2 = new Val(buf);
            if ((size -= this.val2.getByteLength()) > 0) {
                this.val3 = new Val(buf);
                if ((size -= this.val3.getByteLength()) > 0) {
                    this.val4 = new Val(buf);
                    size -= this.val4.getByteLength();
                }
            }
        }
        if (size != 0) {
            throw new IllegalArgumentException("Illegal ValList size:" + size);
        }
    }

    public ByteBuf encode() {
        ByteBuf buf1 = this.val1.encode();
        ByteBuf buf2 = this.val2 != null ? this.val2.encode() : null;
        ByteBuf buf3 = this.val3 != null ? this.val3.encode() : null;
        ByteBuf buf4 = this.val4 != null ? this.val4.encode() : null;
        int size = buf1.capacity() + (buf2 != null ? buf2.capacity() : 0) + (buf3 != null ? buf3.capacity() : 0) + (buf4 != null ? buf4.capacity() : 0);
        ByteBuf buf = Unpooled.buffer((int)(4 + size));
        buf.writeInt(size);
        buf.writeBytes(buf1);
        buf1.release();
        if (buf2 != null) {
            buf.writeBytes(buf2);
            buf2.release();
        }
        if (buf3 != null) {
            buf.writeBytes(buf3);
            buf3.release();
        }
        if (buf4 != null) {
            buf.writeBytes(buf4);
            buf4.release();
        }
        this.byteLength = buf.capacity();
        return buf;
    }

    public String toString() {
        return "ValList [val1=" + this.val1 + ", val2=" + this.val2 + ", val3=" + this.val3 + ", val4=" + this.val4 + ", byteLength=" + this.byteLength + "]";
    }
}

