/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.nio.ByteOrder;

public class Val {
    public static final int STRING = 1;
    public static final int INT = 2;
    public static final int FLOAT = 3;
    public static final int BYTES = 4;
    private int type;
    private String valStr;
    private long valInt;
    private float valFloat;
    private byte[] valBytes;
    private int byteLength;

    public int getByteLength() {
        return this.byteLength;
    }

    public Val(byte[] bytes, boolean isDecode) {
        if (isDecode) {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
            buf.order(ByteOrder.BIG_ENDIAN);
            this.decode(buf);
            buf.release();
        } else {
            this.type = 4;
            this.valBytes = bytes;
        }
    }

    public Val(ByteBuf buf) {
        buf.order(ByteOrder.BIG_ENDIAN);
        this.decode(buf);
    }

    public Val(String val) {
        this.type = 1;
        this.valStr = val;
    }

    public Val(int val) {
        this.type = 2;
        this.valInt = val;
    }

    public Val(float val) {
        this.type = 3;
        this.valFloat = val;
    }

    public int getType() {
        return this.type;
    }

    public String getValStr() {
        return this.valStr;
    }

    public long getValLong() {
        return this.valInt;
    }

    public int getValInt() {
        return (int)this.valInt;
    }

    public float getValFloat() {
        return this.valFloat;
    }

    public byte[] getValBytes() {
        return this.valBytes;
    }

    public String getValBytesAsStr() {
        return new String(this.valBytes);
    }

    private void decode(ByteBuf buf) {
        int size = buf.readInt();
        this.byteLength = 5 + size;
        this.type = buf.readByte();
        switch (this.type) {
            case 1: {
                byte[] bytes = new byte[size];
                buf.readBytes(bytes);
                this.valStr = new String(bytes, CharsetUtil.UTF_8);
                break;
            }
            case 2: {
                if (1 == size) {
                    this.valInt = buf.readByte();
                    break;
                }
                if (2 == size) {
                    this.valInt = buf.readShort();
                    break;
                }
                if (4 == size) {
                    this.valInt = buf.readInt();
                    break;
                }
                if (8 == size) {
                    this.valInt = buf.readLong();
                    break;
                }
                throw new IllegalArgumentException("Illegal int size, size=" + size);
            }
            case 3: {
                byte[] bytes = new byte[size];
                buf.readBytes(bytes);
                this.valFloat = Float.parseFloat(new String(bytes, CharsetUtil.UTF_8));
                break;
            }
            case 4: {
                this.valBytes = new byte[size];
                buf.readBytes(this.valBytes);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type:" + this.type);
            }
        }
    }

    public ByteBuf encode() {
        ByteBuf buf = null;
        switch (this.type) {
            case 1: {
                byte[] bytes = this.valStr.getBytes();
                buf = Unpooled.buffer((int)(5 + bytes.length));
                buf.writeInt(bytes.length);
                buf.writeByte(1);
                buf.writeBytes(bytes);
                this.byteLength = buf.capacity();
                return buf;
            }
            case 2: {
                if (this.valInt >= -128L && this.valInt <= 127L) {
                    buf = Unpooled.buffer((int)6);
                    buf.order(ByteOrder.BIG_ENDIAN);
                    buf.writeInt(1);
                    buf.writeByte(2);
                    buf.writeByte((int)this.valInt);
                } else if (this.valInt >= -32768L && this.valInt <= 32767L) {
                    buf = Unpooled.buffer((int)7);
                    buf.order(ByteOrder.BIG_ENDIAN);
                    buf.writeInt(2);
                    buf.writeByte(2);
                    buf.writeShort((int)this.valInt);
                } else if (this.valInt >= Integer.MIN_VALUE && this.valInt <= Integer.MAX_VALUE) {
                    buf = Unpooled.buffer((int)9);
                    buf.order(ByteOrder.BIG_ENDIAN);
                    buf.writeInt(4);
                    buf.writeByte(2);
                    buf.writeInt((int)this.valInt);
                } else if (this.valInt >= Long.MIN_VALUE && this.valInt <= Long.MAX_VALUE) {
                    buf = Unpooled.buffer((int)13);
                    buf.order(ByteOrder.BIG_ENDIAN);
                    buf.writeInt(8);
                    buf.writeByte(2);
                    buf.writeLong(this.valInt);
                }
                this.byteLength = buf.capacity();
                return buf;
            }
            case 3: {
                byte[] bytes = String.valueOf(this.valFloat).getBytes();
                buf = Unpooled.buffer((int)(5 + bytes.length));
                buf.writeInt(bytes.length);
                buf.writeByte(3);
                buf.writeBytes(bytes);
                this.byteLength = buf.capacity();
                return buf;
            }
            case 4: {
                buf = Unpooled.buffer((int)(5 + this.valBytes.length));
                buf.writeInt(this.valBytes.length);
                buf.writeByte(4);
                buf.writeBytes(this.valBytes);
                this.byteLength = buf.capacity();
                return buf;
            }
        }
        throw new IllegalArgumentException("Illegal type:" + this.type);
    }

    public String toString() {
        return "Val [type=" + this.type + ", valStr=" + this.valStr + ", valInt=" + this.valInt + ", valFloat=" + this.valFloat + ", valBytes=" + (this.valBytes != null ? new String(this.valBytes) : null) + ", byteLength=" + this.byteLength + "]";
    }
}

