/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.protocol;

import cms.tmx.uap.protocol.Pack;
import cms.tmx.uap.protocol.UapBody;
import cms.tmx.uap.protocol.UapHeader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteOrder;

public class UapPack
implements Pack {
    private UapHeader header;
    private UapBody body;
    private long lastTime;

    public UapPack(UapHeader header, UapBody body) {
        this.header = header;
        this.body = body;
    }

    public UapPack(UapHeader header) {
        this.header = header;
    }

    public UapPack(UapHeader header, byte[] bodyBytes) {
        this.header = header;
        this.body = new UapBody(bodyBytes);
    }

    public UapPack(byte[] bytes) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
        this.decode(buf);
        buf.release();
    }

    public UapPack(ByteBuf buf) {
        this.decode(buf);
    }

    private void decode(ByteBuf buf) {
        buf.order(ByteOrder.BIG_ENDIAN);
        int hsize = buf.readInt();
        this.header = new UapHeader(buf, hsize);
        if (this.header.getBodyLen() > 0) {
            ByteBuf buf2 = Unpooled.buffer((int)this.header.getBodyLen());
            buf.readBytes(buf2);
            this.body = new UapBody(this.header.getBodyType(), buf2);
            buf2.release();
        }
    }

    @Override
    public ByteBuf encode() {
        if (this.body == null) {
            ByteBuf buf = this.header.encode();
            ByteBuf buf2 = Unpooled.buffer((int)(4 + buf.capacity()));
            buf2.writeInt(buf.capacity());
            buf2.writeBytes(buf);
            buf.release();
            return buf2;
        }
        ByteBuf bodyBuf = this.body.encode();
        this.header.setBodyLen(bodyBuf.capacity());
        this.header.setBodyType(this.body.getBodyType());
        ByteBuf buf = this.header.encode();
        ByteBuf buf2 = Unpooled.buffer((int)(4 + buf.capacity() + bodyBuf.capacity()));
        buf2.writeInt(buf.capacity());
        buf2.writeBytes(buf);
        buf2.writeBytes(bodyBuf);
        buf.release();
        bodyBuf.release();
        return buf2;
    }

    @Override
    public int getServerType() {
        return this.header.getServerType();
    }

    @Override
    public String getRequestID() {
        return this.header.getRequestID();
    }

    public UapHeader getHeader() {
        return this.header;
    }

    public UapBody getBody() {
        return this.body;
    }

    public boolean isSuccess() {
        return this.header.isSuccess();
    }

    public String toString() {
        return "Pack [header=" + this.header + ", body=" + this.body + "]";
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(long lastTime) {
        this.lastTime = lastTime;
    }
}

