/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.protocol;

import cms.tmx.uap.protocol.KeyVal;
import cms.tmx.uap.protocol.KeyValList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.UUID;

public class UapHeader {
    private static final int FIX_SIZE = 20;
    private int Version = 69;
    private int CMD;
    private int ServerType;
    private int RequestNoLen;
    private String RequestNo;
    private int RequestIDLen;
    private String RequestID;
    private int SessCare;
    private int RecCount;
    private int RetCode;
    private int UserType;
    private int UserNoLen;
    private String UserNo;
    private String name;
    private int SessionIdLen;
    private byte[] SessionId;
    private int BodyType;
    private int BodyLen;
    private KeyValList keyValList;
    private int byteLength = 20;

    public boolean isSuccess() {
        return this.RetCode == 0;
    }

    public byte[] getSessionId() {
        return this.SessionId;
    }

    public void setSessionId(byte[] sessionId) {
        this.SessionIdLen = sessionId.length;
        this.SessionId = sessionId;
        this.SessCare = 1;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public int getVersion() {
        return this.Version;
    }

    public int getCMD() {
        return this.CMD;
    }

    public void setCMD(int cmd) {
        this.CMD = cmd;
    }

    public int getServerType() {
        return this.ServerType;
    }

    public void setServerType(int serverType) {
        this.ServerType = serverType;
    }

    public String getRequestNo() {
        return this.RequestNo;
    }

    public int getRequestNoAsInt() {
        return Integer.parseInt(this.RequestNo);
    }

    public void setRequestNo(String requestNo) {
        this.RequestNoLen = requestNo != null ? requestNo.getBytes().length : 0;
        this.RequestNo = requestNo;
    }

    public void genRequestIDIfNull() {
        if (this.RequestID == null) {
            this.RequestID = UUID.randomUUID().toString();
            this.RequestIDLen = this.RequestID.getBytes().length;
        }
    }

    public String getRequestID() {
        return this.RequestID;
    }

    public void setRequestID(String requestID) {
        this.RequestID = requestID;
        this.RequestIDLen = requestID != null ? this.RequestID.getBytes().length : 0;
    }

    public int getSessCare() {
        return this.SessCare;
    }

    public void setSessCare(int sessCare) {
        this.SessCare = sessCare;
    }

    public int getRecCount() {
        return this.RecCount;
    }

    public void setRecCount(int recCount) {
        this.RecCount = recCount;
    }

    public int getRetCode() {
        return this.RetCode;
    }

    public void setRetCode(int retCode) {
        this.RetCode = retCode;
    }

    public int getUserType() {
        return this.UserType;
    }

    public void setUserType(int userType) {
        this.UserType = userType;
    }

    public String getUserNo() {
        return this.UserNo;
    }

    public void setUserNo(String userNo) {
        this.UserNoLen = userNo != null ? userNo.getBytes().length : 0;
        this.UserNo = userNo;
    }

    public int getBodyType() {
        return this.BodyType;
    }

    public void setBodyType(int bodyType) {
        this.BodyType = bodyType;
    }

    public int getBodyLen() {
        return this.BodyLen;
    }

    public void setBodyLen(int bodyLen) {
        this.BodyLen = bodyLen;
    }

    public KeyValList getKeyValList() {
        return this.keyValList;
    }

    public void setKeyValList(KeyValList keyValList) {
        this.keyValList = keyValList;
    }

    public String getErrorMsg() {
        return this.getKVListValue("error_msg");
    }

    public String getKVListValue(String key) {
        KeyVal kv;
        String value = "";
        if (key == null || key.isEmpty()) {
            return value;
        }
        KeyValList list = this.getKeyValList();
        if (list != null && (kv = list.getKeyVal(key)) != null) {
            value = kv.getValList().getValStr();
        }
        return value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UapHeader(int CMD) {
        this.genRequestIDIfNull();
        this.CMD = CMD;
    }

    public UapHeader(byte[] bytes) {
        this.byteLength = bytes.length;
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
        buf.order(ByteOrder.BIG_ENDIAN);
        this.decode(buf);
        buf.release();
    }

    public UapHeader(ByteBuf buf, int headerLength) {
        this.byteLength = headerLength;
        buf.order(ByteOrder.BIG_ENDIAN);
        this.decode(buf);
    }

    private String readString(ByteBuf buf, int length) {
        if (length <= 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        buf.readBytes(bytes);
        return new String(bytes);
    }

    private void decode(ByteBuf buf) {
        int size;
        int keyValListSize;
        int rindex = buf.readerIndex();
        short ver = buf.readUnsignedByte();
        if (ver != this.Version) {
            throw new IllegalArgumentException("Illegal Version:" + ver);
        }
        this.CMD = buf.readUnsignedByte();
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.ServerType = buf.readUnsignedByte();
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.RequestNoLen = buf.readUnsignedByte();
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.RequestNo = this.readString(buf, this.RequestNoLen);
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.RequestIDLen = buf.readUnsignedByte();
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.RequestID = this.readString(buf, this.RequestIDLen);
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.SessCare = buf.readUnsignedByte();
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.RecCount = buf.readShort();
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.RetCode = buf.readInt();
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.UserType = buf.readUnsignedByte();
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.UserNoLen = buf.readUnsignedByte();
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.UserNo = this.readString(buf, this.UserNoLen);
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.SessionIdLen = buf.readUnsignedByte();
        }
        if (buf.readerIndex() - rindex < this.byteLength && this.SessionIdLen > 0) {
            this.SessionId = new byte[this.SessionIdLen];
            buf.readBytes(this.SessionId);
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.BodyType = buf.readUnsignedByte();
        }
        if (buf.readerIndex() - rindex < this.byteLength) {
            this.BodyLen = buf.readInt();
        }
        if (this.RetCode > 0) {
            this.BodyLen = 0;
        }
        if ((keyValListSize = this.byteLength - (size = 20 + this.RequestNoLen + this.RequestIDLen + this.UserNoLen + this.SessionIdLen)) == 2) {
            buf.skipBytes(2);
        } else if (keyValListSize > 2) {
            ByteBuf buf2 = Unpooled.buffer((int)keyValListSize);
            buf.readBytes(buf2);
            this.keyValList = new KeyValList(buf2);
            buf2.release();
        }
    }

    public ByteBuf encode() {
        this.genRequestIDIfNull();
        ByteBuf keyValListBuf = null;
        if (this.keyValList != null) {
            keyValListBuf = this.keyValList.encode();
        }
        int keyValListSize = keyValListBuf != null ? keyValListBuf.capacity() : 0;
        this.byteLength = 20 + this.RequestNoLen + this.RequestIDLen + this.UserNoLen + this.SessionIdLen + keyValListSize;
        ByteBuf buf = Unpooled.buffer((int)this.byteLength);
        buf.writeByte(this.Version);
        buf.writeByte(this.CMD);
        buf.writeByte(this.ServerType);
        buf.writeByte(this.RequestNoLen);
        this.writeString(buf, this.RequestNo);
        buf.writeByte(this.RequestIDLen);
        this.writeString(buf, this.RequestID);
        buf.writeByte(this.SessCare);
        buf.writeShort(this.RecCount);
        buf.writeInt(this.RetCode);
        buf.writeByte(this.UserType);
        buf.writeByte(this.UserNoLen);
        this.writeString(buf, this.UserNo);
        buf.writeByte(this.SessionIdLen);
        if (this.SessionId != null) {
            buf.writeBytes(this.SessionId);
        }
        buf.writeByte(this.BodyType);
        buf.writeInt(this.BodyLen);
        if (keyValListBuf != null) {
            buf.writeBytes(keyValListBuf);
            keyValListBuf.release();
        }
        return buf;
    }

    private void writeString(ByteBuf buf, String str) {
        if (str != null && str.length() > 0) {
            byte[] bytes = str.getBytes();
            buf.writeBytes(bytes);
        }
    }

    public String toString() {
        return "Header [Version=" + this.Version + ", CMD=" + this.CMD + ", ServerType=" + this.ServerType + ", RequestNoLen=" + this.RequestNoLen + ", RequestNo=" + this.RequestNo + ", RequestIDLen=" + this.RequestIDLen + ", RequestID=" + this.RequestID + ", SessCare=" + this.SessCare + ", RecCount=" + this.RecCount + ", RetCode=" + this.RetCode + ", UserType=" + this.UserType + ", UserNoLen=" + this.UserNoLen + ", UserNo=" + this.UserNo + ", SessionIdLen=" + this.SessionIdLen + ", SessionId=" + Arrays.toString(this.SessionId) + ", BodyType=" + this.BodyType + ", BodyLen=" + this.BodyLen + ", keyValList=" + this.keyValList + ", byteLength=" + this.byteLength + "]";
    }
}

