/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.protocol;

import cms.tmx.uap.protocol.UapBody;
import cms.tmx.uap.protocol.UapHeader;
import cms.tmx.uap.protocol.UapPack;

public class UapCmd {
    public static final int KEY_LEN = 10;
    public static final int VALUE_LEN = 50;
    public static final int GET_RSA_KEY = 1;
    public static final int REPLY_ACK = 2;
    public static final int AUTH = 3;
    public static final int GET_CRYPTO_KEY = 4;
    public static final int KEY_GET = 5;
    public static final int REPLY_ACK2 = 6;
    public static final int SEARCH = 7;
    public static final int JOIN = 8;
    public static final int REGISTER = 9;
    public static final int HEARTBEAT = 10;
    public static final int REQUEST = 11;
    public static final int LOGIN = 12;
    public static final int CHANGEPROXY = 13;
    public static final int SERVER_FAIL = 14;
    public static final int ANSWER = 15;
    public static final int REPLACE = 16;
    public static final int SERVER_STOP = 17;
    public static final int LOGOUT = 18;
    public static final int SUBSCRIBE = 19;
    public static final int PUSH = 20;
    public static final int HB_RESPONSE = 42;
    public static final int SEND_AUTH_DATA = 43;
    public static final int REPLY_OK = 44;
    public static final int SEND_AES_KEY = 45;

    public static UapPack sendAuthData(int type) {
        UapHeader head = new UapHeader(43);
        head.setServerType(type);
        return new UapPack(head);
    }

    public static UapPack sendAESKey(int type) {
        UapHeader head = new UapHeader(45);
        head.setServerType(type);
        return new UapPack(head);
    }

    public static UapPack get_rsa_key(int serverType) {
        UapHeader header = new UapHeader(1);
        header.setServerType(serverType);
        return new UapPack(header, null);
    }

    public static UapPack reply_ack(int serverType) {
        UapHeader header = new UapHeader(2);
        header.setServerType(serverType);
        return new UapPack(header, null);
    }

    public static UapPack subscribe(int serverType, byte[] body) {
        UapHeader header = new UapHeader(19);
        header.setServerType(serverType);
        return new UapPack(header, new UapBody(body));
    }

    public static UapPack login(int serverType, byte[] body) {
        UapHeader header = new UapHeader(12);
        header.setServerType(serverType);
        return new UapPack(header, new UapBody(body));
    }

    public static UapPack get_crypto_key(int ServerType) {
        UapHeader header = new UapHeader(4);
        header.setServerType(ServerType);
        return new UapPack(header, null);
    }

    public static UapPack register() {
        UapHeader header = new UapHeader(9);
        return new UapPack(header);
    }

    public static UapPack heartbeat(int ServerType) {
        UapHeader header = new UapHeader(10);
        header.setServerType(ServerType);
        return new UapPack(header, null);
    }

    public static UapPack request(int ServerType, String requestNo, byte[] bodyBytes, String name) {
        UapHeader header = new UapHeader(11);
        header.setServerType(ServerType);
        header.setRequestNo(requestNo);
        header.genRequestIDIfNull();
        header.setName(name);
        return new UapPack(header, bodyBytes);
    }

    public static UapPack request(int ServerType, UapBody body) {
        UapHeader header = new UapHeader(11);
        header.setServerType(ServerType);
        return new UapPack(header, body);
    }
}

