/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.protocol;

import cms.tmx.uap.protocol.KeyVal;
import cms.tmx.uap.protocol.KeyValList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UapBody {
    public static final int KEY_VAL_LIST = 1;
    public static final int USER_DEFINED = 2;
    private int BodyType;
    private List<KeyValList> keyValList;
    private byte[] bytes;
    private int byteLength;

    public int getByteLength() {
        return this.byteLength;
    }

    public int getBodyType() {
        return this.BodyType;
    }

    public List<KeyValList> getKeyValList() {
        return this.keyValList;
    }

    public KeyValList getKeyValList(int index) {
        return this.keyValList.get(index);
    }

    public void addKeyValList(KeyValList kvl) {
        this.keyValList.add(kvl);
    }

    public KeyVal getKeyVal(int index, String key) {
        KeyValList kvl = this.getKeyValList(index);
        return kvl != null ? kvl.getKeyVal(key) : null;
    }

    public UapBody(int BodyType, byte[] bytes) {
        this.BodyType = BodyType;
        this.byteLength = bytes.length;
        if (BodyType == 1) {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
            buf.order(ByteOrder.BIG_ENDIAN);
            this.decode(buf);
            buf.release();
        } else {
            this.bytes = bytes;
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public UapBody(int BodyType, ByteBuf buf) {
        this.BodyType = BodyType;
        this.byteLength = buf.capacity();
        if (BodyType == 1) {
            buf.order(ByteOrder.BIG_ENDIAN);
            this.decode(buf);
        } else {
            this.bytes = new byte[buf.capacity()];
            buf.readBytes(this.bytes);
        }
    }

    public UapBody() {
        this(1);
    }

    public UapBody(byte[] bytes) {
        this.BodyType = 2;
        this.bytes = bytes;
    }

    public UapBody(int BodyType) {
        this.BodyType = BodyType;
        this.keyValList = new ArrayList<KeyValList>();
    }

    public UapBody(KeyValList ... keyValLists) {
        this(1, keyValLists);
    }

    public UapBody(int BodyType, KeyValList ... keyValLists) {
        this.BodyType = BodyType;
        this.keyValList = new ArrayList<KeyValList>();
        KeyValList[] keyValListArray = keyValLists;
        int n = keyValLists.length;
        int n2 = 0;
        while (n2 < n) {
            KeyValList keyValList = keyValListArray[n2];
            this.addKeyValList(keyValList);
            ++n2;
        }
    }

    private void decode(ByteBuf buf) {
        this.keyValList = new ArrayList<KeyValList>();
        while (buf.readableBytes() > 0) {
            KeyValList kvl = new KeyValList(buf);
            this.keyValList.add(kvl);
        }
    }

    public ByteBuf encode() {
        if (this.BodyType == 1) {
            this.byteLength = 0;
            ArrayList<ByteBuf> list = new ArrayList<ByteBuf>();
            for (KeyValList kvl : this.keyValList) {
                ByteBuf buf = kvl.encode();
                list.add(buf);
                this.byteLength += buf.capacity();
            }
            ByteBuf buf = Unpooled.buffer((int)this.byteLength);
            for (ByteBuf src : list) {
                buf.writeBytes(src);
                src.release();
            }
            return buf;
        }
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])this.bytes);
        return buf;
    }

    public String toString() {
        return "Body [BodyType=" + this.BodyType + ", keyValList=" + this.keyValList + ", bytes=" + Arrays.toString(this.bytes) + ", byteLength=" + this.byteLength + "]";
    }
}

