/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.protocol;

import cms.tmx.uap.protocol.KeyVal;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyValList {
    private List<KeyVal> keyVallist;
    private Map<String, KeyVal> kvMap;
    private int byteLength;

    public int getByteLength() {
        return this.byteLength;
    }

    public List<KeyVal> getKeyVallist() {
        return this.keyVallist;
    }

    public KeyVal getKeyVal(String key) {
        return this.kvMap.get(key);
    }

    public void addKeyVal(KeyVal kv) {
        this.keyVallist.add(kv);
        this.kvMap.put(kv.getKey(), kv);
    }

    public KeyValList() {
        this.keyVallist = new ArrayList<KeyVal>();
        this.kvMap = new HashMap<String, KeyVal>();
    }

    public KeyValList(KeyVal ... args) {
        this.keyVallist = new ArrayList<KeyVal>();
        this.kvMap = new HashMap<String, KeyVal>();
        KeyVal[] keyValArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            KeyVal keyVal = keyValArray[n2];
            this.addKeyVal(keyVal);
            ++n2;
        }
    }

    public KeyValList(byte[] bytes) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
        buf.order(ByteOrder.BIG_ENDIAN);
        this.decode(buf);
        buf.release();
    }

    public KeyValList(ByteBuf buf) {
        buf.order(ByteOrder.BIG_ENDIAN);
        this.decode(buf);
    }

    public KeyValList(List<KeyVal> keyVallist) {
        this.keyVallist = keyVallist;
    }

    private void decode(ByteBuf buf) {
        this.keyVallist = new ArrayList<KeyVal>();
        this.kvMap = new HashMap<String, KeyVal>();
        int size = buf.readInt();
        this.byteLength = 4 + size;
        while (size > 0) {
            KeyVal kv = new KeyVal(buf);
            this.keyVallist.add(kv);
            size -= kv.getByteLength();
            this.kvMap.put(kv.getKey(), kv);
        }
        if (size != 0) {
            throw new IllegalArgumentException("Illegal KeyValList size:" + size);
        }
    }

    public ByteBuf encode() {
        this.byteLength = 0;
        ArrayList<ByteBuf> bufList = new ArrayList<ByteBuf>(this.keyVallist.size());
        for (KeyVal kv : this.keyVallist) {
            ByteBuf buf = kv.encode();
            bufList.add(buf);
            this.byteLength += buf.capacity();
        }
        ByteBuf buf = Unpooled.buffer((int)(4 + this.byteLength));
        buf.writeInt(this.byteLength);
        for (ByteBuf buf1 : bufList) {
            buf.writeBytes(buf1);
            buf1.release();
        }
        return buf;
    }

    public String toString() {
        return "KeyValList [keyVallist=" + this.keyVallist + ", byteLength=" + this.byteLength + "]";
    }
}

