/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.protocol;

import cms.tmx.uap.protocol.Val;
import cms.tmx.uap.protocol.ValList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteOrder;

public class KeyVal {
    private String key;
    private ValList valList;
    private int byteLength;

    public int getByteLength() {
        return this.byteLength;
    }

    public String getKey() {
        return this.key;
    }

    public ValList getValList() {
        return this.valList;
    }

    public KeyVal(byte[] bytes) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
        buf.order(ByteOrder.BIG_ENDIAN);
        this.decode(buf);
        buf.release();
    }

    public KeyVal(ByteBuf buf) {
        buf.order(ByteOrder.BIG_ENDIAN);
        this.decode(buf);
    }

    public KeyVal(String key, String val) {
        this.key = key;
        this.valList = new ValList(new Val(val));
    }

    public KeyVal(String key, int val) {
        this.key = key;
        this.valList = new ValList(new Val(val));
    }

    public KeyVal(String key, float val) {
        this.key = key;
        this.valList = new ValList(new Val(val));
    }

    public KeyVal(String key, byte[] val) {
        this.key = key;
        this.valList = new ValList(new Val(val, false));
    }

    public KeyVal(String key, ValList valList) {
        this.key = key;
        this.valList = valList;
    }

    private void decode(ByteBuf buf) {
        byte size = buf.readByte();
        byte[] bytes = new byte[size];
        buf.readBytes(bytes);
        this.key = new String(bytes);
        this.valList = new ValList(buf);
        this.byteLength = 1 + size + this.valList.getByteLength();
    }

    public ByteBuf encode() {
        ByteBuf valBuf = this.valList.encode();
        byte[] bytes = this.key.getBytes();
        this.byteLength = 1 + bytes.length + valBuf.capacity();
        ByteBuf buf = Unpooled.buffer((int)this.byteLength);
        buf.writeByte(bytes.length);
        buf.writeBytes(bytes);
        buf.writeBytes(valBuf);
        valBuf.release();
        return buf;
    }

    public String toString() {
        return "KeyVal [key=" + this.key + ", valList=" + this.valList + ", byteLength=" + this.byteLength + "]";
    }
}

