/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Aes {
    private static final String ALGORTHM = "AES/CBC/NoPadding";
    private static final String AES_IV = "12345678abcdefgh";
    private byte[] iv;
    private byte[] key;

    public Aes(byte[] key) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        this.key = key;
        this.iv = AES_IV.getBytes();
        this.encrypt(this.iv);
    }

    private byte[] padding(byte[] data) {
        int size = data.length;
        int bitsize = size * 8;
        int div = bitsize / 128;
        int rem = (div + 1) * 128 - bitsize;
        int bsize = (128 + rem + bitsize) / 8;
        ByteBuf buf = Unpooled.buffer((int)bsize);
        buf.setIndex(0, 12);
        buf.writeInt(rem);
        int zeroByteSize = rem / 8;
        buf.setIndex(0, buf.writerIndex() + zeroByteSize);
        buf.writeBytes(data);
        buf.resetReaderIndex();
        data = new byte[buf.capacity()];
        buf.readBytes(data);
        buf.release();
        return data;
    }

    private byte[] unpadding(byte[] data) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])data);
        buf.skipBytes(12);
        int zeroByteSize = buf.readInt() / 8;
        buf.skipBytes(zeroByteSize);
        data = new byte[buf.readableBytes()];
        buf.readBytes(data);
        buf.release();
        return data;
    }

    public byte[] encrypt(byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        SecretKeySpec skey = new SecretKeySpec(this.key, "AES");
        Cipher cipher = Cipher.getInstance(ALGORTHM);
        cipher.init(1, (Key)skey, new IvParameterSpec(this.iv));
        data = this.padding(data);
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        SecretKeySpec skey = new SecretKeySpec(this.key, "AES");
        Cipher cipher = Cipher.getInstance(ALGORTHM);
        cipher.init(2, (Key)skey, new IvParameterSpec(this.iv));
        data = cipher.doFinal(data);
        data = this.unpadding(data);
        return data;
    }
}

