/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.parser;

import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.uap.parser.HeadItem;
import cms.tmx.uap.parser.IParseItem;
import cms.tmx.uap.parser.JsonItem;
import cms.tmx.uap.parser.MiseJsonItem;
import cms.tmx.uap.parser.PBItem;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UapParser {
    private static final Logger logger = LogManager.getLogger(UapParser.class);
    @Inject
    private PBItem itemPb;
    @Inject
    private JsonItem itemJson;
    @Inject
    private MiseJsonItem MiseItemJson;

    private IParseItem getItem(String type) {
        if (type.equals("json")) {
            return this.itemJson;
        }
        if (type.equals("mise.json")) {
            return this.MiseItemJson;
        }
        return this.itemPb;
    }

    public void pack(MEvent event) throws MException {
        IParseItem item = this.getItem(event.getStr("parse.type"));
        int method = event.getInt("method_code");
        if (method <= 0) {
            throw new MException(999997, "no method code");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("[pack][%s]", String.valueOf(event.getObj().getClass().getSimpleName()) + ":" + method + ":" + event));
        }
        byte[] body = item.pack(event);
        HeadItem head = new HeadItem();
        head.setFuncNo(method);
        head.setBodyLen(body.length);
        head.setBodyType(item.getBodyType());
        head.setTargetBs(item.getTargetBS());
        byte[] bsHead = head.pack(event);
        byte[] stream = new byte[bsHead.length + body.length];
        System.arraycopy(bsHead, 0, stream, 0, bsHead.length);
        System.arraycopy(body, 0, stream, bsHead.length, body.length);
        event.put((Object)"event_stream", (Object)stream);
    }

    public void parse(MEvent event) throws MException {
        IParseItem item = this.getItem(event.getStr("parse.type"));
        byte[] stream = event.getBytes("event_stream");
        event.remove((Object)"event_stream");
        ByteArrayInputStream in = new ByteArrayInputStream(stream);
        DataInputStream dis = new DataInputStream(in);
        HeadItem head = new HeadItem();
        head.parse(event, dis);
        item.parse(event, dis);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("[parse][%s]: %s", String.valueOf(event.getObj().getClass().getSimpleName()) + ":" + head.getFuncNo(), event));
        }
    }

    public void parsePush(MEvent event) throws MException {
        IParseItem item = this.getItem(event.getStr("parse.type"));
        byte[] stream = event.getBytes("event_stream");
        event.remove((Object)"event_stream");
        ByteArrayInputStream in = new ByteArrayInputStream(stream);
        DataInputStream dis = new DataInputStream(in);
        HeadItem head = new HeadItem();
        head.parse(event, dis);
        int method = head.getFuncNo();
        event.put((Object)"method_code", (Object)method);
        item.parse(event, dis);
    }
}

