/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.parser;

import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.uap.parser.IParseItem;
import cms.tmx.utils.ByteOpUtils;
import com.google.protobuf.AbstractMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PBItem
implements IParseItem {
    private static final String PROTO_PACKAGE_NAME = "cms.tmx.datatype";
    private static final String PARSE_METHOD = "parseFrom";
    private static final String PROTO_USER = "proto.user.PUser";
    private static final String PROTO_USERCONTROL = "proto.user.PUserControl";
    private static final String PROTO_BROKER = "proto.broker.PBroker";
    private static final String PROTO_MISC = "proto.misc.PMisc";
    private static final String PROTO_BASE = "proto.PBase";
    private static final String PROTO_HIERARCHY = "proto.hierarchy.PHierarchy";
    private static final String PROTO_EXTACCNT = "proto.account.PExtAccnt";
    private static final String PROTO_POST = "proto.hierarchy.PPost";
    private static final String PROTO_RBAC = "proto.hierarchy.PRbac";
    private static final String PROTO_EXTFUNDACCNT = "message.PFundAccntService";
    private static final String PROTO_SECACCNT_SERVICE = "message.PSecAccntService";
    private static final String PROTO_POSITIONSERVICE = "message.PPositionService";
    private static final String PROTO_CCSEXTRA = "message.PCcsExtra";
    private static final String PROTO_MARKET_DATA = "proto.marketdata.PMarketData";
    private static final String PROTO_REF_DATA = "message.PRefData";
    private static final String PROTO_REF_DATA_SERVICE = "proto.refdata.PRefDataService";
    private static final String PROTO_PMESSAGE = "message.PMessage";
    private static final String PORDER_SERVICE = "message.POrderService";
    private static final String PROTO_PRBAC = "proto.hierarchy.PRbac";
    private static final String PROTO_PMARKET_DATA = "message.PMarketData";
    private static final String PROTO_PPORTFOLIO = "proto.portfolio.PPortfolio";
    private static final String PROTO_QUOTA = "proto.risk.PQuota";
    private static final String PROTO_PRODUCT = "proto.product.PProduct";
    private static final String PROTO_SERVICE_ASSET = "message.PAssetService";
    private static final String PROTO_ALGORITHM_TRADE = "proto.quant.PAlgorithmTrade";
    private static final String PROTO_BASKET = "message.PBasketService";
    private static final String PORDER_SETTINGS = "message.PSettings";
    private static final String PORDER_PPARTIESSERVICE = "message.PPartiesService";
    private static final String PROTO_PMAINTENANCE = "message.PMainTenance";
    private static final String PROTO_PCASHSERVICE = "proto.trade.PCashService";
    private static final String PROTO_PMISCSERVICE = "proto.trade.PMiscService";
    private static final String PROTO_PWORKFLOW = "proto.workflow.PWorkflow";
    private static final String PROTO_PINSTRUCTION = "message.PInstruction";
    private static final String PROTO_PINSTRUCTION_MANAGEMENT = "proto.workflow.PInstructionManagement";
    private static final String PROTO_PEXECUTION = "proto.trade.PInstructionService";
    private static final String PROTO_RESOURCE_SERVICE = "proto.trade.PResourceService";
    private static final String PROTO_UNIFYRISK_SERVICE = "proto.unify_risk.PUnifyRiskService";
    private static final String PROTO_STRATEGY_SERVICE = "proto.strategy.PStrategy";
    private static final String PROTO_HEDGE_SERVICE = "proto.strategy.PHedge";
    private static final String PROTO_STRATEGYMONITOR = "proto.strategy.PStrategyMonitor";
    private static final String PROTO_CALC_PCALCULATOR = "proto.calc.PCalculator";
    private static final String PROTO_FOLLOW_UP_SERVICE = "proto.strategy.PFollowUp";
    private static final String PROTO_MARKET_SERVICE = "message.PMarketService";
    private static final String PROTO_PERSON_EXTACCNT = "proto.account.PPersonalAccnt";
    private static final String PROTO_PCONTRACTSERVICE = "message.PContractService";
    private static final String PROTO_ASSET_GRP = "proto.assetgroup.PAssetgroupService";
    private static final String PROTO_CCSREFDATA = "message.PCcsRefdata";
    private static final Logger logger = LogManager.getLogger(PBItem.class);
    private Map<String, Class<?>> map = new HashMap();
    private byte[] szTargetBS = new byte[4];
    @Inject
    private ExecutorService exe;

    @PostConstruct
    public void init() {
        this.exe.execute(() -> this.loadClass());
    }

    private void loadClass() {
        this.loadClass(PROTO_USER);
        this.loadClass(PROTO_USERCONTROL);
        this.loadClass(PROTO_BASE);
        this.loadClass(PROTO_MISC);
        this.loadClass(PROTO_HIERARCHY);
        this.loadClass(PROTO_EXTACCNT);
        this.loadClass(PROTO_POST);
        this.loadClass(PROTO_BROKER);
        this.loadClass("proto.hierarchy.PRbac");
        this.loadClass(PROTO_SECACCNT_SERVICE);
        this.loadClass(PROTO_EXTFUNDACCNT);
        this.loadClass(PROTO_POSITIONSERVICE);
        this.loadClass(PROTO_CCSEXTRA);
        this.loadClass(PROTO_MARKET_DATA);
        this.loadClass(PROTO_REF_DATA);
        this.loadClass(PROTO_REF_DATA_SERVICE);
        this.loadClass(PROTO_PMESSAGE);
        this.loadClass(PORDER_SERVICE);
        this.loadClass("proto.hierarchy.PRbac");
        this.loadClass(PROTO_PMARKET_DATA);
        this.loadClass(PROTO_PPORTFOLIO);
        this.loadClass(PROTO_QUOTA);
        this.loadClass(PROTO_PRODUCT);
        this.loadClass(PROTO_SERVICE_ASSET);
        this.loadClass(PROTO_ALGORITHM_TRADE);
        this.loadClass(PROTO_BASKET);
        this.loadClass(PORDER_SETTINGS);
        this.loadClass(PORDER_PPARTIESSERVICE);
        this.loadClass(PROTO_PMAINTENANCE);
        this.loadClass(PROTO_PCASHSERVICE);
        this.loadClass(PROTO_PMISCSERVICE);
        this.loadClass(PROTO_PWORKFLOW);
        this.loadClass(PROTO_PINSTRUCTION);
        this.loadClass(PROTO_PEXECUTION);
        this.loadClass(PROTO_RESOURCE_SERVICE);
        this.loadClass(PROTO_UNIFYRISK_SERVICE);
        this.loadClass(PROTO_STRATEGY_SERVICE);
        this.loadClass(PROTO_HEDGE_SERVICE);
        this.loadClass(PROTO_CALC_PCALCULATOR);
        this.loadClass(PROTO_PINSTRUCTION_MANAGEMENT);
        this.loadClass(PROTO_FOLLOW_UP_SERVICE);
        this.loadClass(PROTO_STRATEGYMONITOR);
        this.loadClass(PROTO_MARKET_SERVICE);
        this.loadClass(PROTO_PERSON_EXTACCNT);
        this.loadClass(PROTO_PCONTRACTSERVICE);
        this.loadClass(PROTO_ASSET_GRP);
        this.loadClass(PROTO_CCSREFDATA);
    }

    public void loadClass(String name) {
        try {
            Class<?>[] subs;
            Class<?> confClass = Class.forName("cms.tmx.datatype." + name);
            String pName = confClass.getPackage().getName();
            Class<?>[] classArray = subs = confClass.getClasses();
            int n = subs.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> sub = classArray[n2];
                this.map.put(String.valueOf(pName) + "." + sub.getSimpleName(), sub);
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public byte[] pack(MEvent event) throws MException {
        Object obj = event.takeObj();
        if (!(obj instanceof AbstractMessage)) {
            throw new MException(999998, "no pb object");
        }
        AbstractMessage message = (AbstractMessage)AbstractMessage.class.cast(obj);
        ByteArrayOutputStream bOutPut = new ByteArrayOutputStream();
        DataOutputStream dOutPut = new DataOutputStream(bOutPut);
        String ns = message.getClass().getPackage().getName().replace("cms.tmx.datatype.", "");
        String typeName = String.format("%s.%s\u0000", ns, message.getClass().getSimpleName());
        try {
            dOutPut.writeInt(typeName.length());
            dOutPut.write(typeName.getBytes());
            dOutPut.write(message.toByteArray());
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return bOutPut.toByteArray();
    }

    @Override
    public void parse(MEvent event, DataInputStream is) throws MException {
        try {
            int total = is.available();
            int len = is.readInt();
            if (len > 1024 || len < 0) {
                throw new MException(999997, "wrong pb class name len: " + len);
            }
            byte[] name = ByteOpUtils.createByteArray((int)len);
            byte[] content = ByteOpUtils.createByteArray((int)(total - 4 - len));
            is.read(name);
            is.read(content);
            String className = "cms.tmx.datatype." + new String(name);
            Class<?> funcClass = this.map.get(className.trim());
            if (funcClass == null) {
                throw new MException(999997, "unknown pb class: " + className);
            }
            Method method = funcClass.getMethod(PARSE_METHOD, byte[].class);
            Object obj = method.invoke(funcClass, new Object[]{content});
            event.setObj(obj);
        }
        catch (MException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("com exception: ", (Throwable)e);
            throw new MException(999996, "\u540e\u53f0\u8fd4\u56de\u6570\u636e\u4e0d\u5b8c\u6574: " + e.getMessage());
        }
    }

    @Override
    public byte getBodyType() {
        return 5;
    }

    @Override
    public byte[] getTargetBS() {
        return this.szTargetBS;
    }
}

