/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.parser;

import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.uap.parser.IParseItem;
import cms.tmx.uap.parser.JsonParseUtils;
import cms.tmx.utils.ByteOpUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MiseJsonItem
implements IParseItem {
    private static final Logger logger = LogManager.getLogger(MiseJsonItem.class);
    private byte[] szTargetBS;

    public MiseJsonItem() {
        byte[] byArray = new byte[4];
        byArray[0] = 98;
        this.szTargetBS = byArray;
    }

    @Override
    public byte[] pack(MEvent event) throws MException {
        String text = "";
        Object obj = event.takeObj();
        if (obj != null && obj instanceof String) {
            text = (String)String.class.cast(obj);
        }
        try {
            return text.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("pack failed", (Throwable)e);
            return text.getBytes(StandardCharsets.UTF_8);
        }
    }

    @Override
    public void parse(MEvent event, DataInputStream dis) throws MException {
        try {
            int len = dis.available();
            byte[] content = ByteOpUtils.createByteArray((int)len);
            dis.read(content);
            event.setObj((Object)JsonParseUtils.parseJson(new String(content, "GBK")));
        }
        catch (IOException e) {
            logger.error("JsonItem read pb failed", (Throwable)e);
            throw new MException(999996, "\u540e\u53f0\u8fd4\u56de\u6570\u636e\u4e0d\u5b8c\u6574: " + e.getMessage());
        }
    }

    @Override
    public byte getBodyType() {
        return 3;
    }

    @Override
    public byte[] getTargetBS() {
        return this.szTargetBS;
    }

    public static void main(String[] args) {
        System.out.println("b".getBytes(StandardCharsets.UTF_8));
    }
}

