/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.parser;

import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.uap.parser.IParseItem;
import cms.tmx.utils.ByteOpUtils;
import java.io.DataInputStream;
import java.io.IOException;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class JsonItem
implements IParseItem {
    private static final Logger logger = LogManager.getLogger(JsonItem.class);
    private byte[] szTargetBS = new byte[4];

    @Override
    public byte[] pack(MEvent event) throws MException {
        String text = "";
        Object obj = event.takeObj();
        if (obj != null && obj instanceof String) {
            text = (String)String.class.cast(obj);
        }
        return text.getBytes();
    }

    @Override
    public void parse(MEvent event, DataInputStream dis) throws MException {
        try {
            int len = dis.available();
            byte[] content = ByteOpUtils.createByteArray((int)len);
            dis.read(content);
            event.setObj((Object)new String(content));
        }
        catch (IOException e) {
            logger.error("JsonItem read pb failed", (Throwable)e);
            throw new MException(999996, "\u540e\u53f0\u8fd4\u56de\u6570\u636e\u4e0d\u5b8c\u6574: " + e.getMessage());
        }
    }

    @Override
    public byte getBodyType() {
        return 3;
    }

    @Override
    public byte[] getTargetBS() {
        return this.szTargetBS;
    }
}

