/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.parser;

import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.uap.parser.IParseItem;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeadItem
implements IParseItem {
    public final int HEAD_LEN = 40;
    private static final Logger logger = LogManager.getLogger(HeadItem.class);
    private byte byVersion = (byte)2;
    private int uiMsgLen = 0;
    private int uiOffset = 40;
    private int uiSourceID = 5005;
    private int uiFuncNo = 0;
    private int uiMsgID = 0;
    private int uiRetCode = 0;
    private int uiReserved = 0;
    private int uiReferMsg = 0;
    private byte[] szTargetBS = new byte[4];
    private byte byBodyType = (byte)5;
    private byte byMsgType = 1;
    private byte byFlag = (byte)-84;

    public void setFlag(byte Flag) {
        this.byFlag = Flag;
    }

    public void setVersion(byte Version) {
        this.byVersion = Version;
    }

    public void setMsgType(byte MsgType) {
        this.byMsgType = MsgType;
    }

    public void setBodyType(byte BodyType) {
        this.byBodyType = BodyType;
    }

    public void setMsgLen(int MsgLen) {
        this.uiMsgLen = MsgLen;
    }

    public void setOffset(int Offset) {
        this.uiOffset = Offset;
    }

    public void setSourceID(int SourceID) {
        this.uiSourceID = SourceID;
    }

    public void setFuncNo(int FuncNo) {
        this.uiFuncNo = FuncNo;
    }

    public void setMsgID(int MsgID) {
        this.uiMsgID = MsgID;
    }

    public void setBodyLen(int len) {
        this.uiMsgLen = len + 40;
    }

    public void setRetCode(int RetCode) {
        this.uiRetCode = RetCode;
    }

    public void setReserved(int Reserved) {
        this.uiReserved = Reserved;
    }

    public void setTargetBs(byte[] TargetBS) {
        this.szTargetBS = TargetBS;
    }

    public void setReferMsg(int ReferMsg) {
        this.uiReferMsg = ReferMsg;
    }

    public byte getFlag() {
        return this.byFlag;
    }

    public byte getVersion() {
        return this.byVersion;
    }

    public byte getMsgType() {
        return this.byMsgType;
    }

    @Override
    public byte getBodyType() {
        return this.byBodyType;
    }

    public int getMsgLen() {
        return this.uiMsgLen;
    }

    public int getOffset() {
        return this.uiOffset;
    }

    public int getSourceID() {
        return this.uiSourceID;
    }

    public int getFuncNo() {
        return this.uiFuncNo;
    }

    public int getMsgID() {
        return this.uiMsgID;
    }

    public int getRetCode() {
        return this.uiRetCode;
    }

    @Override
    public byte[] getTargetBS() {
        return this.szTargetBS;
    }

    public int getReferMsg() {
        return this.uiReferMsg;
    }

    @Override
    public byte[] pack(MEvent event) throws MException {
        ByteArrayOutputStream outputByteArray = new ByteArrayOutputStream();
        DataOutputStream doutput = new DataOutputStream(outputByteArray);
        try {
            doutput.writeByte(this.byFlag);
            doutput.writeByte(this.byVersion);
            doutput.writeByte(this.byMsgType);
            doutput.writeByte(this.byBodyType);
            doutput.writeInt(this.uiMsgLen);
            doutput.writeInt(this.uiOffset);
            doutput.writeInt(this.uiSourceID);
            doutput.writeInt(this.uiMsgID);
            doutput.writeInt(this.uiFuncNo);
            doutput.writeInt(this.uiRetCode);
            doutput.writeInt(this.uiReserved);
            doutput.write(this.szTargetBS);
            doutput.writeInt(this.uiReferMsg);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        byte[] outputBuf = outputByteArray.toByteArray();
        return outputBuf;
    }

    @Override
    public void parse(MEvent event, DataInputStream dis) throws MException {
        try {
            this.byFlag = dis.readByte();
            this.byVersion = dis.readByte();
            this.byMsgType = dis.readByte();
            this.byBodyType = dis.readByte();
            this.uiMsgLen = dis.readInt();
            this.uiOffset = dis.readInt();
            this.uiSourceID = dis.readInt();
            this.uiMsgID = dis.readInt();
            this.uiFuncNo = dis.readInt();
            this.uiRetCode = dis.readInt();
            this.uiReserved = dis.readInt();
            dis.read(this.szTargetBS);
            this.uiReferMsg = dis.readInt();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new MException(999996, e.getMessage() == null ? "\u914d\u7f6e\u6587\u4ef6\u9519\u8bef\u800c\u5f15\u8d77\u7684\u89e3\u6790IO\u5f02\u5e38" : e.getMessage());
        }
    }

    public class MessageType {
        public static final byte M_UNKOWN = 0;
        public static final byte M_REQUEST = 1;
        public static final byte M_RESPONSE = 2;
        public static final byte M_NOTIFY = 3;
        public static final byte M_ACK = 4;
        public static final byte M_INTERNAL = 5;
    }

    public class MsgBodyType {
        public static final byte UNKNOW = 0;
        public static final byte JSON = 3;
        public static final byte PROTOBUF = 5;
    }
}

