/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.internal;

import cms.tmx.uap.protocol.Pack;
import cms.tmx.uap.protocol.Rsa;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UapRsaEncoder
extends MessageToByteEncoder<Pack> {
    private static final Logger logger = LogManager.getLogger(UapRsaEncoder.class);
    private Rsa rsa;

    public UapRsaEncoder(byte[] byteKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        this.rsa = new Rsa(byteKey);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error((Object)cause);
    }

    protected void encode(ChannelHandlerContext ctx, Pack msg, ByteBuf out) throws Exception {
        ByteBuf buf = msg.encode();
        byte[] encoded = new byte[buf.capacity()];
        buf.readBytes(encoded);
        encoded = this.rsa.encrypt(encoded);
        out.writeInt(encoded.length);
        out.writeBytes(encoded);
        buf.release();
    }

    public void changeKey(byte[] key) {
        try {
            this.rsa = new Rsa(key);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

