/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.internal;

import cms.tmx.uap.api.UapUtils;
import cms.tmx.uap.internal.AesDecoder;
import cms.tmx.uap.internal.AesEncoder;
import cms.tmx.uap.internal.UapClient;
import cms.tmx.uap.internal.UapRsaEncoder;
import cms.tmx.uap.protocol.KeyVal;
import cms.tmx.uap.protocol.KeyValList;
import cms.tmx.uap.protocol.Rsa;
import cms.tmx.uap.protocol.UapCmd;
import cms.tmx.uap.protocol.UapHeader;
import cms.tmx.uap.protocol.UapPack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UapRsaDecoder
extends ByteToMessageDecoder {
    private UapClient client;
    private Rsa rsa;
    private ByteBuf bb;
    private byte[] keyAES;
    private static final String uuid = UUID.randomUUID().toString();
    private int step = 0;
    private static final Logger logger = LogManager.getLogger(UapRsaDecoder.class);

    public UapRsaDecoder(UapClient client) throws NoSuchAlgorithmException, InvalidKeySpecException {
        this.client = client;
        this.rsa = new Rsa(client.info.getRsaKey().getBytes());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        UapPack pack = UapCmd.sendAuthData(0);
        String mac = UapUtils.getMAC();
        String md5 = this.client.info.getMD5();
        KeyValList list = new KeyValList(new KeyVal("licence", md5), new KeyVal("client_uuid", mac));
        pack.getHeader().setKeyValList(list);
        ctx.writeAndFlush((Object)pack);
    }

    public void changeKey(byte[] key) {
        try {
            this.rsa = new Rsa(key);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error((Object)cause);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.capacity() == 0) {
            throw new Exception("RsaDecoder receive 0 byte, socket closed");
        }
        logger.info("uuid:" + uuid + ",step:" + ++this.step);
        byte[] decoded = new byte[in.capacity()];
        in.readBytes(decoded);
        decoded = this.rsa.decrypt(decoded);
        UapPack pack = new UapPack(decoded);
        UapHeader head = pack.getHeader();
        if (!head.isSuccess()) {
            throw new Exception(String.format("Receive cmd %d failed, RetCode = %d", head.getCMD(), head.getRetCode()));
        }
        if (head.getCMD() == 44) {
            UapPack packGet = UapCmd.get_rsa_key(0);
            logger.info("REPLY_OK, and send " + packGet.getRequestID());
            ctx.writeAndFlush((Object)packGet);
        } else if (head.getCMD() == 1) {
            KeyValList list = head.getKeyValList();
            KeyVal key = list.getKeyVal("key");
            byte[] value = key.getValList().getValBytes();
            this.bb = this.bb == null ? Unpooled.wrappedBuffer((byte[])value) : Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{this.bb, Unpooled.wrappedBuffer((byte[])value)});
            KeyVal number = list.getKeyVal("n");
            int i = number.getValList().getValInt();
            if (i == 1) {
                this.switchRSAKey(ctx, this.bb.array());
                UapPack ack = UapCmd.reply_ack(0);
                logger.info("GET_RSA_KEY,  reply ack:" + ack.getRequestID());
                ctx.writeAndFlush((Object)ack);
                UapPack packAesKey = UapCmd.sendAESKey(0);
                this.keyAES = AesEncoder.genAESKey();
                list = new KeyValList(new KeyVal("crypto_key", this.keyAES));
                packAesKey.getHeader().setKeyValList(list);
                logger.info("GET_RSA_KEY, and send aesKey :" + packAesKey.getRequestID());
                ctx.writeAndFlush((Object)packAesKey);
            }
        } else if (head.getCMD() == 2) {
            logger.info("REPLY_ACK OK switch to aes");
            this.switchToAes(ctx);
        }
    }

    private void switchRSAKey(ChannelHandlerContext ctx, byte[] rsaKey) throws Exception {
        ChannelPipeline p = ctx.pipeline();
        UapRsaEncoder encoder = (UapRsaEncoder)p.get("rsa.encoder");
        encoder.changeKey(rsaKey);
        UapRsaDecoder decoder = (UapRsaDecoder)p.get("rsa.decoder");
        decoder.changeKey(rsaKey);
    }

    private void switchToAes(ChannelHandlerContext ctx) throws Exception {
        ChannelPipeline p = ctx.pipeline();
        p.addLast("aes.encoder", (ChannelHandler)new AesEncoder(this.keyAES));
        p.addLast("aes.decoder", (ChannelHandler)new AesDecoder(this.client, this.keyAES));
        p.remove(UapRsaEncoder.class);
        p.remove((ChannelHandler)this);
        ctx.fireChannelActive();
    }
}

