/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.internal;

import cms.tmx.core.MException;
import cms.tmx.uap.api.IUapCallback;
import cms.tmx.uap.api.UapClientInfo;
import cms.tmx.uap.api.UapEvent;
import cms.tmx.uap.internal.ClientChannelInitializer;
import cms.tmx.uap.internal.NettyClient;
import cms.tmx.uap.internal.UAPSynNode;
import cms.tmx.uap.protocol.KeyVal;
import cms.tmx.uap.protocol.KeyValList;
import cms.tmx.uap.protocol.UapBody;
import cms.tmx.uap.protocol.UapCmd;
import cms.tmx.uap.protocol.UapHeader;
import cms.tmx.uap.protocol.UapPack;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ResourceLeakDetector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UapClient {
    private static final Logger logger = LogManager.getLogger(UapClient.class);
    private STATE state = STATE.STARTING;
    private ConcurrentHashMap<String, UAPSynNode> mapSynCall = new ConcurrentHashMap();
    private ExecutorService exe = Executors.newCachedThreadPool();
    private IUapCallback callBack = null;
    private NettyClient clientNetty;
    private ClientChannelInitializer initializer;
    private ChannelHandlerContext ctxt;
    private Lock lockClient = new ReentrantLock();
    private Condition condClient = this.lockClient.newCondition();
    private String message = "";
    public UapClientInfo info;
    private IUapCallback cbOnConnected;
    private boolean reconnecting = false;
    private static final int RECONNECT_INTERVAL = 5000;
    public static final int ERROR_GENERAL = 999999;
    public static final int ERROR_TIME_OUT = 999997;
    public static final int ERROR_AUTH = 999996;
    public static final int ERROR_INPUT = 999995;
    public static final int ERROR_NOT_CONNECTED = 999994;
    public static final int ERROR_UAP_DISCONNECTED = 999993;
    public static final String ERROR_DESC_TIME_OUT = "\u5e94\u7b54\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u53ca\u5237\u65b0\u4fe1\u606f";
    public static final String ERROR_DESC_SERVER = "\u540e\u53f0\u670d\u52a1\u672a\u542f\u52a8";
    public static final String ERROR_DESC_INPUT = "\u8f93\u5165\u4e3a\u7a7a";
    public static final String ERROR_DESC_SESSION_EXPIRE = "\u7edf\u4e00\u63a5\u5165\u5e73\u53f0SESSION\u5931\u6548";
    public static final String ERROR_DESC_NOT_CONNECTED = "\u672a\u8fde\u63a5\u7edf\u4e00\u63a5\u5165\u5e73\u53f0";

    public UapClient(UapClientInfo info) {
        this.info = info;
    }

    private synchronized void setState(STATE state) {
        logger.info("[UapClient] state change from " + (Object)((Object)this.state) + " to " + (Object)((Object)state));
        this.state = state;
    }

    public void init() throws MException {
        this.lockClient.lock();
        if (this.state == STATE.CONNECTED || this.state == STATE.CONNECTING) {
            this.lockClient.unlock();
            return;
        }
        try {
            this.setState(STATE.CONNECTING);
            this.exe.execute(() -> {
                try {
                    try {
                        this.lockClient.lock();
                        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.ADVANCED);
                        this.initializer = new ClientChannelInitializer(this);
                        this.clientNetty = new NettyClient(this.info.getValue("ip"), this.info.getPort(), this.initializer);
                        ChannelFuture future = this.clientNetty.start(4);
                        future.await((long)(this.info.getTimeOut() * 1000), TimeUnit.MILLISECONDS);
                        if (!future.isSuccess()) {
                            this.setState(STATE.FAILED);
                            this.message = "\u672a\u8fde\u63a5\u7edf\u4e00\u63a5\u5165\u5e73\u53f0: " + (future.cause() == null ? "" : future.cause().getMessage());
                        }
                    }
                    catch (Exception e) {
                        this.setState(STATE.FAILED);
                        this.message = "\u672a\u8fde\u63a5\u7edf\u4e00\u63a5\u5165\u5e73\u53f0: " + e;
                        logger.error("netty client start exception: " + this.message);
                        if (this.state == STATE.FAILED) {
                            this.condClient.signalAll();
                        }
                        this.lockClient.unlock();
                    }
                }
                finally {
                    if (this.state == STATE.FAILED) {
                        this.condClient.signalAll();
                    }
                    this.lockClient.unlock();
                }
            });
            try {
                this.condClient.await(this.info.getTimeOut(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.error("client init failted" + Thread.currentThread(), (Throwable)e);
            }
            if (this.state != STATE.CONNECTED) {
                if (this.state == STATE.CONNECTING) {
                    if (this.clientNetty != null) {
                        this.clientNetty.close();
                    }
                    this.initClientAgain();
                } else if (this.state == STATE.FAILED) {
                    this.initClientAgain();
                }
            }
        }
        finally {
            this.lockClient.unlock();
        }
    }

    private void initClientAgain() throws MException {
        MException mException = new MException(999999, this.message);
        mException.getEvent().put((Object)"failed_ip", (Object)this.info.getValue("ip"));
        mException.getEvent().put((Object)"failed_port", (Object)this.info.getPort());
        throw mException;
    }

    public int close() {
        this.setState(STATE.CLOSING);
        this.ctxt.close();
        this.clientNetty.close();
        this.exe.shutdownNow();
        this.mapSynCall.clear();
        return 0;
    }

    public boolean isConnected() {
        return this.state == STATE.CONNECTED;
    }

    public void OnConnected(boolean bConnected, String ip, int port) {
        logger.info(String.format("Server [%d] connection change [%b] ip [%s]", this.info.getServerType(), bConnected, ip));
        if (this.state == STATE.CLOSING) {
            return;
        }
        this.pushConnectionEvent(bConnected, ip, port);
        this.lockClient.lock();
        try {
            if (bConnected && this.state == STATE.CONNECTING) {
                this.setState(STATE.CONNECTED);
            } else if (!bConnected && this.state == STATE.CONNECTED) {
                this.setState(STATE.DISCONNECTED);
                this.exe.execute(() -> {
                    while (this.state != STATE.CONNECTED) {
                        this.reInit();
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                this.setState(STATE.DISCONNECTED);
            }
            this.condClient.signalAll();
        }
        finally {
            this.lockClient.unlock();
        }
    }

    private void reInit() {
        if (this.reconnecting) {
            return;
        }
        this.reconnecting = true;
        try {
            try {
                if (this.clientNetty != null) {
                    this.clientNetty.close();
                }
                this.init();
            }
            catch (MException e) {
                logger.error("UapClient reconnection failed: " + e.getMessage());
                this.reconnecting = false;
            }
        }
        finally {
            this.reconnecting = false;
        }
    }

    private void pushConnectionEvent(boolean bConnected, String ip, int port) {
        if (this.cbOnConnected == null) {
            return;
        }
        UapEvent e = new UapEvent();
        e.SetName(this.info.getName());
        e.setServerType(this.info.getServerType());
        e.setCode(bConnected ? 1 : 0);
        if (!ip.isEmpty()) {
            e.setIp(ip);
        }
        e.setPort(port);
        this.cbOnConnected.onResponse(e);
    }

    public void OnResponse(UapPack pack) {
        if (pack == null || pack.getHeader() == null) {
            logger.error("Received null response");
            return;
        }
        UapHeader head = pack.getHeader();
        int cmd = head.getCMD();
        String id = head.getRequestID();
        int code = head.getRetCode();
        String log = String.format("Response [%d %s][%d: %s] received [%d] bytes, code [%d], message: %s", head.getServerType(), head.getRequestNo(), cmd, id, head.getBodyLen(), code, head.getErrorMsg());
        if (head.isSuccess() && cmd != 20) {
            if (logger.isDebugEnabled()) {
                logger.debug(log);
            }
        } else if (cmd != 20) {
            logger.error(log);
        }
        switch (head.getCMD()) {
            case 12: {
                if (head.isSuccess()) {
                    this.info.setSessionID(head.getSessionId());
                    this.info.setUserID(head.getUserNo());
                }
            }
            case 11: 
            case 15: 
            case 19: {
                UAPSynNode node = this.mapSynCall.remove(pack.getRequestID());
                if (node == null) {
                    logger.error("Can't find syn node " + id);
                    return;
                }
                node.onResponse(pack);
                break;
            }
            case 20: {
                this.push(pack);
                break;
            }
            case 10: {
                if (!head.isSuccess()) break;
                head.setCMD(42);
                this.ctxt.writeAndFlush((Object)pack);
                break;
            }
            default: {
                logger.error("Received unknown response type " + head.getCMD() + " " + head.getRequestID());
            }
        }
    }

    void SetContext(ChannelHandlerContext ctxt) {
        this.ctxt = ctxt;
    }

    public UapEvent synCall(UapEvent e) {
        String strFunction;
        if (!this.isConnected()) {
            return new UapEvent(999994, ERROR_DESC_NOT_CONNECTED);
        }
        int iType = e.getServerType();
        if (iType == 0) {
            iType = this.info.getServerType();
        }
        if ((strFunction = e.getFunction()) == null || strFunction.isEmpty()) {
            strFunction = this.info.getFunction();
        }
        if (iType == 0 || strFunction == null || strFunction.isEmpty()) {
            logger.error("Server type or request number is empty");
            return new UapEvent(999995, ERROR_DESC_INPUT, null);
        }
        UapPack req = UapCmd.request(iType, strFunction, e.getStream(), e.getName());
        return this.synCall(req);
    }

    private UapEvent synCall(UapPack req) {
        UapPack res;
        if (req == null || this.ctxt == null || req.getRequestID().isEmpty()) {
            logger.error("Request is null");
            return null;
        }
        UapHeader head = req.getHeader();
        String id = head.getRequestID();
        int cmd = head.getCMD();
        if (this.info.getSessionID() != null) {
            head.setSessionId(this.info.getSessionID());
        }
        if (this.info.getUserID() != null) {
            head.setUserNo(this.info.getUserID());
        }
        UAPSynNode node = new UAPSynNode(this.ctxt, id, this.info.getTimeOut() * 1000);
        this.mapSynCall.put(id, node);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Request  [%d][%d: %s] sent", head.getServerType(), cmd, id));
        }
        if ((res = node.send(req)) == null) {
            logger.error(String.format("Request  [%d][%d: %s] timed out", head.getServerType(), cmd, id));
        }
        this.mapSynCall.remove(id);
        return this.eventAdapt(res, head.getName());
    }

    private UapEvent eventAdapt(UapPack pack, String name) {
        UapEvent event = new UapEvent();
        if (pack == null || pack.getHeader() == null) {
            event.setCode(999997);
            event.setMessage(ERROR_DESC_TIME_OUT);
        } else {
            UapHeader head = pack.getHeader();
            event.uuid = head.getRequestID();
            head.setName(name);
            this.errCodeExchange(head, event);
            UapBody body = pack.getBody();
            if (body != null) {
                event.setStream(body.getBytes());
            }
        }
        return event;
    }

    private void errCodeExchange(UapHeader head, UapEvent event) {
        int code = head.getRetCode();
        if (code == 690020014 || code == 690020015 || code == 690020016) {
            if ("default".equals(head.getName())) {
                event.setCode(999993);
                event.setMessage("\u7edf\u4e00\u63a5\u5165\u5e73\u53f0SESSION\u5931\u6548errorCode:" + code);
            } else {
                event.setCode(999994);
                event.setMessage("\u672a\u8fde\u63a5\u7edf\u4e00\u63a5\u5165\u5e73\u53f0errorCode:" + code);
            }
        } else {
            event.setCode(code);
            event.setMessage(head.getErrorMsg());
        }
    }

    public UapEvent login(UapEvent e) {
        UapPack req = UapCmd.login(e.getServerType(), e.getStream());
        req.getHeader().setRequestNo(e.getFunction());
        req.getHeader().setUserNo(e.getUserID());
        this.info.setUserID(e.getUserID());
        return this.synCall(req);
    }

    public UapEvent subscribe(UapEvent e) {
        String function = e.getFunction();
        if (function == null || function.isEmpty()) {
            return new UapEvent(null, 999995, ERROR_DESC_INPUT);
        }
        UapPack req = UapCmd.subscribe(e.getServerType(), e.getStream());
        UapHeader head = req.getHeader();
        head.setUserNo(this.info.getUserID());
        head.setRequestNo(e.getFunction());
        KeyValList kvList = new KeyValList(new KeyVal("device_id", this.info.getID()));
        head.setKeyValList(kvList);
        UapEvent eRet = this.synCall(req);
        return eRet;
    }

    public void push(UapPack pack) {
        UapHeader head = pack.getHeader();
        if (this.callBack != null) {
            this.callBack.onResponse(this.eventAdapt(pack, ""));
        } else {
            logger.error("callback is null: target " + head.getServerType() + " " + head.getRequestNo() + " uuid " + head.getRequestID());
        }
    }

    public void heartBeat() {
        UapPack req = UapCmd.heartbeat(0);
        this.ctxt.writeAndFlush((Object)req);
    }

    public UapClientInfo getInfo() {
        return this.info;
    }

    public void subOnConnected(IUapCallback cb) {
        this.cbOnConnected = cb;
    }

    public IUapCallback getCallBack() {
        return this.callBack;
    }

    public void setCallBack(IUapCallback callBack) {
        this.callBack = callBack;
    }

    private static enum STATE {
        STARTING,
        CONNECTING,
        CONNECTED,
        DISCONNECTED,
        FAILED,
        CLOSING;

    }
}

