/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.internal;

import cms.tmx.uap.protocol.UapPack;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UAPSynNode {
    private Lock lock = new ReentrantLock();
    private Condition cond = this.lock.newCondition();
    public String id;
    private long lLastTime = System.currentTimeMillis();
    private UapPack res;
    private ChannelHandlerContext ctxt;
    private int timeOut;
    private static final Logger logger = LogManager.getLogger(UAPSynNode.class);

    public UAPSynNode(ChannelHandlerContext ctxt, String id, int timeOut) {
        this.id = id;
        this.ctxt = ctxt;
        this.timeOut = timeOut;
    }

    public UapPack send(UapPack req) {
        this.lock.lock();
        this.ctxt.writeAndFlush((Object)req);
        try {
            try {
                this.cond.await(this.timeOut, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.error("UAPSynNode InterruptException " + Thread.currentThread(), (Throwable)e);
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.res;
    }

    public void onResponse(UapPack res) {
        this.lock.lock();
        try {
            this.res = res;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getLastTime() {
        return this.lLastTime;
    }
}

