/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;

public class NettyClient {
    private String host;
    private int port;
    private ChannelInitializer<SocketChannel> initializer;
    public Bootstrap bootstrap;

    public NettyClient(String host, int port, ChannelInitializer<SocketChannel> initializer) {
        this.host = host;
        this.port = port;
        this.initializer = initializer;
    }

    public ChannelFuture start(int i) throws InterruptedException {
        NioEventLoopGroup loop = new NioEventLoopGroup(i);
        this.bootstrap = new Bootstrap();
        this.bootstrap.group((EventLoopGroup)loop);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.option(ChannelOption.SO_TIMEOUT, (Object)15000);
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)15000);
        this.bootstrap.option(ChannelOption.AUTO_CLOSE, (Object)false);
        this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.bootstrap.handler(this.initializer);
        this.bootstrap.remoteAddress(this.host, this.port);
        return this.bootstrap.connect();
    }

    public void close() {
        this.bootstrap.group().shutdownGracefully();
    }
}

