/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.internal;

import cms.tmx.uap.api.UapClientInfo;
import cms.tmx.uap.internal.UapClient;
import cms.tmx.uap.internal.UapRsaDecoder;
import cms.tmx.uap.internal.UapRsaEncoder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger logger = LogManager.getLogger(ClientChannelInitializer.class);
    private UapClient client;

    public ClientChannelInitializer(UapClient client) {
        this.client = client;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("client channel init failed", cause);
        super.exceptionCaught(ctx, cause);
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        UapClientInfo info = this.client.getInfo();
        String proxyType = info.getValue("proxy_type");
        String proxyIPAddress = info.getValue("proxy_ipaddress");
        String proxyPort = info.getValue("proxy_port");
        String proxyUserName = info.getValue("proxy_username");
        String proxyPassword = info.getValue("proxy_password");
        logger.info(String.format("ProxyType=%s, ProxyIPAddress=%s, ProxyPort=%s, ProxyUserName=%s, ProxyPassword=%s", proxyType, proxyIPAddress, proxyPort, proxyUserName, proxyPassword));
        if (!proxyType.isEmpty()) {
            if (proxyType.equals("http")) {
                if (proxyUserName.isEmpty()) {
                    if (!proxyIPAddress.isEmpty() && !proxyPort.isEmpty()) {
                        ch.pipeline().addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)new InetSocketAddress(proxyIPAddress, (int)Integer.valueOf(proxyPort)))});
                    }
                } else {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)new InetSocketAddress(proxyIPAddress, (int)Integer.valueOf(proxyPort)), proxyUserName, proxyPassword)});
                }
            } else if (proxyType.equals("socket")) {
                if (proxyUserName.isEmpty()) {
                    if (!proxyIPAddress.isEmpty() && !proxyPort.isEmpty()) {
                        ch.pipeline().addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(proxyIPAddress, (int)Integer.valueOf(proxyPort)))});
                    }
                } else {
                    ch.pipeline().addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(proxyIPAddress, (int)Integer.valueOf(proxyPort)), proxyUserName, proxyPassword)});
                }
            }
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(ByteOrder.BIG_ENDIAN, 500000, 0, 4, 0, 4, true));
        ch.pipeline().addLast("rsa.encoder", (ChannelHandler)new UapRsaEncoder(this.client.info.getRsaKey().getBytes()));
        ch.pipeline().addLast("rsa.decoder", (ChannelHandler)new UapRsaDecoder(this.client));
    }
}

