/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.internal;

import cms.tmx.uap.protocol.Aes;
import cms.tmx.uap.protocol.Pack;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AesEncoder
extends MessageToByteEncoder<Pack> {
    private static final Logger logger = LogManager.getLogger(AesEncoder.class);
    private Aes aes;

    public AesEncoder(byte[] byteKey) throws Exception {
        this.aes = new Aes(byteKey);
    }

    protected void encode(ChannelHandlerContext ctx, Pack msg, ByteBuf out) throws Exception {
        ByteBuf buf = msg.encode();
        byte[] encoded = new byte[buf.capacity()];
        buf.readBytes(encoded);
        encoded = this.aes.encrypt(encoded);
        out.writeInt(encoded.length);
        out.writeBytes(encoded);
        buf.release();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error((Object)cause);
        this.logStackTrace();
    }

    public static byte[] genAESKey() throws Exception {
        KeyGenerator gen = KeyGenerator.getInstance("AES");
        gen.init(256);
        SecretKey skey = gen.generateKey();
        return skey.getEncoded();
    }

    public static void main(String[] args) throws Exception {
        byte[] encoded;
        KeyGenerator gen = KeyGenerator.getInstance("AES");
        gen.init(256);
        SecretKey skey = gen.generateKey();
        byte[] content = "888888".getBytes();
        Aes aes = new Aes(skey.getEncoded());
        byte[] byArray = encoded = aes.encrypt(content);
        int n = encoded.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            System.out.print(String.valueOf(b) + " ");
            ++n2;
        }
        System.out.println();
        byte[] decoded = aes.decrypt(encoded);
        System.out.print(new String(decoded));
    }

    private void logStackTrace() {
        StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
        if (stackElements != null) {
            int i = 0;
            while (i < stackElements.length) {
                logger.error(String.valueOf(stackElements[i].getClassName()) + "/t");
                logger.error(String.valueOf(stackElements[i].getFileName()) + "/t");
                logger.error(String.valueOf(stackElements[i].getLineNumber()) + "/t");
                logger.error(stackElements[i].getMethodName());
                logger.error("-----------------------------------");
                ++i;
            }
        }
    }
}

