/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.internal;

import cms.tmx.uap.internal.UapClient;
import cms.tmx.uap.protocol.Aes;
import cms.tmx.uap.protocol.KeyVal;
import cms.tmx.uap.protocol.KeyValList;
import cms.tmx.uap.protocol.UapCmd;
import cms.tmx.uap.protocol.UapHeader;
import cms.tmx.uap.protocol.UapPack;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AesDecoder
extends ByteToMessageDecoder {
    private static final Logger logger = LogManager.getLogger(AesDecoder.class);
    private Aes aes;
    private UapClient client;

    public AesDecoder(UapClient client, byte[] byteKey) throws Exception {
        this.client = client;
        this.aes = new Aes(byteKey);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        logger.info("aesDecoder channel active");
        UapPack pack = UapCmd.register();
        logger.info("aesDecoder channel register: requestId:" + pack.getRequestID());
        ChannelFuture f = ctx.writeAndFlush((Object)pack);
        f.sync();
        logger.info("aesDecoder channel active done");
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.error("inactive thread : ");
        this.logStackTrace();
        logger.error("channel inactive");
        if (ctx.channel() != null && ctx.channel().isActive()) {
            logger.error("channel isactive, but hit channelInActives");
        }
        this.client.OnConnected(false, "", 0);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error((Object)cause);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.capacity() == 0) {
            logger.error("AesDecoder receive 0 byte, socket closed");
            throw new Exception("AesDecoder receive 0 byte, socket closed");
        }
        byte[] decoded = new byte[in.capacity()];
        in.readBytes(decoded);
        decoded = this.aes.decrypt(decoded);
        UapPack pack = new UapPack(decoded);
        UapHeader header = pack.getHeader();
        if (header.getCMD() == 9) {
            logger.info("Received register response");
            if (!pack.getHeader().isSuccess()) {
                logger.error("AesDecoder register failed, code =" + header.getRetCode());
                throw new Exception("AesDecoder register failed, code =" + header.getRetCode());
            }
            logger.info("Received register response, OK");
            KeyValList kvList = header.getKeyValList();
            KeyVal kv = kvList.getKeyVal("cli_ip");
            String ip = "";
            if (kv != null) {
                ip = kv.getValList().getValStr();
            }
            KeyVal pv = kvList.getKeyVal("cli_port");
            int port = 0;
            if (pv != null) {
                port = pv.getValList().getValInt();
            }
            this.client.SetContext(ctx);
            logger.info("client on connected true");
            this.client.OnConnected(true, ip, port);
            return;
        }
        this.client.OnResponse(pack);
    }

    private void logStackTrace() {
        StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
        if (stackElements != null) {
            int i = 0;
            while (i < stackElements.length) {
                logger.error(String.valueOf(stackElements[i].getClassName()) + "/t");
                logger.error(String.valueOf(stackElements[i].getFileName()) + "/t");
                logger.error(String.valueOf(stackElements[i].getLineNumber()) + "/t");
                logger.error(stackElements[i].getMethodName());
                logger.error("-----------------------------------");
                ++i;
            }
        }
    }
}

