/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap.api;

import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class UapClientInfo {
    public static final String IP = "ip";
    public static final String PORT = "port";
    public static final String ID = "uuid";
    public static final String TIMEOUT = "time_out";
    public static final String CLIENT_TYPE = "client_type";
    public static final String SERVER_TYPE = "server_type";
    public static final String HEART_BEAT_INTERVAL = "hb_interval";
    public static final String SESSION_ID = "session_id";
    public static final String SESSION_CARE = "session_care";
    public static final String RSA_KEY = "rsa_key";
    public static final String MD5 = "md5";
    public static final String DEFAULT_CLIENT_TYPE = "client";
    public static final String USER_ID = "user_id";
    public static final String FUNCTION = "function";
    public static final String PROXY_TYPE = "proxy_type";
    public static final String PROXY_IP_ADDRESS = "proxy_ipaddress";
    public static final String PROXY_PORT = "proxy_port";
    public static final String PROXY_USER_NAME = "proxy_username";
    public static final String PROXY_PASSWD = "proxy_password";
    public static final String NAME = "name";
    public static final int DEFAULT_TIME_OUT = 10;
    public byte[] byteSessionID = null;
    private Map<String, String> map = new ConcurrentHashMap<String, String>();

    public UapClientInfo(String strIP, String strPort) {
        this.setValue(IP, strIP);
        this.setValue(PORT, strPort);
        this.setValue(ID, UUID.randomUUID().toString());
        this.setValue(TIMEOUT, 10);
        this.setValue(HEART_BEAT_INTERVAL, 10);
        this.setClientType(DEFAULT_CLIENT_TYPE);
        this.setValue(SESSION_CARE, 1);
    }

    public String toString() {
        return "UapClientInfo [byteSessionID=" + Arrays.toString(this.byteSessionID) + ", map=" + this.map + "]";
    }

    public void setRsaKey(String key) {
        this.setValue(RSA_KEY, key);
    }

    public String getRsaKey() {
        return this.getValue(RSA_KEY);
    }

    public void setName(String name) {
        this.setValue(NAME, name);
    }

    public String getName() {
        return this.getValue(NAME);
    }

    public void setMD5(String md5) {
        this.setValue(MD5, md5);
    }

    public String getMD5() {
        return this.getValue(MD5);
    }

    public String getIP() {
        return this.getValue(IP);
    }

    public String getID() {
        return this.getValue(ID);
    }

    public boolean getSessionCare() {
        return this.getValueInt(SESSION_CARE) == 1;
    }

    public void setSessionCare(boolean bFlag) {
        this.setValue(SESSION_CARE, bFlag ? 1 : 0);
    }

    public String getUserID() {
        return this.getValue(USER_ID);
    }

    public String getFunction() {
        return this.getValue(FUNCTION);
    }

    public void setFunction(String function) {
        this.setValue(FUNCTION, function);
    }

    public void setUserID(String id) {
        this.setValue(USER_ID, id);
    }

    public byte[] getSessionID() {
        return this.byteSessionID;
    }

    public void setSessionID(byte[] byteSessionID) {
        this.byteSessionID = byteSessionID;
    }

    public int getValueInt(String key) {
        int iRet = -1;
        String strValue = this.getValue(key);
        if (strValue != null) {
            iRet = Integer.valueOf(strValue);
        }
        return iRet;
    }

    public void setClientType(String value) {
        this.setValue(CLIENT_TYPE, value);
    }

    public void setServerType(String value) {
        this.setValue(SERVER_TYPE, value);
    }

    public int getServerType() {
        return this.getInt(SERVER_TYPE);
    }

    public int getPort() {
        return this.getInt(PORT);
    }

    public int getInt(String strKey) {
        String strValue;
        int i = 0;
        if (strKey != null && (strValue = this.getValue(strKey)) != null && !strValue.isEmpty()) {
            i = Integer.valueOf(strValue);
        }
        return i;
    }

    public int getTimeOut() {
        return this.getInt(TIMEOUT);
    }

    public void setTimeOut(int timeSec) {
        if (timeSec > 0) {
            this.setValue(TIMEOUT, timeSec);
        }
    }

    public String getValue(String strKey) {
        return this.map.get(strKey);
    }

    public void setValue(String strKey, int iValue) {
        this.setValue(strKey, String.valueOf(iValue));
    }

    public void setValue(String strKey, String strValue) {
        if (strKey != null && !strKey.isEmpty() && strValue != null) {
            this.map.put(strKey, strValue);
        }
    }

    public void setProxyData(String proxyType, String proxyIPAddress, String proxyPort, String proxyUserName, String proxyPassword) {
        this.setValue(PROXY_TYPE, proxyType);
        this.setValue(PROXY_IP_ADDRESS, proxyIPAddress);
        this.setValue(PROXY_PORT, proxyPort);
        this.setValue(PROXY_USER_NAME, proxyUserName);
        this.setValue(PROXY_PASSWD, proxyPassword);
    }
}

