/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.uap.parser.UapParser;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UapPushManager {
    private static final Logger logger = LogManager.getLogger(UapPushManager.class);
    private LinkedBlockingQueue<MEvent> queue = new LinkedBlockingQueue();
    @Inject
    private UapParser parser;
    @Inject
    private MEventService es;
    @Inject
    private ExecutorService exe;
    private Future<?> future;
    private AtomicBoolean initF = new AtomicBoolean(false);

    @PostConstruct
    public void init() {
        this.es.subscribe("stage.after.sub", event -> this.initSub(event));
        this.es.subscribe("stage.after.login", event -> this.initSub(event));
    }

    private void initSub(MEvent event) {
        if (!this.initF.get()) {
            this.initF.getAndSet(true);
            this.future = this.exe.submit(() -> this.threadPush());
        }
    }

    @PreDestroy
    private void close() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public void onPush(MEvent ePush) {
        try {
            this.queue.put(ePush);
        }
        catch (InterruptedException e) {
            logger.error("push manager enqueue failed: queue size " + this.queue.size() + Thread.currentThread(), (Throwable)e);
        }
    }

    private void threadPush() {
        while (true) {
            MEvent ePush = null;
            try {
                ePush = this.queue.take();
                try {
                    this.parser.parsePush(ePush);
                    this.es.postEvent("uap.push." + ePush.get((Object)"method_code"), ePush);
                }
                catch (MException e) {
                    logger.error("[push manager] push message failed", (Throwable)e);
                }
                continue;
            }
            catch (InterruptedException e) {
                logger.error("[push manager] dequeue failed: " + Thread.currentThread(), (Throwable)e);
                Thread.currentThread().interrupt();
                throw new RuntimeException();
            }
            catch (Exception e) {
                logger.error("single push failed: " + Thread.currentThread() + (ePush == null ? "" : ePush.get((Object)"method_code")), (Throwable)e);
                continue;
            }
            break;
        }
    }
}

