/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap;

import cms.tmx.core.MException;
import cms.tmx.uap.api.UapClientInfo;
import cms.tmx.uap.api.UapEvent;
import cms.tmx.uap.internal.UapClient;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UapConnector {
    private UapClient mainClient;

    public synchronized UapEvent login(UapClient client, UapEvent event) throws MException {
        if (event.getUserID() == null || event.getUserID().isEmpty()) {
            throw new MException(999998, "no user id");
        }
        UapEvent eRet = client.login(event);
        if (eRet.getCode() == 0) {
            this.mainClient = client;
        }
        return eRet;
    }

    public UapEvent subscribe(UapClient client, UapEvent event) {
        this.beforeCall(client);
        UapEvent eRet = client.subscribe(event);
        return eRet;
    }

    public UapEvent synRequest(UapClient client, UapEvent event) {
        this.beforeCall(client);
        UapEvent eRet = client.synCall(event);
        return eRet;
    }

    private void beforeCall(UapClient client) {
        UapClientInfo info = client.getInfo();
        if (this.mainClient != null && this.mainClient != client) {
            UapClientInfo mainInfo = this.mainClient.getInfo();
            if (info.getSessionCare()) {
                info.setSessionID(mainInfo.getSessionID());
            }
            info.setUserID(mainInfo.getUserID());
        }
    }
}

