/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap;

import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MProps;
import cms.tmx.uap.UapPushManager;
import cms.tmx.uap.api.IUapCallback;
import cms.tmx.uap.api.UapClientInfo;
import cms.tmx.uap.internal.UapClient;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UapClientManager {
    private Logger logger = LogManager.getLogger(UapClientManager.class);
    private static final String MD5 = "key.md5";
    private static final String RSA_KEY = "rsa_public_key.pem";
    private static final String DEFAULT_FUNCTION = "1001";
    private String strMD5;
    private String strKey;
    @Inject
    private MConfService cs;
    @Inject
    private UapPushManager pushManager;
    @Inject
    private MEventService es;
    @Inject
    @Named(value="conf.path")
    private String confPath;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private Map<String, UapClient> mapClient = new HashMap<String, UapClient>(10);
    private IUapCallback cbConnection = event -> {
        MEvent ePush = new MEvent();
        ePush.put((Object)"server_type", (Object)event.getName());
        int code = event.getCode();
        int serverType = event.getServerType();
        if (code == 1) {
            this.logger.info("\u516c\u7f51ip\uff1a" + event.getIp() + ":" + event.getPort());
            this.eCore.put((Object)"ip", (Object)event.getIp());
            this.eCore.put((Object)"port", (Object)event.getPort());
            this.es.postEvent("server.connected", ePush);
            this.logger.info("server connected: " + serverType);
        } else if (code == 0) {
            this.logger.error("server disconnected: " + serverType);
            this.es.postEvent("server.disconnected", ePush);
        }
    };
    private IUapCallback cbSub = event -> {
        MEvent ePush = new MEvent();
        ePush.setId(event.uuid);
        ePush.put((Object)"event_stream", (Object)event.getStream());
        this.pushManager.onPush(ePush);
    };

    @PostConstruct
    public void init() {
    }

    @PreDestroy
    public void close() {
        for (UapClient client : this.mapClient.values()) {
            client.close();
        }
    }

    public synchronized void removeClient(String type) {
        try {
            if (this.mapClient.get(type) != null) {
                this.mapClient.get(type).close();
                this.mapClient.remove(type);
            }
        }
        catch (Exception e) {
            this.logger.error("\u91cd\u65b0\u767b\u5f55\u65f6\uff0c\u5173\u95edUapClient\u5931\u8d25", (Throwable)e);
        }
    }

    public synchronized UapClient initClient(String type) throws MException {
        UapClient client = this.mapClient.get(type);
        if (client != null) {
            return client;
        }
        this.logger.info("========= type =========" + type);
        this.logger.info("========= mapClient =========" + this.mapClient);
        UapClientInfo info = this.getClientInfo(type);
        this.logger.info((Object)info);
        client = new UapClient(info);
        client.subOnConnected(this.cbConnection);
        client.setCallBack(this.cbSub);
        client.init();
        this.mapClient.put(type, client);
        return client;
    }

    private UapClientInfo getClientInfo(String type) {
        UapClientInfo info = null;
        try {
            info = this.loadClientInfo(type);
        }
        catch (MException e) {
            this.logger.error("\u8bfb\u53d6\u5ba2\u6236\u7aef\u4fe1\u606f\u5931\u8d25" + type, (Throwable)e);
        }
        return info;
    }

    private UapClientInfo loadClientInfo(String type) throws MException {
        try {
            this.loadAuthData();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new MException(999995, "\u4fe1\u606f\u52a0\u5bc6\u5931\u8d25");
        }
        MProps props = this.cs.getUserProps();
        String item = "uap.server.type." + type;
        String typeID = this.cs.getValue(item);
        item = "uap.server.function." + type;
        String function = this.cs.getValue(item, DEFAULT_FUNCTION);
        item = "uap.server.session.care." + type;
        boolean sessionCare = this.cs.getValueAsBool(item, true);
        String ip = props.getDesValue("uap.server.ip");
        String port = props.get("uap.server.port", "");
        int outTime = props.getInt("uap.server.timeout", 10);
        String proxyType = props.get("proxy.type", "");
        String proxyIPAddress = props.get("proxy.ip", "");
        String proxyPort = props.get("proxy.port", "");
        String proxyUserName = props.get("proxy.username", "");
        String proxyPassword = props.get("proxy.password", "");
        UapClientInfo info = new UapClientInfo(ip, port);
        info.setName(type);
        info.setServerType(typeID);
        info.setMD5(this.strMD5);
        info.setRsaKey(this.strKey);
        info.setTimeOut(outTime);
        info.setProxyData(proxyType, proxyIPAddress, proxyPort, proxyUserName, proxyPassword);
        info.setSessionCare(sessionCare);
        info.setFunction(function);
        return info;
    }

    private void loadAuthData() throws Exception {
        Path md5 = Paths.get(this.confPath, MD5);
        byte[] buff = Files.readAllBytes(md5);
        this.strMD5 = new String(buff);
        Path key = Paths.get(this.confPath, RSA_KEY);
        buff = Files.readAllBytes(key);
        this.strKey = new String(buff);
    }
}

