/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.uap;

import cms.tmx.core.MAddon;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.uap.UapClientManager;
import cms.tmx.uap.UapConnector;
import cms.tmx.uap.api.UapEvent;
import cms.tmx.uap.internal.UapClient;
import cms.tmx.uap.parser.UapParser;
import cms.tmx.utils.StringUtils;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UapAddon
extends MAddon {
    private static final Logger logger = LogManager.getLogger(UapAddon.class);
    private static final String DEFAULT_SERVER_TYPE = "default";
    @Inject
    private UapParser parser;
    @Inject
    private MEventService es;
    @Inject
    private MConfService cs;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private UapClientManager manager;
    @Inject
    private UapConnector conn;
    private static int count = 0;

    @PostConstruct
    public void init() {
        this.es.subscribe("uap.call", event -> this.handleRequest(event, 1));
        this.es.subscribe("uap.sub", event -> this.handleRequest(event, 3));
        this.es.subscribe("uap.login", event -> this.handleRequest(event, 2));
        super.loadDone();
    }

    private void handleRequest(MEvent event, int reqType) {
        block2: {
            try {
                this.pack(event);
                this.request(event, reqType);
                this.parse(event);
                event.setOK();
            }
            catch (MException e) {
                event.setRes(e.getCode(), e.getMessage());
                event.put((Object)"failed_ip", e.getEvent().get((Object)"failed_ip"));
                event.put((Object)"failed_port", e.getEvent().get((Object)"failed_port"));
                logger.error(String.format("UapAddon: handle event failed: %d, %s", e.getCode(), e.getMessage()));
                if (e.getCode() != 999993) break block2;
                this.es.sendEvent("auto_relogin", event);
            }
        }
    }

    private void pack(MEvent event) throws MException {
        this.parser.pack(event);
    }

    private void parse(MEvent event) throws MException {
        this.parser.parse(event);
    }

    private void request(MEvent event, int reqType) throws MException {
        String type = event.getStr("server_type");
        if (type.isEmpty()) {
            type = DEFAULT_SERVER_TYPE;
        }
        if (reqType == 2) {
            this.manager.removeClient(type);
        }
        UapClient client = this.manager.initClient(DEFAULT_SERVER_TYPE);
        byte[] stream = event.getBytes("event_stream");
        event.remove((Object)"event_stream");
        String item = "uap.server.type." + type;
        int iType = this.cs.getValueAsInt(item, 0);
        String function = this.cs.getValue("uap.server.function." + type);
        if (iType == 0 || StringUtils.isEmpty((String)function)) {
            throw new MException(1, "\u8bf7\u6c42\u9519\u8bef\uff1aiType=" + iType + ",function=" + function);
        }
        UapEvent eCall = new UapEvent(iType, function, type, stream);
        UapEvent eRet = null;
        switch (reqType) {
            case 2: {
                String user = event.getStr("user_id");
                if (user.isEmpty()) {
                    throw new MException(999995, "no user id");
                }
                eCall.setUserID(String.valueOf(user) + "|" + this.eCore.getStr("uuid"));
                eRet = this.conn.login(client, eCall);
                if (eRet.getCode() != 0) break;
                byte[] sessionID = client.getInfo().getSessionID();
                this.eCore.put((Object)"SESSION_ID", (Object)sessionID);
                break;
            }
            case 3: {
                long b = System.currentTimeMillis();
                eRet = this.conn.subscribe(client, eCall);
                logger.info("sub=== takes:" + (System.currentTimeMillis() - b) + "  " + (event.get((Object)"saved_object") == null ? "" : "" + event.get((Object)"saved_object").getClass()));
                break;
            }
            default: {
                long b2 = System.currentTimeMillis();
                eRet = this.conn.synRequest(client, eCall);
                logger.info("req=== takes:" + (System.currentTimeMillis() - b2) + "  " + (event.get((Object)"saved_object") == null ? "" : "" + event.get((Object)"saved_object").getClass()));
            }
        }
        event.setRes(eRet.getCode(), eRet.getMessage());
        if (eRet.getCode() != 0) {
            throw new MException(event);
        }
        event.put((Object)"event_stream", (Object)eRet.getStream());
    }

    public class RequestType {
        public static final int REQUEST = 1;
        public static final int LOGIN = 2;
        public static final int SUBSCRIBE = 3;
    }
}

