/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.block.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.entity.trade.CcsAccountDistribution;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BlockSecSetDialog
extends DialogObj {
    @FXML
    private TableView<CcsAccountDistribution> tableSec;
    @FXML
    private TableColumn<CcsAccountDistribution, Boolean> colSelected;
    @FXML
    private TableColumn<CcsAccountDistribution, String> colInvestorSecId;
    private ObservableList<CcsAccountDistribution> secDisList;
    private Map<String, CcsAccountDistribution> selectedMap = new HashMap<String, CcsAccountDistribution>();

    @FXML
    private void initialize() {
        this.createTable();
        this.reSelectSec();
    }

    private void reSelectSec() {
        if (this.selectedMap.isEmpty()) {
            boolean xshg = false;
            boolean xshe = false;
            for (CcsAccountDistribution dist : this.secDisList) {
                if ("XSHG".equals(dist.getSecAcc().getExchange().getRaw()) && !xshg) {
                    xshg = true;
                    dist.setSelected(true);
                }
                if (!"XSHE".equals(dist.getSecAcc().getExchange().getRaw()) || xshe) continue;
                xshe = true;
                dist.setSelected(true);
            }
        } else {
            for (CcsAccountDistribution dist : this.secDisList) {
                if (!this.selectedMap.values().contains(dist)) continue;
                dist.setSelected(true);
            }
        }
    }

    private void createTable() {
        this.colSelected.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue()).selectedProperty());
        this.colSelected.setCellFactory(data -> new BlockCheckBoxTableCell());
        this.colSelected.setSortable(false);
        this.colSelected.getTableView().setEditable(true);
        this.colInvestorSecId.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue()).getSecAcc().inverstorSecIdProperty());
        this.tableSec.setItems(this.secDisList);
    }

    public void clearSelected() {
        this.selectedMap.clear();
    }

    protected boolean isOK(ButtonType bt) {
        List selectedList = this.secDisList.stream().filter(item -> item.isSelected()).collect(Collectors.toList());
        for (CcsAccountDistribution ccsAccountDistribution : selectedList) {
            this.selectedMap.put(ccsAccountDistribution.getSecAcc().getExchange().getRaw(), ccsAccountDistribution);
        }
        return true;
    }

    public ObservableList<CcsAccountDistribution> getSecDisList() {
        return this.secDisList;
    }

    public void setSecDisList(ObservableList<CcsAccountDistribution> secDisList) {
        this.secDisList = secDisList;
    }

    public Map<String, CcsAccountDistribution> getSelectedMap() {
        return this.selectedMap;
    }

    public void setSelectedMap(Map<String, CcsAccountDistribution> selectedMap) {
        this.selectedMap.clear();
        this.selectedMap.putAll(selectedMap);
    }

    public class BlockCheckBoxTableCell
    extends CheckBoxTableCell<CcsAccountDistribution, Boolean> {
        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                CcsAccountDistribution dist = (CcsAccountDistribution)CcsAccountDistribution.class.cast(this.getTableRow().getItem());
                this.disableProperty().bind((ObservableValue)dist.selectedProperty());
                try {
                    CheckBox checkbox = new CheckBox();
                    checkbox.selectedProperty().bindBidirectional((Property)dist.selectedProperty());
                    checkbox.selectedProperty().addListener((ob, old, now) -> {
                        if (now.booleanValue()) {
                            for (CcsAccountDistribution ccsDist : this.getTableView().getItems()) {
                                if (dist.getSecAcc().getExtSecAccntId().equals(ccsDist.getSecAcc().getExtSecAccntId()) || !dist.getSecAcc().getExchange().getRaw().equals(ccsDist.getSecAcc().getExchange().getRaw())) continue;
                                ccsDist.setSelected(false);
                            }
                        }
                    });
                    this.setGraphic((Node)checkbox);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

