/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.block.models;

import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IBlockTradeApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.message.PPostTrade;
import cms.tmx.define.MxDict;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.BlockTradeParam;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.entity.trade.instruction.TradeCaptureReportAdvice;
import cms.tmx.manage.IAccountService;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.InstructionModel;
import cmx.tmx.data.IMarketDataMng;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BlockTradeModel {
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private IBlockTradeApi blockApi;
    protected MarketItem mktItem;
    @Inject
    protected CcsPositionModel posModel;
    @Inject
    private InstructionModel instructionModel;
    @Inject
    protected InstructionAccountModel instrAccModel;
    @Inject
    protected IAccountService accountService;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private IInstructionApi<?> insApi;
    private String postil = "";
    private static int PAR_VALUE = 100;

    @PostConstruct
    private void init() {
        this.mktItem = this.mktMng.createItem(10);
        this.posModel.initQuery();
    }

    public void submit(BlockTradeParam param) throws MException {
        PPostTrade.TradeCaptureReport.Builder reqBuilder = param.getTradeCaptureReportBuilder();
        reqBuilder.setOpUser(this.baseApi.getOpUser());
        this.blockApi.submitOrder(reqBuilder.build());
    }

    public void submitAdvice(BlockTradeParam param) throws MException {
        List stepList = this.instrAccModel.getWorkflow(param.getFundAccount().getParentId()).getSteps();
        if (stepList != null && !stepList.isEmpty()) {
            for (AccntStepAttribute step : stepList) {
                if (1 != step.getStepId()) continue;
                param.setFlowAttriId(step.getFlowAttriId());
                param.setStepAttrId(step.getStepAttriId());
                break;
            }
        }
        TradeCaptureReportAdvice advice = param.getAdvice();
        advice.setProductId(this.accountService.getAccountFromCache(param.getFundAccount().getParentId()).getProductId());
        advice.setAmount(this.getMoney(advice));
        InstructionSubmitResult result = new InstructionSubmitResult();
        PInstruction.Instruction.Builder insb = advice.getInstBuilder();
        insb.setEstimatedOrderAmount(advice.getAmount());
        String instructionId = this.insApi.newInstruction(insb.build(), param.getActionId());
        String reason = this.insApi.submitInstruction(instructionId, this.getPostil());
        result.setInstructionId(instructionId);
        result.setReason(reason);
    }

    private int getParValue(TradeCaptureReportAdvice item) {
        return item.getMarket().equals("XSHG") ? 10 * PAR_VALUE : PAR_VALUE;
    }

    private double getMoney(TradeCaptureReportAdvice item) {
        switch (item.getSide()) {
            case 70: 
            case 71: {
                return item.getOrderQty() * (long)this.getParValue(item);
            }
        }
        if ("XSHG".equals(item.getMarket()) && "BOND".equals(item.getSecType())) {
            return (double)item.getOrderQty() * item.getPrice() * 10.0;
        }
        return (double)item.getOrderQty() * item.getPrice();
    }

    public Set<CcsFundAccount> getActiveAccMap(String instructionPanelType) {
        if (this.instrAccModel.getActiveAccMap(instructionPanelType) != null) {
            return this.instrAccModel.getActiveAccMap(instructionPanelType).keySet();
        }
        return new HashSet<CcsFundAccount>();
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item == null || item.getType().isEmpty()) {
            return null;
        }
        return item;
    }

    public long getCanSell(SecAccount account) {
        long canSell = new Double(this.posModel.getCanSell(account, this.mktItem.getRefItem().getCode())).longValue();
        return canSell;
    }

    public long getReduceQty(SecAccount account) {
        CcsPosition position = this.posModel.getPosition(account, this.mktItem.getRefItem().getCode());
        if (position == null) {
            return 0L;
        }
        return new Double(position.getReduceQty()).longValue();
    }

    public long getLimitedReduceQty(SecAccount account) {
        CcsPosition position = this.posModel.getPosition(account, this.mktItem.getRefItem().getCode());
        if (position == null) {
            return 0L;
        }
        return new Double(position.getLimitedReduceQty()).longValue();
    }

    public void doChange() {
        this.mktMng.dye(this.mktItem);
    }

    public MarketItem getMktItem() {
        return this.mktItem;
    }

    public void approve(Instruction instruction) throws MException {
        this.instructionModel.approve(instruction, MxDict.WORKFLOW_APPROVE, instruction.getPostil());
    }

    public void execute(Instruction instruction) throws MException {
        this.instructionModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, instruction.getPostil());
    }

    public void refreshResource(Instruction instruction) throws MException {
        this.instructionModel.refreshResource(instruction);
    }

    public String getPostil() {
        return this.postil;
    }

    public void setPostil(String postil) {
        this.postil = postil;
    }
}

