/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.block.fixed.views;

import cms.tmx.block.fixed.views.FixedTradeBasePart;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.BlockTradeParam;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.utils.StringUtils;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FixedTradeExecutePart
extends FixedTradeBasePart {
    private static final Logger logger = LogManager.getLogger(FixedTradeExecutePart.class);
    protected MEvent instructEvent = new MEvent();
    protected boolean initFinished = false;
    protected MEventHandler hSetCodeExe = event -> {
        this.instructEvent = event;
        if (this.instructEvent.get((Object)"instruction") == null || !(this.instructEvent.get((Object)"instruction") instanceof Instruction)) {
            return;
        }
        Instruction ins = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        if (!this.validOrderFill(ins)) {
            return;
        }
        this.instruction = ins;
        this.doFill();
    };

    @Inject
    public FixedTradeExecutePart() {
    }

    @PostConstruct
    public void init() {
        super.init();
        this.instruction = null;
        this.es.subscribe("instruction.set.on.panel", this.hSetCodeExe);
    }

    @Override
    @FXML
    public void initialize() {
        this.setBuySymbol("\u4e70\u5165");
        this.setSellSymbol("\u5356\u51fa");
        this.setConfirmSymbol("");
        this.setInstructionPanelType("4");
        this.componentDisabled();
        super.initialize();
        this.initFinished = true;
        this.doFill();
    }

    @Override
    protected void doAction(BlockTradeParam param) throws MException {
        this.model.execute(this.instruction);
        super.doAction(param);
        this.updateInstruction();
    }

    @PreDestroy
    private void dispose() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCodeExe);
    }

    private void doFill() {
        Platform.runLater(() -> {
            if (!this.initFinished || this.instruction == null) {
                return;
            }
            if (StringUtils.belongto((String)this.instruction.getType().getRaw(), (String[])new String[]{"34"})) {
                try {
                    this.fillInstruction(false);
                }
                catch (MException | Exception e) {
                    this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u56de\u586b\u51fa\u9519" + e.getMessage());
                    logger.error("\u6307\u4ee4\u6267\u884c\u56de\u586b\u51fa\u9519:" + this.instruction.getId(), e);
                }
            }
        });
    }

    @Override
    protected void showPart() {
    }

    private boolean validOrderFill(Instruction ins) {
        return StringUtils.belongto((String)ins.getType().getRaw(), (String[])new String[]{"34"}) && ins.getIsOrderStep();
    }
}

