/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view.distribution.business;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.IssueInfoItem;
import cms.tmx.entity.trade.NewCcsSingleEntrust;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.neeq.factory.NeeqSingleEntrustFactory;
import cms.tmx.neeq.model.NeeqAccntAggreementQueryModel;
import cms.tmx.query.current.models.CcsAccountMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NeeqOneKeyDialog
extends DialogObj {
    @FXML
    private TableView<IssueInfoItem> tableItems;
    @FXML
    private TableColumn<IssueInfoItem, Boolean> select;
    @FXML
    private TableColumn<IssueInfoItem, String> issueId;
    @FXML
    private TableColumn<IssueInfoItem, String> securityId;
    @FXML
    private TableColumn<IssueInfoItem, String> securityName;
    @FXML
    private TableColumn<IssueInfoItem, String> effectivePrice;
    @FXML
    private TableColumn<IssueInfoItem, String> qtyRange;
    @FXML
    private TableColumn<IssueInfoItem, String> startDate;
    @FXML
    private TableColumn<IssueInfoItem, String> tradeStatus;
    @FXML
    private TableColumn<IssueInfoItem, String> inquireStatus;
    @FXML
    private TableColumn<IssueInfoItem, Number> price;
    @FXML
    private TableColumn<IssueInfoItem, Number> qty;
    @FXML
    private TableColumn<IssueInfoItem, Number> outstandingShare;
    @FXML
    private TableColumn<IssueInfoItem, ComboBox<FundAccount>> accnt;
    @FXML
    private TableColumn<IssueInfoItem, ComboBox<String>> secAccnt;
    @Inject
    protected IFundAccountService fundApi;
    @Inject
    protected CcsAccountMap accMng;
    @Inject
    protected NeeqAccntAggreementQueryModel agreementModel;
    @Inject
    protected NeeqSingleEntrustFactory ef;
    private static final Logger logger = LogManager.getLogger(NeeqOneKeyDialog.class);
    private ObservableList<IssueInfoItem> list = FxUtils.newList();
    private Map<CcsFundAccount, List<SecAccount>> neeqOriginAccountMap = new HashMap<CcsFundAccount, List<SecAccount>>();
    private Map<String, List<SecAccount>> map = new HashMap<String, List<SecAccount>>();
    private Map<String, ComboBox<String>> box = new HashMap<String, ComboBox<String>>();
    private Result result = new Result();

    @FXML
    public void initialize() {
        try {
            this.initMap();
            this.createTable();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    protected boolean isOK(ButtonType bt) {
        List list = this.tableItems.getItems().stream().filter(item -> item.isSelected()).collect(Collectors.toList());
        for (IssueInfoItem issueInfoItem : list) {
            try {
                NewCcsSingleEntrust en = this.createEntrust(issueInfoItem.getAccnt().getNewCashAccntId(), this.accMng.getSecAcc(issueInfoItem.getInvestorsecId(), "NEEQ").getExtSecAccntId());
                en.setFundAccount(issueInfoItem.getAccnt());
                en.setSecAccount(this.accMng.getSecAcc(issueInfoItem.getInvestorsecId(), "NEEQ"));
                en.setInvestorId(issueInfoItem.getAccnt().getInvestId());
                en.setInvestorSecId(issueInfoItem.getInvestorsecId());
                en.setSide("201");
                en.setQuantity(new Double(issueInfoItem.getQty()).longValue());
                en.setMarket("NEEQ");
                en.setSecType(issueInfoItem.getSecurityType());
                en.setLevelInfo("\u7cbe\u9009\u5c42");
                en.setPrice(issueInfoItem.getPrice());
                en.setMarketIndicate("COMMON_ISSUE");
                en.setApplId("800");
                en.setMarketGroup("CCS");
                en.setOrderType(50);
                en.setSecInstrument(issueInfoItem.getIssueId());
                en.setSec(issueInfoItem.getSecurityId());
                en.setSecName(issueInfoItem.getSecurityName());
                en.newApplyForThePurchase();
                this.result.operate(true);
            }
            catch (MException | Exception e) {
                logger.error((Object)e, e);
                this.result.operate(false);
            }
        }
        return true;
    }

    private void initMap() throws MException {
        this.neeqOriginAccountMap = this.accMng.getAccountMap().entrySet().stream().filter(map -> ((CcsFundAccount)map.getKey()).isNeeqEnable()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<CcsFundAccount, List<SecAccount>> item : this.neeqOriginAccountMap.entrySet()) {
            this.map.put(item.getKey().getInvestId(), item.getValue());
        }
    }

    protected void createTable() {
        TableUtils.isCheckBox(this.select);
        this.issueId.setCellValueFactory(m -> ((IssueInfoItem)m.getValue()).issueIdProperty());
        this.securityId.setCellValueFactory(m -> ((IssueInfoItem)m.getValue()).securityIdProperty());
        this.securityName.setCellValueFactory(m -> ((IssueInfoItem)m.getValue()).securityNameProperty());
        this.startDate.setCellValueFactory(m -> ((IssueInfoItem)m.getValue()).startDateProperty());
        this.effectivePrice.setCellValueFactory(m -> ((IssueInfoItem)m.getValue()).effectivePriceProperty());
        this.qtyRange.setCellValueFactory(m -> ((IssueInfoItem)m.getValue()).qtyRangeProperty());
        this.price.setCellValueFactory(m -> ((IssueInfoItem)m.getValue()).priceProperty());
        this.qty.setCellValueFactory(m -> ((IssueInfoItem)m.getValue()).qtyProperty());
        this.outstandingShare.setCellValueFactory(m -> ((IssueInfoItem)m.getValue()).outstandingShareProperty());
        this.tradeStatus.setCellValueFactory(m -> ((IssueInfoItem)m.getValue()).tradeStatusProperty());
        this.inquireStatus.setCellValueFactory(m -> ((IssueInfoItem)m.getValue()).iqueryStatusProperty());
        this.select.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        this.accnt.setCellValueFactory(data -> this.setCombobox((TableColumn.CellDataFeatures<IssueInfoItem, ComboBox<FundAccount>>)data));
        this.secAccnt.setCellValueFactory(data -> this.setSecAccntCombobox((TableColumn.CellDataFeatures<IssueInfoItem, ComboBox<String>>)data));
        this.price.setCellFactory(data -> new EditTableCell(2));
        this.qty.setCellFactory(data -> new EditTableCell(1));
        this.outstandingShare.setCellFactory(data -> new DoubleTableCell(2));
        this.tableItems.setItems(this.list);
        this.tableItems.setEditable(true);
        this.tableItems.setPlaceholder((Node)new Label());
    }

    private ReadOnlyObjectWrapper<ComboBox<FundAccount>> setCombobox(TableColumn.CellDataFeatures<IssueInfoItem, ComboBox<FundAccount>> data) {
        ComboBox cmbAccnt = new ComboBox();
        IssueInfoItem item = (IssueInfoItem)data.getValue();
        List fundAccountList = this.fundApi.getNeeqFundAccountList();
        for (FundAccount fundAccount : fundAccountList) {
            if (!fundAccount.getInvestId().equals(item.getInvestorId())) continue;
            item.setAccnt(fundAccount);
            break;
        }
        LinkedList<FundAccount> datas = new LinkedList<FundAccount>();
        block1: for (FundAccount fundAccount : fundAccountList) {
            List<SecAccount> datasSec = this.neeqOriginAccountMap.get(fundAccount);
            if (datasSec == null) continue;
            for (SecAccount secAccount : datasSec) {
                if (!"NEEQ".equals(secAccount.getExchange().getRaw()) || !this.checkAuth(fundAccount, secAccount)) continue;
                datas.add(fundAccount);
                continue block1;
            }
        }
        cmbAccnt.setItems(FXCollections.observableList(datas));
        cmbAccnt.valueProperty().bindBidirectional((Property)item.accntProperty());
        if (!item.isAccntUpdate()) {
            cmbAccnt.setDisable(true);
        } else {
            cmbAccnt.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
                if (MouseButton.SECONDARY.equals((Object)e.getButton())) {
                    cmbAccnt.hide();
                }
            });
            cmbAccnt.getSelectionModel().selectedItemProperty().addListener((change, old, now) -> {
                List<SecAccount> items = this.map.get(now.getInvestId());
                if (items != null) {
                    item.getListSecAccnt().clear();
                    for (SecAccount secAccount : items) {
                        if (!"NEEQ".equals(secAccount.getExchange().getRaw()) || item.getListSecAccnt().contains((Object)secAccount.getInverstorSecId()) || item.getAccnt() == null || !this.checkAuth(item.getAccnt(), secAccount)) continue;
                        item.getListSecAccnt().add((Object)secAccount.getInverstorSecId());
                    }
                    if (this.box.get(item.getIssueId()).getItems().size() > 0) {
                        this.box.get(item.getIssueId()).getSelectionModel().select(0);
                    }
                }
            });
        }
        return new ReadOnlyObjectWrapper((Object)cmbAccnt);
    }

    private boolean checkAuth(FundAccount fundAccount, SecAccount secAccount) {
        List<Integer> authList = Arrays.asList(1, 4, 5);
        return this.agreementModel.checkAuth(fundAccount, secAccount, authList);
    }

    private ReadOnlyObjectWrapper<ComboBox<String>> setSecAccntCombobox(TableColumn.CellDataFeatures<IssueInfoItem, ComboBox<String>> data) {
        ComboBox ccmSecAccnt = new ComboBox();
        IssueInfoItem item = (IssueInfoItem)data.getValue();
        if (!item.isAccntUpdate()) {
            ccmSecAccnt.setDisable(true);
            ObservableList list = FxUtils.newList();
            list.add((Object)item.getInvestorsecId());
            ccmSecAccnt.setItems(list);
            ccmSecAccnt.valueProperty().bindBidirectional((Property)item.investorsecIdProperty());
        } else {
            this.box.put(item.getIssueId(), (ComboBox<String>)ccmSecAccnt);
            List<SecAccount> list = this.map.get(item.getInvestorId());
            for (SecAccount secAccount : list) {
                if (!"NEEQ".equals(secAccount.getExchange().getRaw()) || item.getListSecAccnt().contains((Object)secAccount.getInverstorSecId()) || item.getAccnt() == null || !this.checkAuth(item.getAccnt(), secAccount)) continue;
                item.getListSecAccnt().add((Object)secAccount.getInverstorSecId());
            }
            ccmSecAccnt.setItems(item.getListSecAccnt());
            ccmSecAccnt.valueProperty().bindBidirectional((Property)item.investorsecIdProperty());
            ccmSecAccnt.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
                if (MouseButton.SECONDARY.equals((Object)e.getButton())) {
                    ccmSecAccnt.hide();
                }
            });
        }
        return new ReadOnlyObjectWrapper((Object)ccmSecAccnt);
    }

    public ObservableList<IssueInfoItem> getList() {
        return this.list;
    }

    public void setList(ObservableList<IssueInfoItem> list) {
        this.list = list;
    }

    public NewCcsSingleEntrust createEntrust(String acc, String secAcc) {
        return this.ef.createNewCcsSingle(acc, secAcc);
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }
}

