/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view.distribution.business;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleNoZeroSpinnerCtrl;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.NumberTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.IUIService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.IssueConverter;
import cms.tmx.data.utils.IssueSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.NewCcsSingleEntrust;
import cms.tmx.http.data.IssueInfo;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.neeq.model.distribution.business.NeeqInquiryPurchaseTradeBaseModel;
import cms.tmx.neeq.view.LoadPartModel;
import cms.tmx.neeq.view.NeeqEntrustInquiryConfirmDialog;
import cms.tmx.trade.utils.TradeAcctCountFilter;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IIssueMng;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

public class NeeqInquiryPurchaseBasePart
extends MxPart {
    protected AtomicBoolean initFinished = new AtomicBoolean(false);
    @FXML
    protected TextField txtCode;
    @FXML
    protected TextField txtCodeInstrument;
    @FXML
    protected GridPane gridPanel;
    @FXML
    private Label lbQty;
    @FXML
    private Label lbStartEndDate;
    @FXML
    private Label lbPriceRange;
    @FXML
    protected Spinner<Double> priceSpn;
    @FXML
    protected Spinner<Integer> quantitySpn;
    @FXML
    private Label lbQtyRange;
    @FXML
    protected ComboBox<MxNode> cmbDist;
    @FXML
    protected TreeTableView<CcsAccountDistribution> acctTreeTable;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, SecAccount> secAcctCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> availableCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> assetCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> weightCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> amountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canBuyCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, String> productCol;
    @FXML
    protected Button btnOrder;
    @FXML
    private ComboBox<MxNode> cmbAccFilter;
    @FXML
    private HBox hBoxPartlyAccCount;
    @FXML
    private Label lbSecAccCount;
    @FXML
    private TextField textAccCount;
    @FXML
    private TextField txtSearch;
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    protected IIssueMng issueMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected NeeqInquiryPurchaseTradeBaseModel neeqModel;
    @Inject
    protected DialogFactory df;
    @Inject
    protected UserPreOrderTips setTips;
    @Inject
    protected IUIService uiService;
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    protected AutoCompletion<IssueInfo> autoCompletionNormal;
    protected IssueInfo issueInfo;
    private IssueConverter secCvt;
    private String confirmSymbol = "";
    protected boolean priceSettle = false;
    protected String partType = "";
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 2);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected DoubleNoZeroSpinnerCtrl ctrlProctedPrice = new DoubleNoZeroSpinnerCtrl(true, 6, 2);
    protected IssueSuggest spCode = new IssueSuggest();
    private InvalidationListener listener = ob -> {
        Collection<IssueInfo> list = this.getRefItems();
        this.spCode.setAllSuggestions(list);
    };
    private MEventHandler hSetPst = event -> {
        if (this.autoCompletionNormal == null) {
            return;
        }
        String code = event.getStr("issue_code");
        this.txtCodeInstrument.setText(code);
        IssueInfo info = null;
        for (IssueInfo item : this.getRefItems()) {
            if (!code.equals(item.getSecurity().getInstrument().getSecurityId())) continue;
            info = item;
            break;
        }
        this.txtCodeInstrument.setUserData(info);
        if (code.equals(this.autoCompletionNormal.changedProperty().get())) {
            this.onSecurityChange(this.txtCodeInstrument, code);
        } else {
            this.autoCompletionNormal.setChange(code);
        }
    };
    private ListChangeListener<TreeItem<CcsAccountDistribution>> lst = ob -> {
        if (ob.getList().size() != 0) {
            this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)((TreeItem)ob.getList().get(0)));
        }
    };
    private Callback<TreeTableColumn<CcsAccountDistribution, Boolean>, TreeTableCell<CcsAccountDistribution, Boolean>> checkBoxFactory = p -> new TreeTableCell<CcsAccountDistribution, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    treeItem.getChildren().addListener(NeeqInquiryPurchaseBasePart.this.lst);
                    if (treeItem.isLeaf()) {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((CcsAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV != false && treeItem.getParent().isExpanded());
                            } else {
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
                            }
                        });
                        checkBox.setOnMouseClicked(event -> NeeqInquiryPurchaseBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem));
                        NeeqInquiryPurchaseBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem);
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    } else {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                            if (newV.booleanValue()) {
                                NeeqInquiryPurchaseBasePart.this.acctTreeTable.refresh();
                            }
                        });
                        treeItem.expandedProperty().addListener((ob, old, newV) -> NeeqInquiryPurchaseBasePart.this.acctTreeTable.refresh());
                        checkBox.setOnMouseClicked(event -> treeItem.getChildren().forEach(each -> ((CcsAccountDistribution)each.getValue()).setSelected(((CcsAccountDistribution)treeItem.getValue()).isSelected())));
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected());
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                }
            }
        }
    };
    @Inject
    protected LoadPartModel load;

    @Inject
    public NeeqInquiryPurchaseBasePart() {
    }

    public void onShowEvent(MEvent event) {
    }

    @PreDestroy
    private void close() {
        this.issueMng.changedProperty().removeListener(this.listener);
        this.es.unSubscribe("trade.panel.set.code", this.hSetPst);
    }

    @FXML
    public void initialize() {
        this.neeqModel.create("4");
        this.issueMng.changedProperty().addListener(this.listener);
        this.initControls();
        this.createMarketTable();
        this.createAcctTree();
        this.es.subscribe("neeq.inquiry.order", this.hSetPst);
    }

    protected Collection<IssueInfo> getRefItems() {
        Collection<Object> items = this.issueMng.getIssues("NEEQ");
        items = items != null ? (Collection)items.stream().filter(item -> item.getParams() != null && "I".equals(item.getParams().getUnderlying().getSecuritySubType())).collect(Collectors.toList()) : new LinkedList<IssueInfo>();
        return items;
    }

    protected void initControls() {
        this.secCvt = (IssueConverter)this.of.create(IssueConverter.class);
        this.spCode.clearSuggestions();
        this.spCode.addPossibleSuggestions(this.getRefItems());
        this.autoCompletionNormal = Search.bindAutoCompletion((TextField)this.txtCodeInstrument, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormal.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            this.onSecurityChange(this.txtCodeInstrument, (String)newV);
            this.acctTreeTable.refresh();
            this.layout();
        }));
        this.txtCodeInstrument.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCodeInstrument.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeInstrumentKeyPress((KeyEvent)event));
        this.txtCodeInstrument.textProperty().bindBidirectional((Property)this.neeqModel.insrumentIdProperty());
        this.txtCodeInstrument.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.setDisable(true);
        this.txtCode.textProperty().bindBidirectional((Property)this.neeqModel.underlyingIdProperty());
        this.ctrlPrice.ctrl(this.priceSpn);
        this.ctrlPrice.setUnit(0.01);
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.neeqModel.priceProperty());
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.focusedProperty().addListener((ob, old, val) -> this.priceLoseFocus((Boolean)val));
        this.priceSpn.getEditor().setText("");
        this.priceDisableBind();
        this.priceVisibleBind();
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.quantitySpn);
        this.ctrlCount.ctrl(this.quantitySpn);
        this.quantityDisableBind();
        MxBindings.bindSI((Property)this.quantitySpn.getEditor().textProperty(), (Property)this.neeqModel.countProperty());
        this.quantitySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> Platform.runLater(() -> this.quantityKeyPress((KeyEvent)event)));
        this.quantitySpn.getEditor().setOnMouseClicked(event -> this.quantitySpn.getEditor().selectAll());
        this.quantitySpn.focusedProperty().addListener((ob, old, val) -> this.qtyLoseFocus((Boolean)val));
    }

    protected void createMarketTable() {
    }

    protected void afterTableRestore() {
        this.canBuyCol.setVisible(false);
    }

    protected void createAcctTree() {
        this.cmbDist.setItems(this.neeqModel.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.neeqModel.distStgProperty());
        this.cmbAccFilter.setItems(this.neeqModel.getAccFilterStg().getNodes());
        this.cmbAccFilter.valueProperty().bindBidirectional(this.neeqModel.accFilterStgProperty());
        this.hBoxPartlyAccCount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.neeqModel.getAccFilterStg().getRaw().equals("1"), (Observable[])new Observable[]{this.neeqModel.accFilterStgProperty()}));
        MxBindings.bindSI((Property)this.lbSecAccCount.textProperty(), (Property)this.neeqModel.getAccDisModel().effectiveSecAccCountProperty());
        MxBindings.bindSI((Property)this.textAccCount.textProperty(), (Property)this.neeqModel.getAccDisModel().customSecAccCountProperty());
        this.textAccCount.setTextFormatter(new TextFormatter((UnaryOperator)new TradeAcctCountFilter(true, 9, this.neeqModel.getAccDisModel().effectiveSecAccCountProperty())));
        this.txtSearch.textProperty().bindBidirectional((Property)this.neeqModel.getAccDisModel().searchSecProperty());
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.accountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccountCollapseCell());
        this.secAcctCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.availableCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().availableProperty());
        this.availableCol.setCellFactory(p -> new MoneyCell(2));
        this.canBuyCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canBuyProperty());
        this.canBuyCol.setEditable(false);
        this.assetCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().newAssetAmtProperty());
        this.assetCol.setCellFactory(p -> new MoneyCell(2));
        this.weightCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(p -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).countProperty());
        this.amountCol.setCellFactory(p -> new NumberTreeTableCell());
        this.productCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleStringProperty("") : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().productNameProperty());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.acctTreeTable.setRoot(this.neeqModel.getAccDisModel().getRoot());
        this.acctTreeTable.setShowRoot(false);
        this.acctTreeTable.sort();
        this.acctTreeTable.refresh();
        this.acctTreeTable.setPlaceholder((Node)new Label());
        this.acctTreeTable.setEditable(true);
        this.availableCol.setEditable(false);
        this.assetCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.acctTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.neeqModel.getAccDisModel().refresh());
        itemCopy.setOnAction(event -> this.copy());
        this.acctTreeSupplement();
    }

    protected void acctTreeSupplement() {
        this.canBuyCol.setCellFactory(p -> new MoneyCell(0));
        TableUtils.orgnizeClmWidth(this.acctTreeTable);
    }

    protected void onMktItemChange() {
    }

    protected void onBSChange(Boolean old, Boolean now) {
        this.layout();
    }

    protected void onPriceTypeChange() {
        this.priceSpn.getEditor().clear();
        this.hideShow();
    }

    private void hideShow() {
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCodeInstrument.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCodeInstrument.selectAll());
        }
    }

    private void priceLoseFocus(Boolean val) {
        double price = this.neeqModel.getPrice();
        if (!val.booleanValue() && price > 0.0 && this.issueInfo != null && (price < this.issueInfo.getParams().getPriceLowerLimit() || price > this.issueInfo.getParams().getPriceUpperLimit())) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8be2\u4ef7\u7533\u62a5\u7684\u4ef7\u683c\u9700\u8981\u5728\u8be2\u4ef7\u4ef7\u683c\u533a\u95f4\u5185");
            return;
        }
    }

    private void qtyLoseFocus(Boolean val) {
        long count = this.neeqModel.getCount();
        if (!val.booleanValue() && count > 0L) {
            if (!this.countIsVaild(count)) {
                this.alert.alert(Alert.AlertType.WARNING, "\u8be2\u4ef7\u6570\u91cf\u5fc5\u987b\u662f100\u53ca100\u7684\u6574\u6570\u500d");
                return;
            }
            if (this.issueInfo != null && ((double)count < this.issueInfo.getParams().getQtyLowerLimit() || (double)count > this.issueInfo.getParams().getQtyUpperLimit())) {
                this.alert.alert(Alert.AlertType.WARNING, "\u8be2\u4ef7\u7533\u62a5\u7684\u6570\u91cf\u9700\u8981\u5728\u8be2\u4ef7\u6570\u91cf\u533a\u95f4\u5185");
                return;
            }
        }
    }

    private boolean countIsVaild(long count) {
        return count % 100L == 0L;
    }

    protected void onSecurityChange(TextField txtCode, String newText) {
        this.txtCodeInstrument.setText(txtCode.getText());
        Object obj = txtCode.getUserData();
        this.issueInfo = obj instanceof IssueInfo ? (IssueInfo)IssueInfo.class.cast(obj) : null;
        long beginChange = System.currentTimeMillis();
        this.doChange(this.issueInfo, newText);
        this.logger.info("dochange:" + (System.currentTimeMillis() - beginChange));
    }

    protected void setPrePrice() {
        if (this.neeqModel.getPrice() > 0.0 || this.priceSpn.isDisabled() || this.priceSettle) {
            return;
        }
    }

    protected void doChange(IssueInfo info, String newText) {
        this.neeqModel.setInfo(info);
        if (info != null) {
            this.txtCode.setText(String.valueOf(info.getParams().getUnderlying().getSecurityId()) + ":" + info.getSecurity().getInstrument().getSymbol());
            String lowerPrice = StringUtils.toStr((double)info.getParams().getPriceLowerLimit(), (int)2);
            String upperPrice = StringUtils.toStr((double)info.getParams().getPriceUpperLimit(), (int)2);
            this.lbPriceRange.setText(String.valueOf(lowerPrice) + "\u2014\u2014" + upperPrice);
            String lowerLimit = StringUtils.toStr((double)info.getParams().getQtyLowerLimit(), (int)1);
            String upperLimit = StringUtils.toStr((double)info.getParams().getQtyUpperLimit(), (int)1);
            this.lbQtyRange.setText(String.valueOf(lowerLimit) + "\u2014\u2014" + upperLimit);
            this.lbStartEndDate.setText(String.valueOf(info.getParams().getStartDate()) + "\u2014\u2014" + info.getParams().getEndDate());
            this.lbQty.setText(StringUtils.toStr((double)info.getParams().getOutstandingShare(), (int)1));
            if (info.getParams().getPriceLowerLimit() == info.getParams().getPriceUpperLimit()) {
                this.priceSpn.getValueFactory().setValue((Object)info.getParams().getPriceLowerLimit());
                this.neeqModel.setPrice(info.getParams().getPriceLowerLimit());
            }
        } else {
            this.txtCode.setText("");
            this.lbQtyRange.setText(" - -");
            this.lbStartEndDate.setText(" - -");
            this.lbPriceRange.setText(" - -");
            this.lbQty.setText(" - -");
            this.neeqModel.setPrice(0.0);
            this.priceSpn.getValueFactory().setValue((Object)0.0);
        }
        this.quantitySpn.getEditor().clear();
        this.neeqModel.onSecChange();
        this.txtCodeInstrument.selectEnd();
        this.txtCodeInstrument.deselect();
        if (newText.length() >= 6) {
            this.check();
        }
        if (this.neeqModel.isValidRef()) {
            this.setPrePrice();
        }
        this.layout();
    }

    protected void checkRepo() {
    }

    protected void onPriceTypeLimitedChange(MxNode newV) {
    }

    protected void quantityDisableBind() {
    }

    protected void priceDisableBind() {
    }

    protected void priceVisibleBind() {
    }

    private void check() {
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (NeeqInquiryPurchaseBasePart.this.txtCodeInstrument.getText().length() < 6) {
                    return;
                }
                Platform.runLater(() -> {
                    if (NeeqInquiryPurchaseBasePart.this.issueInfo == null) {
                        NeeqInquiryPurchaseBasePart.this.txtCode.setText(NeeqInquiryPurchaseBasePart.INVALID_CODE);
                    }
                });
            }
        };
        timer.schedule(task, 500L);
    }

    protected void setPriceUnit() {
    }

    public boolean valid() {
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.neeqModel.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        if (!this.priceValid()) {
            return false;
        }
        String tip4 = "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u6237\uff0c\u4ee5\u53ca\u4e00\u4e2a\u80a1\u4e1c\u4ee3\u7801\u8fdb\u884c\u8be2\u4ef7";
        if (!this.alert.check(this.neeqModel.getAccDisModel().getSelectedNum() >= 1 && this.neeqModel.getAccDisModel().getSelectedNum() < 2, Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        if (!this.alert.check(this.neeqModel.getCount() >= 0L && this.neeqModel.getAccDisModel().isCountValid() != false && this.countIsVaild(this.neeqModel.getCount()), Alert.AlertType.WARNING, tip5)) {
            return false;
        }
        String tip2 = "\u8be2\u4ef7\u7533\u62a5\u7684\u6570\u91cf\u9700\u8981\u5728\u8be2\u4ef7\u6570\u91cf\u533a\u95f4\u5185";
        return this.alert.check((double)this.neeqModel.getCount() >= this.issueInfo.getParams().getQtyLowerLimit() && (double)this.neeqModel.getCount() <= this.issueInfo.getParams().getQtyUpperLimit(), Alert.AlertType.WARNING, tip2);
    }

    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        if (!this.alert.check(this.neeqModel.getPrice() > 0.0, Alert.AlertType.WARNING, tip3)) {
            return false;
        }
        String tip4 = "\u8be2\u4ef7\u7533\u62a5\u7684\u4ef7\u683c\u9700\u8981\u5728\u8be2\u4ef7\u4ef7\u683c\u533a\u95f4\u5185";
        return this.alert.check(this.neeqModel.getPrice() >= this.issueInfo.getParams().getPriceLowerLimit() && this.neeqModel.getPrice() <= this.issueInfo.getParams().getPriceUpperLimit(), Alert.AlertType.WARNING, tip4);
    }

    protected String getOrderInfo() {
        StringBuilder info = new StringBuilder();
        for (CcsAccountDistribution acc : this.neeqModel.getAccDisModel().getValidSecAcc()) {
            info.append("\n\u8d26\u53f7   " + acc.getSecAcc().getInverstorSecId() + " \u59d4\u6258\u6570\u91cf   " + acc.getCount());
        }
        return info.toString();
    }

    @FXML
    public void order() {
        this.neeqModel.getAccDisModel().getValidSecAcc();
        if (this.valid()) {
            this.issueInfo.getIssueId();
            List<NewCcsSingleEntrust> entrusts = this.neeqModel.getEntrustList();
            NeeqEntrustInquiryConfirmDialog obj = (NeeqEntrustInquiryConfirmDialog)((Object)this.of.create(NeeqEntrustInquiryConfirmDialog.class));
            if (!"4".equals(this.neeqModel.getAccDisModel().getInstructType()) && !"3".equals(this.neeqModel.getAccDisModel().getInstructType())) {
                obj.setInstruction(true);
                obj.setInquiry(true);
            } else {
                obj.setExecution(true);
                obj.setInquiry(true);
            }
            obj.setInstructionPanelType(this.neeqModel.getAccDisModel().getInstructType());
            obj.setUnit("\u80a1");
            obj.setList(entrusts);
            MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) ? "\u8be2\u4ef7\u786e\u8ba4" : String.valueOf(this.confirmSymbol) + "\u786e\u8ba4");
            if (dialog.launch() == ButtonType.OK) {
                this.submitOrder(entrusts);
            }
            this.layout();
        }
    }

    protected void submitOrder(List<NewCcsSingleEntrust> entrusts) {
        Result result = null;
        try {
            result = this.doAction(entrusts);
            if (result.failed > 0) {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14" + result.getReason().toString());
            } else {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14");
            }
        }
        catch (Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25" + e.toString());
            this.logger.error("\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            this.logger.error("\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
    }

    protected Result doAction(List<NewCcsSingleEntrust> entrusts) throws MException {
        return this.neeqModel.submit(entrusts);
    }

    protected void fillInstruction() throws MException {
    }

    public void codeInstrumentKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.quantitySpn.requestFocus();
            key.consume();
        }
    }

    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCodeInstrument.requestFocus();
            this.txtCodeInstrument.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            long count = this.neeqModel.getCount();
            if (count > 0L) {
                if (!this.countIsVaild(count)) {
                    return;
                }
                if (this.issueInfo != null && ((double)count < this.issueInfo.getParams().getQtyLowerLimit() || (double)count > this.issueInfo.getParams().getQtyUpperLimit())) {
                    return;
                }
            }
            this.order();
            key.consume();
        }
    }

    protected void onItemSelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            Platform.runLater(() -> this.clearSelection());
        }
    }

    protected void clearSelection() {
    }

    public void setPrice(double price) {
    }

    private void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.accountCol.getText()) + "\t" + this.secAcctCol.getText() + "\t" + this.availableCol.getText() + "\t" + this.assetCol.getText() + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + this.productCol.getText() + "\t" + '\n');
        for (TreeItem item : this.neeqModel.getAccDisModel().getRoot().getChildren()) {
            CcsAccountDistribution accDis = (CcsAccountDistribution)item.getValue();
            clipboardString.append(accDis.getAcc() + "\t" + "\t" + accDis.getAcc().getAvailable() + "\t" + accDis.getAcc().getNewAssetAmt() + "\t" + accDis.getWeight() + "\t" + accDis.getCount() + "\t" + accDis.getAcc().getProductName() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                CcsAccountDistribution secAccDis = (CcsAccountDistribution)subItem.getValue();
                clipboardString.append("\t" + secAccDis.getSecAcc() + "\t" + "\t" + "\t" + secAccDis.getWeight() + "\t" + secAccDis.getCount() + "\t" + "\t" + "\t" + '\n');
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private void doCheckChildrenSelected(TreeItem<CcsAccountDistribution> treeItem) {
        TreeItem prtItem = treeItem.getParent();
        Boolean isSelected = false;
        if (prtItem != null && prtItem.getValue() != null) {
            for (TreeItem eachItem : prtItem.getChildren()) {
                if (!((CcsAccountDistribution)eachItem.getValue()).isSelected()) continue;
                isSelected = true;
                break;
            }
            ((CcsAccountDistribution)prtItem.getValue()).setSelected(isSelected.booleanValue());
        }
    }

    public TreeTableView<CcsAccountDistribution> getAccTreeTable() {
        return this.acctTreeTable;
    }

    protected void clearInfo() {
        this.btnOrder.setDisable(true);
    }

    protected void onApprove(boolean isApprove) {
        this.txtCode.setDisable(true);
        this.btnOrder.setDisable(true);
        this.acctTreeTable.setDisable(isApprove);
        this.priceSpn.setDisable(true);
        this.quantitySpn.setDisable(true);
        this.cmbDist.setDisable(true);
        this.cmbAccFilter.setDisable(true);
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public Spinner<Integer> getQuantitySpn() {
        return this.quantitySpn;
    }

    public void setCount(Long buyQuantity) {
        this.neeqModel.setCount(buyQuantity);
    }

    public void setMoney(double value) {
        this.neeqModel.setMoney(value);
    }

    public void setCountPer(Double value) {
        this.neeqModel.setCountPer(value);
    }

    public void setAutoSlice(boolean slice, long size) {
        this.neeqModel.setAutoSlice(slice);
        this.neeqModel.setSliceSize(size);
    }

    public IssueInfo getValidRef() {
        return this.neeqModel.getValidRef();
    }

    public String getConfirmSymbol() {
        return this.confirmSymbol;
    }

    public void setConfirmSymbol(String confirmSymbol) {
        this.confirmSymbol = confirmSymbol;
    }

    public IssueInfo getIssueInfo() {
        return this.issueInfo;
    }

    public void setIssueInfo(IssueInfo issueInfo) {
        this.issueInfo = issueInfo;
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }

    private class MoneyCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class WeightCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((CcsAccountDistribution)this.getTreeTableRow().getItem()).isSecAccProperty());
            }
        }
    }
}

