/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view.distribution.business;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ObSingleOrderNeeq;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.neeq.model.distribution.business.NeeqInquiryOrderModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;

public class NeeqInquiryOrderPart
extends MxPagePart<SingleOrder, ObSingleOrderNeeq> {
    @FXML
    private TableColumn<ObSingleOrderNeeq, String> neeqErrInfo;
    @FXML
    private TableColumn<ObSingleOrderNeeq, Number> orderQty;
    @FXML
    private TableColumn<ObSingleOrderNeeq, Number> cumQty;
    @FXML
    private TableColumn<ObSingleOrderNeeq, Number> price;
    @FXML
    private TableColumn<ObSingleOrderNeeq, Number> avgPx;
    @Inject
    private NeeqInquiryOrderModel model;
    @Inject
    private MxAlert alert;

    protected boolean predicate(SingleOrder data) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = data.getInstrument().getSecurityId().toUpperCase();
        String name = data.getInstrument().getSymbol().toUpperCase();
        String orderId = data.getExtOrderId();
        return code.contains(text) || orderId.contains(text) || name.contains(text);
    }

    @FXML
    protected void refresh() {
        try {
            this.model.query();
            this.tableView.refresh();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    protected List<SingleOrder> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.neeqErrInfo.setCellFactory(data -> new TooltipTableCell<ObSingleOrderNeeq, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSingleOrderNeeq)this.getValue()).getNeeqErrInfo();
                }
                return null;
            }
        });
        this.orderQty.setCellFactory(data -> new NumberTableCell());
        this.cumQty.setCellFactory(data -> new NumberTableCell());
        this.price.setCellFactory(data -> new DoubleTableCell());
        this.avgPx.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setPlaceholder((Node)new Label());
        Collections.sort(this.mxList.getList(), (o1, o2) -> {
            String x2;
            String x1 = o1.getOrdDate();
            int sComp = x1.compareTo(x2 = o2.getOrdDate());
            if (sComp != 0) {
                return sComp;
            }
            String y1 = o1.getOrdTime();
            String y2 = o2.getOrdTime();
            return y1.compareTo(y2);
        });
        this.tableView.setItems(this.mxList.getPageList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listOrder, (String)"\u8be2\u4ef7\u59d4\u6258\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    public void defaultSort() {
        Collections.sort(this.mxList.getList(), (o1, o2) -> {
            String x1 = o1.getOrdDate();
            String x2 = o2.getOrdDate();
            int sComp = x2.compareTo(x1);
            if (sComp != 0) {
                return sComp;
            }
            String y1 = o1.getOrdTime();
            String y2 = o2.getOrdTime();
            return y2.compareTo(y1);
        });
    }
}

