/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view.distribution.business;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ObRfqResultNeeq;
import cms.tmx.http.neeq.RfqResult;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.neeq.model.NeeqRfqResultModel;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;

public class NeeqInquiryDealPart
extends MxPagePart<RfqResult, ObRfqResultNeeq> {
    @FXML
    private TableColumn<ObRfqResultNeeq, Number> price;
    @FXML
    private TableColumn<ObRfqResultNeeq, String> tradeDate;
    @FXML
    private TableColumn<ObRfqResultNeeq, String> execId;
    @Inject
    private NeeqRfqResultModel model;
    @Inject
    private MxAlert alert;

    @FXML
    protected void refresh() {
        try {
            this.model.query();
            this.tableView.refresh();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    protected boolean predicate(RfqResult data) {
        String code;
        String text = this.searchText.getText().trim().toUpperCase();
        String instrumentId = data.getInstrument().getSecurityId();
        String name = data.getInstrument().getSymbol().toUpperCase();
        if (data.getUnderlying() != null && (code = data.getUnderlying().getSecurityId().toUpperCase()).contains(text)) {
            return true;
        }
        return instrumentId.contains(text) || name.contains(text);
    }

    protected List<RfqResult> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.price.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getTradeTime().compareTo(o1.getTradeTime()));
        this.tableView.setItems(this.mxList.getPageList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listOrder, (String)"\u8be2\u4ef7\u7ed3\u679c\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getTradeTime().compareTo(o1.getTradeTime()));
    }
}

