/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view.distribution.business;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.IssueInfoItem;
import cms.tmx.entity.trade.NeeqInquiryDetail;
import cms.tmx.entity.trade.ObIssueInfoPurchaseNeeq;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.OrderServiceApi;
import cms.tmx.http.api.strategy.dto.GetSingleOrdersReq;
import cms.tmx.http.api.strategy.dto.GetSingleOrdersResp;
import cms.tmx.http.api.strategy.dto.OrdStatus;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.data.IssueInfo;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.neeq.model.NeeqAccntAggreementQueryModel;
import cms.tmx.neeq.model.distribution.business.NeeqIssueInfoInquiryModel;
import cms.tmx.neeq.view.distribution.business.NeeqInquiryDetailDialog;
import cms.tmx.neeq.view.distribution.business.NeeqOneKeyInquiryDialog;
import cms.tmx.rights.IUiRightService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javax.inject.Inject;

public class NeeqCanInquiryStockPart
extends MxPagePart<IssueInfo, ObIssueInfoPurchaseNeeq> {
    @Inject
    private NeeqIssueInfoInquiryModel model;
    @Inject
    private MEventService es;
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    protected OrderServiceApi api;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    protected IFundAccountService fundApi;
    @FXML
    private TableColumn<ObIssueInfoPurchaseNeeq, Number> outstandingShare;
    @FXML
    private TableColumn<ObIssueInfoPurchaseNeeq, String> detail;
    @Inject
    private IUiRightService rightModel;
    @FXML
    private Button btnOneKey;
    @Inject
    protected NeeqAccntAggreementQueryModel agreementModel;

    @FXML
    protected void refresh() {
        try {
            this.model.query();
            this.tableView.refresh();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    private boolean checkAuth(CcsFundAccount fundAcc, SecAccount sec) {
        List<Integer> authList = Arrays.asList(1, 4, 5);
        return this.agreementModel.checkAuth((FundAccount)fundAcc, sec, authList);
    }

    @FXML
    private void oneKey() {
        MEvent event = new MEvent();
        event.put((Object)"type", (Object)"2");
        this.es.sendEvent("neeq.one.key.check.accnt", event);
        List cast = (List)List.class.cast(event.get((Object)"data"));
        List sec = (List)List.class.cast(event.get((Object)"para"));
        if (cast == null) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\uff0c\u4ee5\u53ca\u4e00\u4e2a\u80a1\u4e1c\u4ee3\u7801\u8fdb\u884c\u4e00\u952e\u8be2\u4ef7");
            return;
        }
        if (cast.size() > 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\uff0c\u4ee5\u53ca\u4e00\u4e2a\u80a1\u4e1c\u4ee3\u7801\u8fdb\u884c\u4e00\u952e\u8be2\u4ef7");
            return;
        }
        if (cast.size() == 0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\uff0c\u4ee5\u53ca\u4e00\u4e2a\u80a1\u4e1c\u4ee3\u7801\u8fdb\u884c\u4e00\u952e\u8be2\u4ef7");
            return;
        }
        if (sec.size() > 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\uff0c\u4ee5\u53ca\u4e00\u4e2a\u80a1\u4e1c\u4ee3\u7801\u8fdb\u884c\u4e00\u952e\u8be2\u4ef7");
            return;
        }
        CcsFundAccount fundAcc = (CcsFundAccount)cast.get(0);
        SecAccount secAcc = (SecAccount)sec.get(0);
        String investorId = ((CcsFundAccount)cast.get(0)).getInvestId();
        String investorSecId = ((SecAccount)sec.get(0)).getInverstorSecId();
        ObservableList list = FxUtils.newList();
        ObservableList items = this.tableView.getItems();
        for (ObIssueInfoPurchaseNeeq obIssueInfoPurchaseNeeq : items) {
            boolean auth = this.checkAuth(fundAcc, secAcc);
            if (!auth) continue;
            IssueInfoItem item = new IssueInfoItem();
            item.update((Object)obIssueInfoPurchaseNeeq);
            item.setTradeStatus("\u8be2\u4ef7");
            item.setInvestorId(investorId);
            item.setInvestorsecId(investorSecId);
            list.add((Object)item);
        }
        NeeqOneKeyInquiryDialog obj = (NeeqOneKeyInquiryDialog)((Object)this.of.create(NeeqOneKeyInquiryDialog.class));
        obj.setList((ObservableList<IssueInfoItem>)list);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e00\u952e\u8be2\u4ef7");
        dialog.setBtnText(ButtonType.OK, "\u8be2\u4ef7");
        dialog.launch();
        Result result = obj.getResult();
        if (result == null) {
            return;
        }
        if (result.failed > 0) {
            this.alert.check(false, Alert.AlertType.ERROR, "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14");
        } else {
            this.alert.check(false, Alert.AlertType.INFORMATION, "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14");
        }
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listOrder, (String)"\u53ef\u8be2\u4ef7\u80a1\u7968\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    protected void initialize() {
        super.initialize();
        this.rightModel.registerCheck((Control)this.btnOneKey, new String[]{"cms.tmx.neeq.part.inquiry.stock.query_oneKey"});
    }

    protected boolean predicate(IssueInfo data) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = data.getSecurityId().toUpperCase();
        String name = data.getSecurityName().toUpperCase();
        String issueId = data.getIssueId();
        return code.contains(text) || issueId.contains(text) || name.contains(text);
    }

    protected List<IssueInfo> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.tableView.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2) {
                try {
                    ObIssueInfoPurchaseNeeq info = (ObIssueInfoPurchaseNeeq)this.tableView.getSelectionModel().getSelectedItem();
                    if (info != null) {
                        MEvent eCall = new MEvent();
                        eCall.put((Object)"issue_code", (Object)info.getIssueId());
                        this.es.sendEvent("neeq.inquiry.order", eCall);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e, (Throwable)e);
                    this.alert.alert(Alert.AlertType.ERROR, "\u53cc\u51fb\u586b\u5355\u5931\u8d25" + e.getMessage());
                }
            }
        });
        this.outstandingShare.setCellFactory(data -> new NumberTableCell());
        this.detail.setCellFactory(data -> new OperaCell((TableView<ObIssueInfoPurchaseNeeq>)this.tableView));
        this.tableView.setPlaceholder((Node)new Label());
        this.defaultSort();
        this.tableView.setItems(this.mxList.getPageList());
    }

    public void queryDetail() {
        try {
            NeeqInquiryDetailDialog obj = (NeeqInquiryDetailDialog)((Object)this.of.create(NeeqInquiryDetailDialog.class));
            ObservableList data = FxUtils.newList();
            List<SingleOrder> list = this.queryEffectivOrderByIssueId((ObIssueInfoPurchaseNeeq)this.tableView.getSelectionModel().getSelectedItem(), new LinkedList<SingleOrder>());
            if (list.isEmpty()) {
                NeeqInquiryDetail detail = new NeeqInquiryDetail();
                ObIssueInfoPurchaseNeeq item = (ObIssueInfoPurchaseNeeq)this.tableView.getSelectionModel().getSelectedItem();
                detail.setIssueId(item.getIssueId());
                detail.setSecurityId(item.getSecurityId());
                detail.setSecurityName(item.getSecurityName());
                detail.setInquiryStatus("\u672a\u8be2\u4ef7");
                data.add((Object)detail);
            } else {
                boolean flag = true;
                Collections.sort(list, (o1, o2) -> o2.getOrdDateTime().compareTo(o1.getOrdDateTime()));
                HashSet<String> set = new HashSet<String>();
                for (SingleOrder singleOrder : list) {
                    NeeqInquiryDetail detail = new NeeqInquiryDetail();
                    detail.update((Object)singleOrder);
                    String key = String.valueOf(singleOrder.getInvestorId()) + "," + singleOrder.getInvestorSecId();
                    if (set.contains(key) || singleOrder.getOrdStatus() != OrdStatus.ORD_STATUS_NEW && singleOrder.getOrdStatus() != OrdStatus.ORD_STATUS_PARTIALLY_FILLED && singleOrder.getOrdStatus() != OrdStatus.ORD_STATUS_FILLED && singleOrder.getOrdStatus() != OrdStatus.ORD_STATUS_DONE_FOR_DAY) continue;
                    detail.setInquiryStatus("\u5df2\u8be2\u4ef7");
                    data.add((Object)detail);
                    set.add(key);
                    flag = false;
                }
                if (flag) {
                    NeeqInquiryDetail detail = new NeeqInquiryDetail();
                    ObIssueInfoPurchaseNeeq item = (ObIssueInfoPurchaseNeeq)this.tableView.getSelectionModel().getSelectedItem();
                    detail.setIssueId(item.getIssueId());
                    detail.setSecurityId(item.getSecurityId());
                    detail.setSecurityName(item.getSecurityName());
                    detail.setInquiryStatus("\u672a\u8be2\u4ef7");
                    data.add((Object)detail);
                }
            }
            obj.setList((ObservableList<NeeqInquiryDetail>)data);
            MxDialog dialog = this.df.create((DialogObj)obj, "\u8be6\u60c5");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
        }
        catch (MException | Exception e) {
            this.logger.error((Object)e, e);
        }
    }

    private List<SingleOrder> queryEffectivOrderByIssueId(ObIssueInfoPurchaseNeeq item, List<SingleOrder> list) throws IOException, MException {
        GetSingleOrdersReq req = new GetSingleOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGrp("CCS");
        req.setApplId("800");
        req.setSide(Side.SIDE_BID);
        Instrument instrument = new Instrument();
        instrument.setMarketIndicator("COMMON_ISSUE");
        instrument.setSecurityId(item.getIssueId());
        req.setInstrument(instrument);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(new Date());
        req.setEndDate(today);
        LinkedList<String> ids = new LinkedList<String>();
        List fundAccountList = this.fundApi.getNeeqFundAccountList();
        for (FundAccount fundAccount : fundAccountList) {
            ids.add(fundAccount.getNewCashAccntId());
        }
        req.setExtCashAccntId(ids);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        GetSingleOrdersResp resp = this.api.getOrders(req);
        list.clear();
        Page pageResp = resp.getPage();
        list.addAll(resp.getOrder());
        int queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)pageReq.getPageSize());
        while (--queryTimes > 0) {
            pageReq.setStartRow(pageReq.getPageSize() + pageReq.getStartRow());
            req.setPage(pageReq);
            GetSingleOrdersResp getSingleOrdersResp = this.api.getOrders(req);
            list.addAll(getSingleOrdersResp.getOrder());
        }
        for (SingleOrder singleOrder : list) {
            singleOrder.setExtraFields();
        }
        list = list.stream().filter(o -> OrdStatus.ORD_STATUS_NEW == o.getOrdStatus() || OrdStatus.ORD_STATUS_FILLED == o.getOrdStatus() || OrdStatus.ORD_STATUS_PARTIALLY_FILLED == o.getOrdStatus() || OrdStatus.ORD_STATUS_DONE_FOR_DAY == o.getOrdStatus()).collect(Collectors.toList());
        return list;
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getStartDate().compareTo(o1.getStartDate()));
    }

    private class OperaCell
    extends TableCell<ObIssueInfoPurchaseNeeq, String> {
        final Label detaiLab = new Label("\u8be6\u60c5");
        final HBox paddedLabel = new HBox();

        OperaCell(final TableView<ObIssueInfoPurchaseNeeq> table) {
            this.paddedLabel.setSpacing(20.0);
            this.detaiLab.setStyle("-fx-cursor:hand;");
            this.detaiLab.getStyleClass().add((Object)"text-blue");
            this.paddedLabel.getChildren().add((Object)this.detaiLab);
            HBox.setMargin((Node)this.detaiLab, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
            this.detaiLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    NeeqCanInquiryStockPart.this.queryDetail();
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

