/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view.distribution.business;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.IssueInfoItem;
import cms.tmx.entity.trade.NeeqIssueDetail;
import cms.tmx.entity.trade.ObIssueInfoPurchaseNeeq;
import cms.tmx.http.api.strategy.api.OrderServiceApi;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.data.IssueInfo;
import cms.tmx.http.neeq.RfqResult;
import cms.tmx.http.neeq.RfqStatus;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.neeq.model.NeeqAccntAggreementQueryModel;
import cms.tmx.neeq.model.NeeqRfqResultModel;
import cms.tmx.neeq.model.distribution.business.NeeqApplicationOrderModel;
import cms.tmx.neeq.model.distribution.business.NeeqIssueInfoPurchaseModel;
import cms.tmx.neeq.view.distribution.business.NeeqIssueDetailDialog;
import cms.tmx.neeq.view.distribution.business.NeeqOneKeyDialog;
import cms.tmx.rights.IUiRightService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javax.inject.Inject;

public class NeeqCanApplicationStockPart
extends MxPagePart<IssueInfo, ObIssueInfoPurchaseNeeq> {
    @Inject
    private NeeqIssueInfoPurchaseModel model;
    @Inject
    private NeeqRfqResultModel rfqModel;
    @Inject
    private NeeqApplicationOrderModel orderModel;
    @Inject
    protected NeeqAccntAggreementQueryModel agreementModel;
    @Inject
    private MEventService es;
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    protected OrderServiceApi api;
    @Inject
    private IUiRightService rightModel;
    @FXML
    private Button btnOneKey;
    @Inject
    protected IFundAccountService fundApi;
    @FXML
    private TableColumn<ObIssueInfoPurchaseNeeq, Number> outstandingShare;
    @FXML
    private TableColumn<ObIssueInfoPurchaseNeeq, String> detail;
    @FXML
    private TableColumn<ObIssueInfoPurchaseNeeq, String> tradeStatus;

    @FXML
    protected void refresh() {
        try {
            this.model.query();
            this.tableView.refresh();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    protected void initialize() {
        super.initialize();
        this.rightModel.registerCheck((Control)this.btnOneKey, new String[]{"cms.tmx.neeq.part.application.stock.query_oneKey"});
    }

    @FXML
    private void oneKey() {
        MEvent event = new MEvent();
        event.put((Object)"type", (Object)"1");
        this.es.sendEvent("neeq.one.key.check.accnt", event);
        List cast = (List)List.class.cast(event.get((Object)"data"));
        List secs = (List)List.class.cast(event.get((Object)"para"));
        if (cast == null) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\uff0c\u4ee5\u53ca\u4e00\u4e2a\u80a1\u4e1c\u4ee3\u7801\u8fdb\u884c\u4e00\u952e\u7533\u8d2d");
            return;
        }
        if (cast.size() > 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\uff0c\u4ee5\u53ca\u4e00\u4e2a\u80a1\u4e1c\u4ee3\u7801\u8fdb\u884c\u4e00\u952e\u7533\u8d2d");
            return;
        }
        if (cast.size() == 0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\uff0c\u4ee5\u53ca\u4e00\u4e2a\u80a1\u4e1c\u4ee3\u7801\u8fdb\u884c\u4e00\u952e\u7533\u8d2d");
            return;
        }
        if (secs.size() > 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\uff0c\u4ee5\u53ca\u4e00\u4e2a\u80a1\u4e1c\u4ee3\u7801\u8fdb\u884c\u4e00\u952e\u7533\u8d2d");
            return;
        }
        CcsFundAccount fundAcc = (CcsFundAccount)cast.get(0);
        SecAccount sec = (SecAccount)secs.get(0);
        ObservableList list = FxUtils.newList();
        ObservableList items = this.tableView.getItems();
        for (ObIssueInfoPurchaseNeeq obIssueInfoPurchaseNeeq : items) {
            IssueInfoItem item = new IssueInfoItem();
            item.update((Object)obIssueInfoPurchaseNeeq);
            List<RfqResult> faildList = this.rfqModel.getFaildList(obIssueInfoPurchaseNeeq.getIssueId());
            boolean fail = false;
            if (!faildList.isEmpty()) {
                for (RfqResult rfqResult : faildList) {
                    if (!rfqResult.getInvestorId().equals(fundAcc.getInvestId()) || !rfqResult.getInvestorSecId().equals(sec.getInverstorSecId())) continue;
                    fail = true;
                    break;
                }
            }
            if (fail) continue;
            List<RfqResult> successList = this.rfqModel.getSuccessList(obIssueInfoPurchaseNeeq.getIssueId());
            if (successList.isEmpty() && !this.orderModel.hasEffectiveOrder(obIssueInfoPurchaseNeeq.getIssueId(), fundAcc.getInvestId(), sec.getInverstorSecId())) {
                item.setInvestorId(fundAcc.getInvestId());
                item.setInvestorsecId(sec.getInverstorSecId());
                item.setIqueryStatus("\u672a\u8be2\u4ef7");
                boolean auth = this.checkAuth(fundAcc, sec);
                if (!auth) continue;
                list.add((Object)item);
                continue;
            }
            boolean have = false;
            for (RfqResult rfqResult : successList) {
                if (rfqResult.getStatus() != RfqStatus.kStatusCreated || this.orderModel.hasEffectiveOrder(obIssueInfoPurchaseNeeq.getIssueId(), rfqResult.getInvestorId(), rfqResult.getInvestorSecId())) continue;
                item.setInvestorId(rfqResult.getInvestorId());
                item.setInvestorsecId(rfqResult.getInvestorSecId());
                item.setAccntUpdate(false);
                item.setIqueryStatus("\u8be2\u4ef7\u6210\u529f\uff0c\u8bf7\u5c65\u884c\u7533\u8d2d\u4e49\u52a1");
                item.setQty(rfqResult.getMaxQty());
                item.setQtyRange(String.valueOf(rfqResult.getMinQty()) + "--" + rfqResult.getMaxQty());
                list.add((Object)item);
                have = true;
                break;
            }
            if (have || this.orderModel.hasEffectiveOrder(obIssueInfoPurchaseNeeq.getIssueId(), fundAcc.getInvestId(), sec.getInverstorSecId())) continue;
            item.setInvestorId(fundAcc.getInvestId());
            item.setInvestorsecId(sec.getInverstorSecId());
            item.setIqueryStatus("\u672a\u8be2\u4ef7");
            boolean auth = this.checkAuth(fundAcc, sec);
            if (!auth) continue;
            list.add((Object)item);
        }
        NeeqOneKeyDialog obj = (NeeqOneKeyDialog)((Object)this.of.create(NeeqOneKeyDialog.class));
        obj.setList((ObservableList<IssueInfoItem>)list);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e00\u952e\u7533\u8d2d");
        dialog.setBtnText(ButtonType.OK, "\u7533\u8d2d");
        if (dialog.launch() == ButtonType.OK) {
            Result result = obj.getResult();
            this.alert.alert(Alert.AlertType.INFORMATION, result.getDesc());
        }
    }

    private boolean checkAuth(CcsFundAccount fundAcc, SecAccount sec) {
        List<Integer> authList = Arrays.asList(1, 4, 5);
        return this.agreementModel.checkAuth((FundAccount)fundAcc, sec, authList);
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listOrder, (String)"\u53ef\u7533\u8d2d\u80a1\u7968\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    protected boolean predicate(IssueInfo data) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = data.getSecurityId().toUpperCase();
        String name = data.getSecurityName().toUpperCase();
        String issueId = data.getIssueId();
        return code.contains(text) || issueId.contains(text) || name.contains(text);
    }

    protected List<IssueInfo> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.tableView.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2) {
                try {
                    ObIssueInfoPurchaseNeeq info = (ObIssueInfoPurchaseNeeq)this.tableView.getSelectionModel().getSelectedItem();
                    if (info != null) {
                        MEvent eCall = new MEvent();
                        eCall.put((Object)"issue_code", (Object)info.getIssueId());
                        this.es.sendEvent("neeq.fast.order", eCall);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e, (Throwable)e);
                    this.alert.alert(Alert.AlertType.ERROR, "\u53cc\u51fb\u586b\u5355\u5931\u8d25" + e.getMessage());
                }
            }
        });
        this.outstandingShare.setCellFactory(data -> new NumberTableCell());
        this.detail.setCellFactory(data -> new OperaCell((TableView<ObIssueInfoPurchaseNeeq>)this.tableView));
        this.tableView.setPlaceholder((Node)new Label());
        this.defaultSort();
        this.tableView.setItems(this.mxList.getPageList());
    }

    public void queryDetail() {
        try {
            List<SingleOrder> successOrders;
            ObIssueInfoPurchaseNeeq item;
            NeeqIssueDetailDialog obj = (NeeqIssueDetailDialog)((Object)this.of.create(NeeqIssueDetailDialog.class));
            ObservableList data = FxUtils.newList();
            List<RfqResult> list = this.rfqModel.getListById(((ObIssueInfoPurchaseNeeq)this.tableView.getSelectionModel().getSelectedItem()).getIssueId());
            if (list.isEmpty()) {
                item = (ObIssueInfoPurchaseNeeq)this.tableView.getSelectionModel().getSelectedItem();
                successOrders = this.orderModel.getSuccessOrdersById(item.getIssueId());
                if (successOrders.isEmpty()) {
                    NeeqIssueDetail detail = new NeeqIssueDetail();
                    detail.update((Object)item);
                    detail.setIssueId(item.getIssueId());
                    detail.setSecurityId(item.getSecurityId());
                    detail.setSecurityName(item.getSecurityName());
                    detail.setInquiryStatus("\u672a\u8be2\u4ef7");
                    detail.setStatus("\u672a\u7533\u8d2d");
                    data.add((Object)detail);
                } else {
                    for (SingleOrder singleOrder : successOrders) {
                        NeeqIssueDetail detail = new NeeqIssueDetail();
                        detail.update((Object)item);
                        detail.setIssueId(item.getIssueId());
                        detail.setSecurityId(item.getSecurityId());
                        detail.setSecurityName(item.getSecurityName());
                        detail.setInquiryStatus("\u672a\u8be2\u4ef7");
                        detail.setStatus("\u5df2\u7533\u8d2d");
                        detail.setInvestorId(singleOrder.getInvestorId());
                        detail.setInvestorsecId(singleOrder.getInvestorSecId());
                        data.add((Object)detail);
                    }
                }
            } else {
                for (RfqResult result : list) {
                    try {
                        NeeqIssueDetail detail = new NeeqIssueDetail();
                        detail.update((Object)result);
                        detail.update(this.tableView.getSelectionModel().getSelectedItem());
                        if (RfqStatus.kStatusCreated == result.getStatus()) {
                            detail.setInquiryStatus("\u8be2\u4ef7\u786e\u8ba4\u6709\u6548(\u8bf7\u5c65\u884c\u7533\u8d2d\u4e49\u52a1)");
                            detail.setQtyRange(String.valueOf(result.getMinQty()) + "--" + result.getMaxQty());
                            if (this.orderModel.hasEffectiveOrder(detail.getIssueId(), result.getInvestorId(), result.getInvestorSecId())) {
                                detail.setStatus("\u5df2\u7533\u8d2d");
                            } else {
                                detail.setStatus("\u672a\u7533\u8d2d");
                            }
                        } else if (RfqStatus.kStatusCanceled == result.getStatus()) {
                            detail.setInquiryStatus("\u8be2\u4ef7\u5931\u8d25");
                            detail.setStatus("\u7981\u6b62\u7533\u8d2d");
                        }
                        data.add((Object)detail);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e, (Throwable)e);
                    }
                }
                item = (ObIssueInfoPurchaseNeeq)this.tableView.getSelectionModel().getSelectedItem();
                successOrders = this.orderModel.getSuccessOrdersById(item.getIssueId());
                for (SingleOrder singleOrder : successOrders) {
                    NeeqIssueDetail detail = new NeeqIssueDetail();
                    detail.update((Object)item);
                    detail.setIssueId(item.getIssueId());
                    detail.setSecurityId(item.getSecurityId());
                    detail.setSecurityName(item.getSecurityName());
                    detail.setInquiryStatus("\u672a\u8be2\u4ef7");
                    detail.setStatus("\u5df2\u7533\u8d2d");
                    detail.setInvestorId(singleOrder.getInvestorId());
                    detail.setInvestorsecId(singleOrder.getInvestorSecId());
                    data.add((Object)detail);
                }
            }
            List collect = data.stream().distinct().collect(Collectors.toList());
            data.clear();
            data.addAll(collect);
            obj.setList((ObservableList<NeeqIssueDetail>)data);
            MxDialog dialog = this.df.create((DialogObj)obj, "\u8be6\u60c5");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getStartDate().compareTo(o1.getStartDate()));
    }

    private class OperaCell
    extends TableCell<ObIssueInfoPurchaseNeeq, String> {
        final Label detaiLab = new Label("\u8be6\u60c5");
        final HBox paddedLabel = new HBox();

        OperaCell(final TableView<ObIssueInfoPurchaseNeeq> table) {
            this.paddedLabel.setSpacing(20.0);
            this.detaiLab.setStyle("-fx-cursor:hand;");
            this.detaiLab.getStyleClass().add((Object)"text-blue");
            this.paddedLabel.getChildren().add((Object)this.detaiLab);
            HBox.setMargin((Node)this.detaiLab, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
            this.detaiLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    NeeqCanApplicationStockPart.this.queryDetail();
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

