/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view.distribution.business;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleNoZeroSpinnerCtrl;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.NumberTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.IUIService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.IssueConverter;
import cms.tmx.data.utils.IssueSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.NewCcsSingleEntrust;
import cms.tmx.http.data.IssueInfo;
import cms.tmx.http.neeq.RfqResult;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.neeq.model.NeeqCreationModel;
import cms.tmx.neeq.model.NeeqRfqResultModel;
import cms.tmx.neeq.model.distribution.business.NeeqApplicationOrderModel;
import cms.tmx.neeq.model.distribution.business.NeeqApplicationPurchaseTradeBaseModel;
import cms.tmx.neeq.model.distribution.business.UserPreCtrlPurchase;
import cms.tmx.neeq.view.LoadPartModel;
import cms.tmx.neeq.view.NeeqEntrustConfirmDialog;
import cms.tmx.trade.utils.TradeAcctCountFilter;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IIssueMng;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

public class NeeqApplicationPurchaseBasePart
extends MxPart {
    @FXML
    protected TextField txtCode;
    @FXML
    protected TextField txtCodeInstrument;
    @FXML
    protected TextField textAccCount;
    @FXML
    protected TextField txtSearch;
    @FXML
    protected Spinner<Double> priceSpn;
    @FXML
    protected Spinner<Integer> quantitySpn;
    @FXML
    protected Label lbSecAccCount;
    @FXML
    protected Label lbQty;
    @FXML
    protected Label lbDate;
    @FXML
    protected Label lbEffectivePrice;
    @FXML
    protected Label minQty;
    @FXML
    protected Label maxQty;
    @FXML
    protected Label canQty;
    @FXML
    protected TreeTableView<CcsAccountDistribution> acctTreeTable;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Boolean> checkBoxCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, SecAccount> secAcctCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> availableCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> assetCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> weightCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> amountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canBuyCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canSellCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, String> productCol;
    @FXML
    protected Button btnOrder;
    @FXML
    protected ComboBox<MxNode> cmbAccFilter;
    @FXML
    protected ComboBox<MxNode> cmbDist;
    @FXML
    protected HBox hBoxPartlyAccCount;
    @FXML
    protected GridPane gridPanel;
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    protected IIssueMng issueMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected NeeqApplicationPurchaseTradeBaseModel neeqModel;
    @Inject
    protected UserPreCtrlPurchase preModel;
    @Inject
    protected DialogFactory df;
    @Inject
    protected UserPreOrderTips setTips;
    @Inject
    protected IUIService uiService;
    @Inject
    protected NeeqRfqResultModel rfqModel;
    @Inject
    protected NeeqApplicationOrderModel orderModel;
    @Inject
    protected NeeqCreationModel creationModel;
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    protected IssueInfo issueInfo;
    private IssueConverter secCvt;
    private String confirmSymbol = "";
    protected boolean isPstEvent = false;
    protected boolean priceSettle = false;
    protected String partType = "";
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 2);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected DoubleNoZeroSpinnerCtrl ctrlProctedPrice = new DoubleNoZeroSpinnerCtrl(true, 6, 2);
    protected AutoCompletion<IssueInfo> autoCompletionNormal;
    protected IssueSuggest spCode = new IssueSuggest();
    private MEventHandler hSetPst = event -> {
        if (this.autoCompletionNormal == null) {
            return;
        }
        String code = event.getStr("issue_code");
        this.txtCodeInstrument.setText(code);
        IssueInfo info = null;
        for (IssueInfo item : this.getRefItems()) {
            if (!code.equals(item.getSecurity().getInstrument().getSecurityId())) continue;
            info = item;
            break;
        }
        this.txtCodeInstrument.setUserData(info);
        if (code.equals(this.autoCompletionNormal.changedProperty().get())) {
            this.onSecurityChange(this.txtCodeInstrument, code);
        } else {
            this.autoCompletionNormal.setChange(code);
        }
    };
    private InvalidationListener listener = ob -> {
        List<IssueInfo> list = this.getRefItems();
        this.spCode.setAllSuggestions(list);
    };
    private ListChangeListener<TreeItem<CcsAccountDistribution>> lst = ob -> {
        if (ob.getList().size() != 0) {
            this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)((TreeItem)ob.getList().get(0)));
        }
    };
    private Callback<TreeTableColumn<CcsAccountDistribution, Boolean>, TreeTableCell<CcsAccountDistribution, Boolean>> checkBoxFactory = p -> new TreeTableCell<CcsAccountDistribution, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    treeItem.getChildren().addListener(NeeqApplicationPurchaseBasePart.this.lst);
                    if (treeItem.isLeaf()) {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((CcsAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV != false && treeItem.getParent().isExpanded());
                            } else {
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
                            }
                        });
                        checkBox.setOnMouseClicked(event -> NeeqApplicationPurchaseBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem));
                        NeeqApplicationPurchaseBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem);
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    } else {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                            if (newV.booleanValue()) {
                                NeeqApplicationPurchaseBasePart.this.acctTreeTable.refresh();
                            }
                        });
                        treeItem.expandedProperty().addListener((ob, old, newV) -> NeeqApplicationPurchaseBasePart.this.acctTreeTable.refresh());
                        checkBox.setOnMouseClicked(event -> treeItem.getChildren().forEach(each -> ((CcsAccountDistribution)each.getValue()).setSelected(((CcsAccountDistribution)treeItem.getValue()).isSelected())));
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected());
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                }
            }
        }
    };
    @Inject
    protected LoadPartModel load;

    @Inject
    public NeeqApplicationPurchaseBasePart() {
    }

    public void onShowEvent(MEvent event) {
    }

    @PreDestroy
    private void close() {
        this.issueMng.changedProperty().removeListener(this.listener);
        this.es.unSubscribe("neeq.fast.order", this.hSetPst);
    }

    @FXML
    public void initialize() {
        this.neeqModel.create("4");
        this.initUserPre();
        this.initControls();
        this.createAcctTree();
        this.initListener();
    }

    private void initListener() {
        this.issueMng.changedProperty().addListener(this.listener);
        this.es.subscribe("neeq.fast.order", this.hSetPst);
    }

    protected List<IssueInfo> getRefItems() {
        List list = this.issueMng.getIssuesByType("NEEQ", "F");
        return list;
    }

    protected void initControls() {
        this.secCvt = (IssueConverter)this.of.create(IssueConverter.class);
        this.spCode.setAllSuggestions(this.getRefItems());
        this.autoCompletionNormal = Search.bindAutoCompletion((TextField)this.txtCodeInstrument, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormal.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            this.onSecurityChange(this.txtCodeInstrument, (String)newV);
            this.acctTreeTable.refresh();
            this.layout();
        }));
        this.txtCodeInstrument.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCodeInstrument.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeInstrumentKeyPress((KeyEvent)event));
        this.txtCodeInstrument.textProperty().bindBidirectional((Property)this.neeqModel.insrumentIdProperty());
        this.txtCodeInstrument.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.setDisable(true);
        this.txtCode.textProperty().bindBidirectional((Property)this.neeqModel.underlyingIdProperty());
        this.ctrlPrice.ctrl(this.priceSpn);
        this.ctrlPrice.setUnit(0.01);
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.neeqModel.priceProperty());
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setText("");
        MxBindings.bindSI((Property)this.canQty.textProperty(), (Property)this.neeqModel.issueQtyProperty());
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.quantitySpn);
        this.ctrlCount.ctrl(this.quantitySpn);
        MxBindings.bindSI((Property)this.quantitySpn.getEditor().textProperty(), (Property)this.neeqModel.countProperty());
        this.quantitySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> Platform.runLater(() -> this.quantityKeyPress((KeyEvent)event)));
        this.quantitySpn.getEditor().setOnMouseClicked(event -> this.quantitySpn.getEditor().selectAll());
        this.neeqModel.getAccDisModel().secChangeProperty().addListener((ob, old, now) -> {
            List<RfqResult> rfqResults;
            if (this.issueInfo == null) {
                this.minQty.setText(" - -");
                this.maxQty.setText(" - -");
                return;
            }
            String investorId = "";
            String investorSecId = "";
            int selectNum = this.neeqModel.getAccDisModel().getSelectedNum();
            if (selectNum == 1) {
                investorId = this.neeqModel.getAccDisModel().getSelectInvestorId();
                investorSecId = this.neeqModel.getAccDisModel().getSelectInvestorSecId();
            }
            if ((rfqResults = this.rfqModel.getSuccessList(this.issueInfo.getSecurity().getInstrument().getSecurityId())).isEmpty() || investorId.isEmpty()) {
                this.minQty.setText(StringUtils.formatDouble((Double)this.issueInfo.getParams().getQtyLowerLimit()));
                this.maxQty.setText(StringUtils.formatDouble((Double)this.issueInfo.getParams().getQtyUpperLimit()));
                this.acctTreeTable.setDisable(false);
            } else {
                boolean set = false;
                for (RfqResult rfqResult : rfqResults) {
                    if (!investorId.equals(rfqResult.getInvestorId()) || !investorSecId.equals(rfqResult.getInvestorSecId())) continue;
                    this.minQty.setText(StringUtils.formatDouble((Double)rfqResult.getMinQty()));
                    this.maxQty.setText(StringUtils.formatDouble((Double)rfqResult.getMaxQty()));
                    set = true;
                    break;
                }
                if (!set) {
                    this.minQty.setText(StringUtils.formatDouble((Double)this.issueInfo.getParams().getQtyLowerLimit()));
                    this.maxQty.setText(StringUtils.formatDouble((Double)this.issueInfo.getParams().getQtyUpperLimit()));
                    this.acctTreeTable.setDisable(false);
                }
            }
        });
    }

    protected void afterTableRestore() {
        this.canBuyCol.setVisible(false);
        this.canSellCol.setVisible(false);
    }

    protected void createAcctTree() {
        this.cmbDist.setItems(this.neeqModel.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.neeqModel.distStgProperty());
        this.cmbAccFilter.setItems(this.neeqModel.getAccFilterStg().getNodes());
        this.cmbAccFilter.valueProperty().bindBidirectional(this.neeqModel.accFilterStgProperty());
        this.hBoxPartlyAccCount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.neeqModel.getAccFilterStg().getRaw().equals("1"), (Observable[])new Observable[]{this.neeqModel.accFilterStgProperty()}));
        MxBindings.bindSI((Property)this.lbSecAccCount.textProperty(), (Property)this.neeqModel.getAccDisModel().effectiveSecAccCountProperty());
        MxBindings.bindSI((Property)this.textAccCount.textProperty(), (Property)this.neeqModel.getAccDisModel().customSecAccCountProperty());
        this.textAccCount.setTextFormatter(new TextFormatter((UnaryOperator)new TradeAcctCountFilter(true, 9, this.neeqModel.getAccDisModel().effectiveSecAccCountProperty())));
        this.txtSearch.textProperty().bindBidirectional((Property)this.neeqModel.getAccDisModel().searchSecProperty());
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.accountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccountCollapseCell());
        this.secAcctCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.availableCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().availableProperty());
        this.availableCol.setCellFactory(p -> new MoneyCell(2));
        this.canBuyCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canBuyProperty());
        this.canSellCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canSellProperty());
        this.canSellCol.setCellFactory(p -> new NumberTreeTableCell());
        this.canBuyCol.setEditable(false);
        this.canSellCol.setEditable(false);
        this.assetCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().newAssetAmtProperty());
        this.assetCol.setCellFactory(p -> new MoneyCell(2));
        this.weightCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(p -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).countProperty());
        this.amountCol.setCellFactory(p -> new NumberTreeTableCell());
        this.productCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleStringProperty("") : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().productNameProperty());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.acctTreeTable.setRoot(this.neeqModel.getAccDisModel().getRoot());
        this.acctTreeTable.setShowRoot(false);
        this.acctTreeTable.sort();
        this.acctTreeTable.refresh();
        this.acctTreeTable.setPlaceholder((Node)new Label());
        this.acctTreeTable.setEditable(true);
        this.availableCol.setEditable(false);
        this.assetCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.acctTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.neeqModel.getAccDisModel().refresh());
        itemCopy.setOnAction(event -> this.copy());
        this.acctTreeSupplement();
    }

    protected void acctTreeSupplement() {
        this.canBuyCol.setCellFactory(p -> new MoneyCell(0));
        TableUtils.orgnizeClmWidth(this.acctTreeTable);
    }

    protected void onPriceTypeChange() {
        this.priceSpn.getEditor().clear();
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCodeInstrument.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCodeInstrument.selectAll());
        }
    }

    private boolean qtyLoseFocus() {
        long count = this.neeqModel.getCount();
        if (count > 0L) {
            if (!this.countIsVaild(count)) {
                this.alert.alert(Alert.AlertType.WARNING, "\u7533\u8d2d\u6570\u91cf\u5fc5\u987b\u662f100\u7684\u6574\u6570\u500d");
                return false;
            }
            double min = 0.0;
            double max = 0.0;
            double can = 0.0;
            if (StringUtils.isDouble((String)this.minQty.getText())) {
                min = Double.parseDouble(this.minQty.getText());
            }
            if (StringUtils.isDouble((String)this.maxQty.getText())) {
                max = Double.parseDouble(this.maxQty.getText());
            }
            if (StringUtils.isDouble((String)this.canQty.getText())) {
                can = Double.parseDouble(this.canQty.getText());
            }
            if (this.issueInfo != null) {
                if (can == min) {
                    if ((double)count < min || (double)count > max) {
                        this.alert.alert(Alert.AlertType.WARNING, "\u7533\u8d2d\u6570\u91cf\u5fc5\u987b\u5728\u6709\u6548\u6570\u91cf\u8303\u56f4\u5185");
                        return false;
                    }
                } else if (can > min && can < max) {
                    if ((double)count < min || (double)count > can) {
                        this.alert.alert(Alert.AlertType.WARNING, "\u7533\u8d2d\u6570\u91cf\u5fc5\u987b\u5728\u6709\u6548\u6570\u91cf\u8303\u56f4\u5185");
                        return false;
                    }
                } else if (can == max) {
                    if ((double)count < min || (double)count > max) {
                        this.alert.alert(Alert.AlertType.WARNING, "\u7533\u8d2d\u6570\u91cf\u5fc5\u987b\u5728\u6709\u6548\u6570\u91cf\u8303\u56f4\u5185");
                        return false;
                    }
                } else if (can > max && ((double)count < min || (double)count > max)) {
                    this.alert.alert(Alert.AlertType.WARNING, "\u7533\u8d2d\u6570\u91cf\u5fc5\u987b\u5728\u6709\u6548\u6570\u91cf\u8303\u56f4\u5185");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean countIsVaild(long count) {
        return count % 100L == 0L;
    }

    protected void onSecurityChange(TextField txtCode, String newText) {
        this.txtCodeInstrument.setText(txtCode.getText());
        Object obj = txtCode.getUserData();
        this.issueInfo = obj instanceof IssueInfo ? (IssueInfo)IssueInfo.class.cast(obj) : null;
        long beginChange = System.currentTimeMillis();
        this.doChange(this.issueInfo, newText);
        this.logger.info("dochange:" + (System.currentTimeMillis() - beginChange));
    }

    protected void setPrePrice() {
        if (this.neeqModel.getPrice() > 0.0 || this.priceSpn.isDisabled() || this.priceSettle) {
            return;
        }
    }

    protected void doChange(IssueInfo info, String newText) {
        block14: {
            this.neeqModel.setInfo(info);
            if (info != null) {
                List<RfqResult> rfqResults;
                this.txtCode.setText(String.valueOf(info.getParams().getUnderlying().getSecurityId()) + ":" + info.getSecurity().getInstrument().getSymbol());
                this.lbDate.setText(info.getParams().getStartDate());
                this.lbQty.setText(StringUtils.toStr((double)info.getParams().getOutstandingShare(), (int)1));
                this.lbEffectivePrice.setText(String.valueOf(String.format("%1$,.2f", info.getParams().getPriceLowerLimit())) + "--" + String.format("%1$,.2f", info.getParams().getPriceUpperLimit()));
                if (info.getParams().getPriceLowerLimit() == info.getParams().getPriceUpperLimit()) {
                    this.priceSpn.getValueFactory().setValue((Object)info.getParams().getPriceLowerLimit());
                    this.neeqModel.setPrice(info.getParams().getPriceLowerLimit());
                    this.priceSpn.setDisable(true);
                } else {
                    this.priceSpn.getEditor().clear();
                    this.priceSpn.setDisable(false);
                }
                String investorId = "";
                String investorSecId = "";
                int selectNum = this.neeqModel.getAccDisModel().getSelectedNum();
                if (selectNum == 1) {
                    investorId = this.neeqModel.getAccDisModel().getSelectInvestorId();
                    investorSecId = this.neeqModel.getAccDisModel().getSelectInvestorSecId();
                }
                if ((rfqResults = this.rfqModel.getSuccessList(info.getSecurity().getInstrument().getSecurityId())).isEmpty() || investorId.isEmpty()) {
                    this.minQty.setText(StringUtils.formatDouble((Double)info.getParams().getQtyLowerLimit()));
                    this.maxQty.setText(StringUtils.formatDouble((Double)info.getParams().getQtyUpperLimit()));
                    this.acctTreeTable.setDisable(false);
                } else {
                    boolean set = false;
                    for (RfqResult rfqResult : rfqResults) {
                        if (!investorId.equals(rfqResult.getInvestorId()) || !investorSecId.equals(rfqResult.getInvestorSecId())) continue;
                        this.minQty.setText(StringUtils.formatDouble((Double)rfqResult.getMinQty()));
                        this.maxQty.setText(StringUtils.formatDouble((Double)rfqResult.getMaxQty()));
                        set = true;
                        break;
                    }
                    if (!set) {
                        this.minQty.setText(StringUtils.formatDouble((Double)info.getParams().getQtyLowerLimit()));
                        this.maxQty.setText(StringUtils.formatDouble((Double)info.getParams().getQtyUpperLimit()));
                        this.acctTreeTable.setDisable(false);
                    }
                }
                try {
                    if (rfqResults.isEmpty()) break block14;
                    for (RfqResult rfqResult : rfqResults) {
                        boolean hasEffectivePurchase = this.orderModel.hasEffectiveOrder(info.getSecurity().getInstrument().getSecurityId(), rfqResult.getInvestorId(), rfqResult.getInvestorSecId());
                        if (hasEffectivePurchase) continue;
                        this.neeqModel.getAccDisModel().clearSelect();
                        this.neeqModel.getAccDisModel().selectInvestorSec(rfqResult.getInvestorSecId(), "NEEQ");
                        this.acctTreeTable.setDisable(true);
                        this.minQty.setText(StringUtils.formatDouble((Double)rfqResult.getMinQty()));
                        this.maxQty.setText(StringUtils.formatDouble((Double)rfqResult.getMaxQty()));
                        this.alert.alert(Alert.AlertType.INFORMATION, "\u60a8\u5b58\u5728\u6709\u6548\u8be2\u4ef7\u59d4\u6258\uff0c\u5df2\u7ecf\u81ea\u52a8\u52fe\u9009\u8d44\u91d1\u8d26\u53f7\u548c\u80a1\u4e1c\u4ee3\u7801\uff0c\u8bf7\u4f7f\u7528\u8be5\u8d44\u91d1\u8d26\u53f7\u548c\u80a1\u4e1c\u4ee3\u7801\u5c65\u884c\u7533\u8d2d\u4e49\u52a1");
                        break;
                    }
                }
                catch (Exception e) {
                    this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u53d1\u884c\u4ee3\u7801" + newText + "\u662f\u5426\u6709\u6709\u6548\u7533\u8d2d\u51fa\u9519" + e.getMessage());
                    this.logger.error((Object)e, (Throwable)e);
                }
            } else {
                this.clearPanel();
            }
        }
        this.neeqModel.onSecChange();
        this.txtCodeInstrument.selectEnd();
        this.txtCodeInstrument.deselect();
        if (newText.length() >= 6) {
            this.check();
        }
        if (this.neeqModel.isValidRef()) {
            this.setPrePrice();
        }
        this.layout();
    }

    private void clearPanel() {
        this.txtCode.setText("");
        this.minQty.setText(" - -");
        this.maxQty.setText(" - -");
        this.lbDate.setText(" - -");
        this.lbQty.setText(" - -");
        this.lbEffectivePrice.setText(" - -");
        this.neeqModel.setPrice(0.0);
        this.priceSpn.getValueFactory().setValue((Object)0.0);
        this.priceSpn.setDisable(false);
        this.acctTreeTable.setDisable(false);
        this.quantitySpn.getEditor().clear();
    }

    private void check() {
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (NeeqApplicationPurchaseBasePart.this.txtCodeInstrument.getText().length() < 6) {
                    return;
                }
                Platform.runLater(() -> {
                    if (NeeqApplicationPurchaseBasePart.this.issueInfo == null) {
                        NeeqApplicationPurchaseBasePart.this.txtCode.setText(NeeqApplicationPurchaseBasePart.INVALID_CODE);
                    }
                });
            }
        };
        timer.schedule(task, 500L);
    }

    public boolean valid() {
        if (!this.qtyLoseFocus()) {
            return false;
        }
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.neeqModel.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        if (!this.priceValid()) {
            return false;
        }
        String tip4 = "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u6237\uff0c\u4ee5\u53ca\u4e00\u4e2a\u80a1\u4e1c\u4ee3\u7801\u8fdb\u884c\u7533\u8d2d";
        if (!this.alert.check(this.neeqModel.getAccDisModel().getSelectedNum() >= 1, Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        if (!this.alert.check(this.neeqModel.getCount() >= 0L && this.neeqModel.getAccDisModel().isCountValid() != false && this.countIsVaild(this.neeqModel.getCount()), Alert.AlertType.WARNING, tip5)) {
            return false;
        }
        String tip6 = "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u6237\uff0c\u4ee5\u53ca\u4e00\u4e2a\u80a1\u4e1c\u4ee3\u7801\u8fdb\u884c\u7533\u8d2d";
        return this.alert.check(this.neeqModel.getAccDisModel().getSelectedNum() < 2, Alert.AlertType.WARNING, tip6);
    }

    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(this.neeqModel.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    protected String getOrderInfo() {
        StringBuilder info = new StringBuilder();
        for (CcsAccountDistribution acc : this.neeqModel.getAccDisModel().getValidSecAcc()) {
            info.append("\n\u8d26\u53f7   " + acc.getSecAcc().getInverstorSecId() + " \u59d4\u6258\u6570\u91cf   " + acc.getCount());
        }
        return info.toString();
    }

    @FXML
    public void order() {
        this.neeqModel.getAccDisModel().getValidSecAcc();
        if (this.valid()) {
            List<NewCcsSingleEntrust> entrusts = this.neeqModel.getEntrustList(false);
            NeeqEntrustConfirmDialog obj = (NeeqEntrustConfirmDialog)((Object)this.of.create(NeeqEntrustConfirmDialog.class));
            if (!"4".equals(this.neeqModel.getAccDisModel().getInstructType()) && !"3".equals(this.neeqModel.getAccDisModel().getInstructType())) {
                obj.setInstruction(true);
                obj.setIssue(true);
            } else {
                obj.setExecution(true);
                obj.setIssue(true);
            }
            obj.setInstructionPanelType(this.neeqModel.getAccDisModel().getInstructType());
            obj.setUnit("\u80a1");
            obj.setList(entrusts);
            MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) ? "\u7533\u8d2d\u786e\u8ba4" : String.valueOf(this.confirmSymbol) + "\u786e\u8ba4");
            if (dialog.launch() == ButtonType.OK) {
                this.submitOrder();
            }
            this.layout();
        }
    }

    protected void submitOrder() {
        Result result = null;
        try {
            result = this.doAction();
            if (result.failed > 0) {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14" + result.getReason().toString());
            } else {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14");
            }
        }
        catch (Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25" + e.toString());
            this.logger.error("\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            this.logger.error("\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
    }

    protected Result doAction() throws MException {
        return this.neeqModel.submit((TreeItem<CcsAccountDistribution>)this.neeqModel.getAccDisModel().getRoot());
    }

    protected void fillInstruction() throws MException {
    }

    public void codeInstrumentKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.quantitySpn.requestFocus();
            key.consume();
        }
    }

    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCodeInstrument.requestFocus();
            this.txtCodeInstrument.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.order();
            key.consume();
        }
    }

    protected void onItemSelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            Platform.runLater(() -> this.clearSelection());
        }
    }

    protected void clearSelection() {
    }

    public void setPrice(double price) {
    }

    private void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.accountCol.getText()) + "\t" + this.secAcctCol.getText() + "\t" + this.availableCol.getText() + "\t" + this.assetCol.getText() + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + this.productCol.getText() + "\t" + '\n');
        for (TreeItem item : this.neeqModel.getAccDisModel().getRoot().getChildren()) {
            CcsAccountDistribution accDis = (CcsAccountDistribution)item.getValue();
            clipboardString.append(accDis.getAcc() + "\t" + "\t" + accDis.getAcc().getAvailable() + "\t" + accDis.getAcc().getNewAssetAmt() + "\t" + accDis.getWeight() + "\t" + accDis.getCount() + "\t" + accDis.getAcc().getProductName() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                CcsAccountDistribution secAccDis = (CcsAccountDistribution)subItem.getValue();
                clipboardString.append("\t" + secAccDis.getSecAcc() + "\t" + "\t" + "\t" + secAccDis.getWeight() + "\t" + secAccDis.getCount() + "\t" + "\t" + "\t" + '\n');
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private void doCheckChildrenSelected(TreeItem<CcsAccountDistribution> treeItem) {
        TreeItem prtItem = treeItem.getParent();
        Boolean isSelected = false;
        if (prtItem != null && prtItem.getValue() != null) {
            for (TreeItem eachItem : prtItem.getChildren()) {
                if (!((CcsAccountDistribution)eachItem.getValue()).isSelected()) continue;
                isSelected = true;
                break;
            }
            ((CcsAccountDistribution)prtItem.getValue()).setSelected(isSelected.booleanValue());
        }
    }

    public TreeTableView<CcsAccountDistribution> getAccTreeTable() {
        return this.acctTreeTable;
    }

    public void initUserPre() {
        this.preModel.setPart(this);
        try {
            this.preModel.doSet();
        }
        catch (MException mException) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    protected void clearInfo() {
        this.btnOrder.setDisable(true);
    }

    protected void onApprove(boolean isApprove) {
        this.txtCode.setDisable(true);
        this.btnOrder.setDisable(true);
        this.acctTreeTable.setDisable(isApprove);
        this.priceSpn.setDisable(true);
        this.quantitySpn.setDisable(true);
        this.cmbDist.setDisable(true);
        this.cmbAccFilter.setDisable(true);
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public Spinner<Integer> getQuantitySpn() {
        return this.quantitySpn;
    }

    public void setCount(Long buyQuantity) {
        this.neeqModel.setCount(buyQuantity);
    }

    public void setMoney(double value) {
        this.neeqModel.setMoney(value);
    }

    public void setCountPer(Double value) {
        this.neeqModel.setCountPer(value);
    }

    public void setAutoSlice(boolean slice, long size) {
        this.neeqModel.setAutoSlice(slice);
        this.neeqModel.setSliceSize(size);
    }

    public IssueInfo getValidRef() {
        return this.neeqModel.getValidRef();
    }

    public String getConfirmSymbol() {
        return this.confirmSymbol;
    }

    public void setConfirmSymbol(String confirmSymbol) {
        this.confirmSymbol = confirmSymbol;
    }

    public IssueInfo getIssueInfo() {
        return this.issueInfo;
    }

    public void setIssueInfo(IssueInfo issueInfo) {
        this.issueInfo = issueInfo;
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }

    private class MoneyCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class WeightCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((CcsAccountDistribution)this.getTreeTableRow().getItem()).isSecAccProperty());
            }
        }
    }
}

