/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view.distribution.business;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ObSingleOrderNeeq;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.neeq.model.distribution.business.NeeqApplicationOrderModel;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;

public class NeeqApplicationOrderPart
extends MxPagePart<SingleOrder, ObSingleOrderNeeq> {
    @FXML
    private TableColumn<ObSingleOrderNeeq, String> errInfo;
    @FXML
    private TableColumn<ObSingleOrderNeeq, Number> orderQty;
    @FXML
    private TableColumn<ObSingleOrderNeeq, Number> cumQty;
    @FXML
    private TableColumn<ObSingleOrderNeeq, Number> price;
    @FXML
    private TableColumn<ObSingleOrderNeeq, Number> avgPx;
    @Inject
    private NeeqApplicationOrderModel model;
    @Inject
    private MxAlert alert;

    protected boolean predicate(SingleOrder data) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = data.getInstrument().getSecurityId().toUpperCase();
        String name = data.getInstrument().getSymbol().toUpperCase();
        String issueId = data.getIssueId();
        String orderId = data.getExtOrderId();
        return code.contains(text) || orderId.contains(text) || name.contains(text) || issueId.contains(text);
    }

    @FXML
    protected void refresh() {
        try {
            this.model.query();
            this.tableView.refresh();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    protected List<SingleOrder> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.errInfo.setCellFactory(data -> new TooltipTableCell<ObSingleOrderNeeq, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSingleOrderNeeq)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.orderQty.setCellFactory(data -> new NumberTableCell());
        this.cumQty.setCellFactory(data -> new NumberTableCell());
        this.price.setCellFactory(data -> new DoubleTableCell());
        this.avgPx.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableView.setItems(this.mxList.getPageList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listOrder, (String)"\u7533\u8d2d\u59d4\u6258\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
    }
}

