/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.neeq.view.distribution.business;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ObCreationNeeq;
import cms.tmx.http.neeq.Creation;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.neeq.model.NeeqCreationModel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;

public class NeeqApplicationDealPart
extends MxPagePart<Creation, ObCreationNeeq> {
    @FXML
    private TableColumn<ObCreationNeeq, Number> avgPx;
    @FXML
    private TableColumn<ObCreationNeeq, Number> cumQty;
    @Inject
    private NeeqCreationModel model;
    @Inject
    private MxAlert alert;
    @FXML
    private DatePicker startDate;
    @FXML
    private DatePicker endDate;
    protected static final String FORMAT = "yyyyMMdd";
    protected static DateFormat df = new SimpleDateFormat("yyyyMMdd");

    protected void initialize() {
        this.setDate();
        super.initialize();
    }

    protected void setDate() {
        DatePickerUtils.setDateLimit((DatePicker)this.startDate, (DatePicker)this.endDate, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.startDate, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDate, (String)FORMAT);
        LocalDate ldBegin = LocalDate.now().minusDays(30L);
        this.startDate.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDate.setValue((Object)ldEnd);
    }

    @FXML
    protected void refresh() {
        try {
            LocalDate startValue = (LocalDate)this.startDate.getValue();
            LocalDate endValue = (LocalDate)this.endDate.getValue();
            Period between = Period.between(startValue, endValue);
            if (between.getDays() > 0 && between.getMonths() >= 1) {
                this.alert.alert(Alert.AlertType.ERROR, "\u53ea\u5141\u8bb8\u67e5\u8be2\u4e00\u4e2a\u6708\u7684\u7533\u8d2d\u7ed3\u679c");
                return;
            }
            this.model.setStartDate(startValue.toString().replaceAll("-", ""));
            this.model.setEndDate(endValue.toString().replaceAll("-", ""));
            this.model.query();
            this.tableView.refresh();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    protected boolean predicate(Creation data) {
        String code;
        String text = this.searchText.getText().trim().toUpperCase();
        String instrumentId = data.getInstrument().getSecurityId();
        String name = data.getInstrument().getSymbol().toUpperCase();
        if (data.getUnderlying() != null && (code = data.getUnderlying().getSecurityId().toUpperCase()).contains(text)) {
            return true;
        }
        return instrumentId.contains(text) || name.contains(text);
    }

    protected List<Creation> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.cumQty.setCellFactory(data -> new NumberTableCell());
        this.avgPx.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getTradeTime().compareTo(o1.getTradeTime()));
        this.tableView.setItems(this.mxList.getPageList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listOrder, (String)"\u7533\u8d2d\u7ed3\u679c\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getTradeTime().compareTo(o1.getTradeTime()));
    }
}

